/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.binaries.nodejs;

import com.google.common.collect.ImmutableList;
import com.google.inject.Singleton;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.binaries.nodejs.NpmBinary;
import org.eclipse.n4js.binaries.nodejs.NpmrcBinary;
import org.eclipse.n4js.utils.OSInfo;

@Singleton
public class NodeProcessBuilder {
    private static final String NPM_COMMAND_INSTALL = "install";
    private static final String NPM_COMMAND_UNINSTALL = "uninstall";
    private static final String NPM_OPTION_SAVE = "--save";
    private static final String[] WIN_SHELL_COMAMNDS = new String[]{"cmd", "/c"};
    private static final String[] NIX_SHELL_COMAMNDS = new String[]{"sh", "-c"};
    @Inject
    private Provider<NpmBinary> npmBinaryProvider;
    @Inject
    private Provider<NpmrcBinary> npmrcBinaryProvider;

    public ProcessBuilder getNpmInstallProcessBuilder(File invocationPath, String packageName, boolean save) {
        ProcessBuilder pb = this.simpleCall(invocationPath, packageName, save, NPM_COMMAND_INSTALL);
        Binary npmrc = (Binary)this.npmrcBinaryProvider.get();
        npmrc.updateEnvironment(pb.environment());
        return pb;
    }

    public ProcessBuilder getNpmUninstallProcessBuilder(File invocationPath, String packageName, boolean save) {
        return this.simpleCall(invocationPath, packageName, save, NPM_COMMAND_UNINSTALL);
    }

    public ProcessBuilder getNpmCacheCleanProcessBuilder(File invokationPath) {
        ImmutableList.Builder builder = ImmutableList.builder();
        NpmBinary npmBinary = (NpmBinary)this.npmBinaryProvider.get();
        if (OSInfo.isWindows()) {
            builder.add((Object[])WIN_SHELL_COMAMNDS);
            builder.add((Object[])new String[]{this.escapeBinaryPath(npmBinary.getBinaryAbsolutePath()), "cache", "clean", "--force"});
        } else {
            builder.add((Object[])NIX_SHELL_COMAMNDS);
            builder.add((Object)(String.valueOf(this.escapeBinaryPath(npmBinary.getBinaryAbsolutePath())) + " cache clean --force"));
        }
        return this.create((List<String>)builder.build(), npmBinary, invokationPath, false);
    }

    private ProcessBuilder simpleCall(File invokationPath, String packageName, boolean save, String simpleCommand) {
        String resolvedPackageName;
        ImmutableList.Builder builder = ImmutableList.builder();
        NpmBinary npmBinary = (NpmBinary)this.npmBinaryProvider.get();
        String saveCommand = save ? NPM_OPTION_SAVE : "";
        String string = resolvedPackageName = packageName == null ? "" : packageName;
        if (OSInfo.isWindows()) {
            builder.add((Object[])WIN_SHELL_COMAMNDS);
            builder.add((Object[])new String[]{this.escapeBinaryPath(npmBinary.getBinaryAbsolutePath()), simpleCommand, resolvedPackageName, saveCommand});
        } else {
            builder.add((Object[])NIX_SHELL_COMAMNDS);
            builder.add((Object)(String.valueOf(this.escapeBinaryPath(npmBinary.getBinaryAbsolutePath())) + " " + simpleCommand + " " + resolvedPackageName + " " + saveCommand));
        }
        return this.create((List<String>)builder.build(), npmBinary, invokationPath, false);
    }

    public ProcessBuilder createVersionCheckProcess(Binary binary) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (OSInfo.isWindows()) {
            builder.add((Object[])WIN_SHELL_COMAMNDS);
        } else {
            builder.add((Object[])NIX_SHELL_COMAMNDS);
        }
        builder.add((Object)(String.valueOf(this.escapeBinaryPath(binary.getBinaryAbsolutePath())) + " " + binary.getVersionArgument()));
        return this.create((List<String>)builder.build(), binary, null, false);
    }

    private ProcessBuilder create(List<String> commands, Binary binary, File workingDirectory, boolean redirectErrorStream) {
        ProcessBuilder processBuilder = new ProcessBuilder(commands);
        processBuilder.redirectErrorStream(redirectErrorStream);
        binary.updateEnvironment(processBuilder.environment());
        if (workingDirectory != null) {
            processBuilder.directory(workingDirectory);
        }
        return processBuilder;
    }

    private String escapeBinaryPath(String path) {
        return "\"" + path + "\"";
    }
}

