/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.n4JS.EmptyStatement;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.ScriptElement;
import org.eclipse.n4js.organize.imports.ImportProvidedElement;
import org.eclipse.n4js.organize.imports.ImportSpecifiersUtil;
import org.eclipse.n4js.organize.imports.ImportStateCalculator;
import org.eclipse.n4js.organize.imports.RecordingImportState;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.ModuleNamespaceVirtualType;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.utils.Log;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

@Log
public class N4JSImportValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    private ImportStateCalculator importStateCalculator;
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;
    private static final Logger logger = Logger.getLogger(N4JSImportValidator.class);

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkMultipleDefaultExports(Script script) {
        Functions.Function1 _function = it -> it.isDefaultExport();
        List defaultExports = IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)script.eAllContents(), ExportDeclaration.class), (Functions.Function1)_function));
        Consumer<ExportDeclaration> _function_1 = it -> this.addIssue(IssueCodes.getMessageForIMP_DUPLICATE_DEFAULT_EXPORT(), (EObject)it, (EStructuralFeature)N4JSPackage.eINSTANCE.getExportDeclaration_DefaultExport(), "IMP_DUPLICATE_DEFAULT_EXPORT", new String[0]);
        IterableExtensions.tail((Iterable)defaultExports).forEach(_function_1);
    }

    @Check
    public void checkConflictingImports(Script script) {
        HashMap eObjectToIssueCode = CollectionLiterals.newHashMap();
        this.analyzeAndCheckConflictingImports(script, eObjectToIssueCode);
        this.markScatteredImports(script);
    }

    @Check
    public void checkStaticVsDynamicImport(NamespaceImportSpecifier importSpecifier) {
        Type type = importSpecifier.getDefinedType();
        if (type instanceof ModuleNamespaceVirtualType) {
            boolean _tripleNotEquals;
            TModule _module = ((ModuleNamespaceVirtualType)type).getModule();
            boolean bl = _tripleNotEquals = _module != null;
            if (_tripleNotEquals) {
                boolean _isDeclaredDynamic = importSpecifier.isDeclaredDynamic();
                if (_isDeclaredDynamic) {
                    boolean _isN4JSMode = this.jsVariantHelper.isN4JSMode((EObject)((ModuleNamespaceVirtualType)type).getModule());
                    if (_isN4JSMode) {
                        this.addIssue(IssueCodes.getMessageForIMP_DYNAMIC_NAMESPACE_IMPORT_N4JS(((ModuleNamespaceVirtualType)type).getModule().getModuleSpecifier()), (EObject)importSpecifier, "IMP_DYNAMIC_NAMESPACE_IMPORT_N4JS");
                    } else {
                        boolean _isExternalMode = this.jsVariantHelper.isExternalMode((EObject)((ModuleNamespaceVirtualType)type).getModule());
                        if (_isExternalMode) {
                            this.addIssue(IssueCodes.getMessageForIMP_DYNAMIC_NAMESPACE_IMPORT_N4JSD(((ModuleNamespaceVirtualType)type).getModule().getModuleSpecifier()), (EObject)importSpecifier, "IMP_DYNAMIC_NAMESPACE_IMPORT_N4JSD");
                        }
                    }
                } else {
                    boolean _isPlainJS = this.jsVariantHelper.isPlainJS((EObject)((ModuleNamespaceVirtualType)type).getModule());
                    if (_isPlainJS) {
                        this.addIssue(IssueCodes.getMessageForIMP_STATIC_NAMESPACE_IMPORT_PLAIN_JS(((ModuleNamespaceVirtualType)type).getModule().getModuleSpecifier()), (EObject)importSpecifier, "IMP_STATIC_NAMESPACE_IMPORT_PLAIN_JS");
                    }
                }
            }
        }
    }

    private void analyzeAndCheckConflictingImports(Script script, Map<EObject, String> eObjectToIssueCode) {
        RecordingImportState reg = this.importStateCalculator.calculateImportstate(script);
        Consumer<Pair> _function = it -> this.handleDuplicatedImportDeclarations((Pair<ImportDeclaration, List<ImportDeclaration>>)it, eObjectToIssueCode);
        reg.duplicatedImportDeclarations.forEach(_function);
        this.handleNameCollisions(reg.localNameCollision, eObjectToIssueCode);
        this.handleTypeCollisions(reg.duplicateImportsOfSameElement, eObjectToIssueCode);
        this.handleBrokenImports(reg.brokenImports, eObjectToIssueCode);
        this.handleUnusedImports(reg.unusedImports, eObjectToIssueCode);
        this.handleNotImportedTypeRefs(script, IterableExtensions.toList((Iterable)Iterables.filter(eObjectToIssueCode.keySet(), ImportSpecifier.class)), eObjectToIssueCode);
    }

    private void handleBrokenImports(List<ImportSpecifier> importSpecifiers, Map<EObject, String> eObjectToIssueCode) {
        for (ImportSpecifier is : importSpecifiers) {
            boolean _not;
            boolean _contains = eObjectToIssueCode.keySet().contains(is);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            this.addIssueUnresolved(is, eObjectToIssueCode);
        }
    }

    private void handleUnusedImports(List<ImportSpecifier> importSpecifiers, Map<EObject, String> eObjectToIssueCode) {
        for (ImportSpecifier is : importSpecifiers) {
            boolean _not;
            boolean _contains = eObjectToIssueCode.keySet().contains(is);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            this.addIssueUnusedImport(is, eObjectToIssueCode);
        }
    }

    private String computeImportSpecifierName(NamedImportSpecifier spec) {
        String _xifexpression = null;
        boolean _isBrokenImport = ImportSpecifiersUtil.isBrokenImport((ImportSpecifier)spec);
        _xifexpression = _isBrokenImport ? NodeModelUtils.findActualNodeFor((EObject)spec).getText().trim() : ImportSpecifiersUtil.importedElementName(spec);
        return _xifexpression;
    }

    private void markScatteredImports(Script script) {
        boolean stillInHeader = true;
        EList _scriptElements = script.getScriptElements();
        for (ScriptElement se : _scriptElements) {
            if (stillInHeader) {
                boolean _not;
                boolean bl = _not = !(se instanceof ImportDeclaration) && !(se instanceof EmptyStatement) && !N4JSASTUtils.isStringLiteralExpression((ScriptElement)se);
                if (!_not) continue;
                stillInHeader = false;
                continue;
            }
            if (!(se instanceof ImportDeclaration)) continue;
            this.handleScatteredImport((ImportDeclaration)se);
        }
    }

    private void handleScatteredImport(ImportDeclaration importDecl) {
        this.addIssueScatteredImport(importDecl);
    }

    private void handleDuplicatedImportDeclarations(Pair<ImportDeclaration, List<ImportDeclaration>> duplicatePair, Map<EObject, String> eObjectToIssueCode) {
        ImportSpecifier specifier = (ImportSpecifier)IterableExtensions.head((Iterable)((ImportDeclaration)duplicatePair.getKey()).getImportSpecifiers());
        List duplicates = (List)duplicatePair.getValue();
        Consumer<ImportDeclaration> _function = duplicateImportDeclaration -> {
            boolean _matched_1;
            ImportSpecifier duplicate = (ImportSpecifier)IterableExtensions.head((Iterable)duplicateImportDeclaration.getImportSpecifiers());
            boolean _matched = false;
            if (specifier instanceof NamespaceImportSpecifier) {
                _matched = true;
                _matched_1 = false;
                if (duplicate instanceof NamespaceImportSpecifier) {
                    _matched_1 = true;
                    this.addIssueDuplicateNamespaceImportDeclaration((NamespaceImportSpecifier)specifier, (NamespaceImportSpecifier)duplicate, (ImportDeclaration)duplicateImportDeclaration, eObjectToIssueCode);
                }
                if (!_matched_1) {
                    logger.error((Object)"cannot register duplicate import declaration for different kinds of specifiers");
                }
            }
            if (!_matched && specifier instanceof NamedImportSpecifier) {
                _matched = true;
                _matched_1 = false;
                if (duplicate instanceof NamedImportSpecifier) {
                    _matched_1 = true;
                    this.addIssueDuplicateNamedImportDeclaration((NamedImportSpecifier)specifier, (NamedImportSpecifier)duplicate, (ImportDeclaration)duplicateImportDeclaration, eObjectToIssueCode);
                }
                if (!_matched_1) {
                    logger.error((Object)"cannot register duplicate import declaration for different kinds of specifiers");
                }
            }
            if (!_matched) {
                logger.error((Object)"cannot register duplicate import declaration for  specifiers");
            }
        };
        duplicates.forEach(_function);
    }

    private void handleNameCollisions(List<Pair<String, List<ImportProvidedElement>>> multimap, Map<EObject, String> eObjectToIssueCode) {
        Consumer<Pair> _function = pair -> {
            String _plus;
            String name = (String)pair.getKey();
            List providers = (List)pair.getValue();
            ImportSpecifier first = ((ImportProvidedElement)IterableExtensions.head((Iterable)providers)).getImportSpecifier();
            Pair _switchResult = null;
            boolean _matched = false;
            if (first instanceof NamespaceImportSpecifier) {
                _matched = true;
                String _string = ImportSpecifiersUtil.importedModule(first).getQualifiedName().toString();
                _plus = "namespace name for " + _string;
                _switchResult = Pair.of((Object)name, (Object)_plus);
            }
            if (!_matched && first instanceof NamedImportSpecifier) {
                boolean _tripleNotEquals;
                _matched = true;
                Pair _xifexpression = null;
                String _alias = ((NamedImportSpecifier)first).getAlias();
                boolean bl = _tripleNotEquals = _alias != null;
                if (_tripleNotEquals) {
                    String _name = ((NamedImportSpecifier)first).getImportedElement().getName();
                    String _plus2 = "alias name for named import " + _name;
                    String _plus_1 = String.valueOf(_plus2) + " from ";
                    String _string = ImportSpecifiersUtil.importedModule(first).getQualifiedName().toString();
                    String _plus_2 = String.valueOf(_plus_1) + _string;
                    _xifexpression = Pair.of((Object)name, (Object)_plus_2);
                } else {
                    String _name_1 = ((NamedImportSpecifier)first).getImportedElement().getName();
                    String _plus_3 = "name for named import " + _name_1;
                    String _plus_4 = String.valueOf(_plus_3) + " from ";
                    String _string_1 = ImportSpecifiersUtil.importedModule(first).getQualifiedName().toString();
                    String _plus_5 = String.valueOf(_plus_4) + _string_1;
                    _xifexpression = Pair.of((Object)name, (Object)_plus_5);
                }
                _switchResult = _xifexpression;
            }
            if (!_matched) {
                String _name = ImportSpecifier.class.getName();
                _plus = "unhandled type of " + _name;
                logger.error((Object)_plus);
                throw new RuntimeException("Cannot validate local name collisions");
            }
            Pair name2reason = _switchResult;
            Consumer<ImportProvidedElement> _function_1 = importProvidedElement -> this.addLocalNameCollision(importProvidedElement.getImportSpecifier(), (String)name2reason.getKey(), (String)name2reason.getValue(), eObjectToIssueCode);
            IterableExtensions.tail((Iterable)providers).forEach(_function_1);
        };
        multimap.forEach(_function);
    }

    private void handleTypeCollisions(List<Pair<Pair<String, TModule>, List<ImportProvidedElement>>> duplicateslist, Map<EObject, String> eObjectToIssueCode) {
        Consumer<Pair> _function = duplicateEntry -> {
            Pair entry = (Pair)duplicateEntry.getKey();
            String entryName = (String)entry.getKey();
            TModule entryModule = (TModule)entry.getValue();
            List imports = (List)duplicateEntry.getValue();
            ImportSpecifier firstImportSpecifier = ((ImportProvidedElement)IterableExtensions.head((Iterable)imports)).getImportSpecifier();
            String _switchResult = null;
            boolean _matched = false;
            if (firstImportSpecifier instanceof NamespaceImportSpecifier) {
                _matched = true;
                String _alias = ((NamespaceImportSpecifier)firstImportSpecifier).getAlias();
                String _plus = String.valueOf(_alias) + ".";
                _switchResult = String.valueOf(_plus) + entryName;
            }
            if (!_matched && firstImportSpecifier instanceof NamedImportSpecifier) {
                _matched = true;
                String _elvis = null;
                String _alias = ((NamedImportSpecifier)firstImportSpecifier).getAlias();
                _elvis = _alias != null ? _alias : entryName;
                _switchResult = _elvis;
            }
            String firstImportName = _switchResult;
            boolean _xifexpression = false;
            if (firstImportSpecifier instanceof NamedImportSpecifier) {
                _xifexpression = ((NamedImportSpecifier)firstImportSpecifier).isDefaultImport();
            }
            boolean firstImportIsDefault = _xifexpression;
            Consumer<ImportProvidedElement> _function_1 = dupe -> {
                ImportSpecifier duplicateImportSpecifier = dupe.getImportSpecifier();
                if (firstImportIsDefault && duplicateImportSpecifier instanceof NamespaceImportSpecifier) {
                    this.addIssueDuplicate(firstImportSpecifier, entryName, entryModule, firstImportName, eObjectToIssueCode);
                }
                if (firstImportSpecifier instanceof NamespaceImportSpecifier && duplicateImportSpecifier instanceof NamespaceImportSpecifier) {
                    this.addIssueDuplicateNamespace((NamespaceImportSpecifier)duplicateImportSpecifier, (NamespaceImportSpecifier)firstImportSpecifier, eObjectToIssueCode);
                } else {
                    this.addIssueDuplicate(dupe.getImportSpecifier(), entryName, entryModule, firstImportName, eObjectToIssueCode);
                }
            };
            IterableExtensions.tail((Iterable)imports).forEach(_function_1);
        };
        duplicateslist.forEach(_function);
    }

    private void regUnresolvedImport(ParameterizedTypeRef ref, String name, Map<EObject, String> eObjectToIssueCode) {
        boolean _tripleEquals;
        String issueCode = "IMP_UNRESOLVED";
        String _put = eObjectToIssueCode.put((EObject)ref, "IMP_UNRESOLVED");
        boolean bl = _tripleEquals = _put == null;
        if (_tripleEquals) {
            String message = IssueCodes.getMessageForIMP_UNRESOLVED(name);
            this.addIssue(message, (EObject)ref, "IMP_UNRESOLVED");
        }
    }

    private void handleNotImportedTypeRefs(Script script, List<ImportSpecifier> specifiersWithIssues, Map<EObject, String> eObjectToIssueCode) {
        Functions.Function1 _function = it -> it.getImportedModule();
        Map importedProvidedElementsWithIssuesByModule = IterableExtensions.groupBy(ImportSpecifiersUtil.mapToImportProvidedElements(specifiersWithIssues), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> it.getDeclaredType() != null && it.getDeclaredType().getContainingModule() != null;
        Functions.Function1 _function_2 = it -> it.getDeclaredType().getContainingModule();
        Map potentiallyAffectedTypeRefs = IteratorExtensions.groupBy((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)script.eAllContents(), ParameterizedTypeRef.class), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
        BiConsumer<TModule, List> _function_3 = (module, typeRefs) -> {
            List conflict = (List)importedProvidedElementsWithIssuesByModule.get(module);
            if (conflict != null) {
                Consumer<ParameterizedTypeRef> _function_4 = typeRef -> {
                    String typeRefName = this.typeRefUsedName((ParameterizedTypeRef)typeRef);
                    Functions.Function1 _function_5 = ipe -> {
                        String _localName = ipe.getLocalName();
                        return Objects.equal((Object)_localName, (Object)typeRefName);
                    };
                    boolean _exists = IterableExtensions.exists((Iterable)conflict, (Functions.Function1)_function_5);
                    if (_exists) {
                        this.regUnresolvedImport((ParameterizedTypeRef)typeRef, typeRefName, eObjectToIssueCode);
                    }
                };
                typeRefs.forEach(_function_4);
            }
        };
        potentiallyAffectedTypeRefs.forEach(_function_3);
    }

    private String typeRefUsedName(ParameterizedTypeRef ref) {
        return NodeModelUtils.getTokenText((INode)NodeModelUtils.findActualNodeFor((EObject)ref));
    }

    private void addIssueScatteredImport(ImportDeclaration importDecl) {
        String issueCode = "IMP_DISCOURAGED_PLACEMENT";
        String message = IssueCodes.getMessageForIMP_DISCOURAGED_PLACEMENT();
        this.addIssue(message, (EObject)importDecl, "IMP_DISCOURAGED_PLACEMENT");
    }

    private String addLocalNameCollision(ImportSpecifier duplicate, String name, String reason, Map<EObject, String> eObjectToIssueCode) {
        boolean _tripleEquals;
        String _xblockexpression = null;
        String issueCode = "IMP_LOCAL_NAME_CONFLICT";
        String _xifexpression = null;
        String _get = eObjectToIssueCode.get(duplicate);
        boolean bl = _tripleEquals = _get == null;
        if (_tripleEquals) {
            String _xblockexpression_1 = null;
            String message = IssueCodes.getMessageForIMP_LOCAL_NAME_CONFLICT(name, reason);
            this.addIssue(message, (EObject)duplicate, "IMP_LOCAL_NAME_CONFLICT");
            _xifexpression = _xblockexpression_1 = eObjectToIssueCode.put((EObject)duplicate, "IMP_LOCAL_NAME_CONFLICT");
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private void addIssueDuplicateNamespaceImportDeclaration(NamespaceImportSpecifier specifier, NamespaceImportSpecifier duplicate, ImportDeclaration duplicateImportDeclaration, Map<EObject, String> eObjectToIssueCode) {
        boolean _tripleEquals;
        String issueCode = "IMP_STMT_DUPLICATE_NAMESPACE";
        String _get = eObjectToIssueCode.get(specifier);
        boolean bl = _tripleEquals = _get == null;
        if (_tripleEquals) {
            String message = IssueCodes.getMessageForIMP_STMT_DUPLICATE_NAMESPACE(specifier.getAlias(), ImportSpecifiersUtil.importedModule((ImportSpecifier)duplicate).getQualifiedName());
            this.addIssue(message, (EObject)duplicateImportDeclaration, "IMP_STMT_DUPLICATE_NAMESPACE");
        }
        Consumer<ImportSpecifier> _function = is -> eObjectToIssueCode.put((EObject)specifier, "IMP_STMT_DUPLICATE_NAMESPACE");
        duplicateImportDeclaration.getImportSpecifiers().forEach(_function);
    }

    private void addIssueDuplicateNamedImportDeclaration(NamedImportSpecifier specifier, NamedImportSpecifier duplicate, ImportDeclaration duplicateImportDeclaration, Map<EObject, String> eObjectToIssueCode) {
        boolean _tripleEquals;
        String issueCode = "IMP_STMT_DUPLICATE_NAMED";
        String _get = eObjectToIssueCode.get(specifier);
        boolean bl = _tripleEquals = _get == null;
        if (_tripleEquals) {
            String message = IssueCodes.getMessageForIMP_STMT_DUPLICATE_NAMED(ImportSpecifiersUtil.usedName(specifier), ImportSpecifiersUtil.importedModule((ImportSpecifier)duplicate).getQualifiedName());
            this.addIssue(message, (EObject)duplicateImportDeclaration, "IMP_STMT_DUPLICATE_NAMED");
        }
        Consumer<ImportSpecifier> _function = is -> eObjectToIssueCode.put((EObject)specifier, "IMP_STMT_DUPLICATE_NAMED");
        duplicateImportDeclaration.getImportSpecifiers().forEach(_function);
    }

    private String addIssueDuplicateNamespace(NamespaceImportSpecifier duplicateImportSpecifier, NamespaceImportSpecifier firstImportSpecifier, Map<EObject, String> eObjectToIssueCode) {
        boolean _tripleEquals;
        String _xifexpression = null;
        String _get = eObjectToIssueCode.get(duplicateImportSpecifier);
        boolean bl = _tripleEquals = _get == null;
        if (_tripleEquals) {
            String _xblockexpression = null;
            String issueCode = "IMP_DUPLICATE_NAMESPACE";
            String msg = IssueCodes.getMessageForIMP_DUPLICATE_NAMESPACE(ImportSpecifiersUtil.importedModule((ImportSpecifier)firstImportSpecifier).getQualifiedName(), firstImportSpecifier.getAlias());
            this.addIssue(msg, (EObject)duplicateImportSpecifier, "IMP_DUPLICATE_NAMESPACE");
            _xifexpression = _xblockexpression = eObjectToIssueCode.put((EObject)duplicateImportSpecifier, "IMP_DUPLICATE_NAMESPACE");
        }
        return _xifexpression;
    }

    private String addIssueDuplicate(ImportSpecifier specifier, String actualName, TModule module, String firstImportName, Map<EObject, String> eObjectToIssueCode) {
        boolean _tripleEquals;
        String _xblockexpression = null;
        String issueCode = "IMP_DUPLICATE";
        String _xifexpression = null;
        String _get = eObjectToIssueCode.get(specifier);
        boolean bl = _tripleEquals = _get == null;
        if (_tripleEquals) {
            String _xblockexpression_1 = null;
            String message = IssueCodes.getMessageForIMP_DUPLICATE(actualName, module.getQualifiedName(), firstImportName);
            this.addIssue(message, (EObject)specifier, issueCode);
            _xifexpression = _xblockexpression_1 = eObjectToIssueCode.put((EObject)specifier, issueCode);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private String addIssueUnresolved(ImportSpecifier specifier, Map<EObject, String> eObjectToIssueCode) {
        boolean _tripleEquals;
        String _xblockexpression = null;
        String issueCode = "IMP_UNRESOLVED";
        String _xifexpression = null;
        String _get = eObjectToIssueCode.get(specifier);
        boolean bl = _tripleEquals = _get == null;
        if (_tripleEquals) {
            String _xblockexpression_1 = null;
            String message = IssueCodes.getMessageForIMP_UNRESOLVED(this.computeUnusedOrUnresolvedMessage(specifier));
            this.addIssue(message, (EObject)specifier, issueCode);
            _xifexpression = _xblockexpression_1 = eObjectToIssueCode.put((EObject)specifier, issueCode);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private String addIssueUnusedImport(ImportSpecifier specifier, Map<EObject, String> eObjectToIssueCode) {
        boolean _tripleEquals;
        String _xblockexpression = null;
        String issueCode = "IMP_UNUSED_IMPORT";
        String _xifexpression = null;
        String _get = eObjectToIssueCode.get(specifier);
        boolean bl = _tripleEquals = _get == null;
        if (_tripleEquals) {
            String _xblockexpression_1 = null;
            String message = IssueCodes.getMessageForIMP_UNUSED_IMPORT(this.computeUnusedOrUnresolvedMessage(specifier));
            this.addIssue(message, (EObject)specifier, "IMP_UNUSED_IMPORT");
            _xifexpression = _xblockexpression_1 = eObjectToIssueCode.put((EObject)specifier, "IMP_UNUSED_IMPORT");
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private String computeUnusedOrUnresolvedMessage(ImportSpecifier specifier) {
        String _switchResult = null;
        boolean _matched = false;
        if (specifier instanceof NamedImportSpecifier) {
            _matched = true;
            _switchResult = this.computeImportSpecifierName((NamedImportSpecifier)specifier);
        }
        if (!_matched && specifier instanceof NamespaceImportSpecifier) {
            _matched = true;
            String _alias = ((NamespaceImportSpecifier)specifier).getAlias();
            String _plus = "* as " + _alias;
            String _plus_1 = String.valueOf(_plus) + " from ";
            String _computeModuleSpecifier = this.computeModuleSpecifier((NamespaceImportSpecifier)specifier);
            _switchResult = String.valueOf(_plus_1) + _computeModuleSpecifier;
        }
        return _switchResult;
    }

    private String computeModuleSpecifier(NamespaceImportSpecifier specifier) {
        String _xblockexpression = null;
        TModule importedModule = ImportSpecifiersUtil.importedModule((ImportSpecifier)specifier);
        String _xifexpression = null;
        _xifexpression = importedModule != null && !importedModule.eIsProxy() ? importedModule.getModuleSpecifier() : "module was a proxy";
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }
}

