/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.factories;

import java.util.LinkedList;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.factories.DelegatingNodeFactory;
import org.eclipse.n4js.flowgraphs.factories.ListUtils;
import org.eclipse.n4js.flowgraphs.factories.ReentrantASTIterator;
import org.eclipse.n4js.flowgraphs.model.CatchToken;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.DelegatingNode;
import org.eclipse.n4js.flowgraphs.model.HelperNode;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.n4JS.CatchBlock;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.FinallyBlock;
import org.eclipse.n4js.n4JS.TryStatement;

class TryFactory {
    TryFactory() {
    }

    static ComplexNode buildComplexNode(ReentrantASTIterator astpp, TryStatement tryStmt) {
        CatchToken ct;
        ComplexNode cNode = new ComplexNode(astpp.container(), (ControlFlowElement)tryStmt);
        HelperNode entryNode = new HelperNode("entry", astpp.pos(), (ControlFlowElement)tryStmt);
        DelegatingNode tryNode = null;
        DelegatingNode catchNode = null;
        DelegatingNode finallyNode = null;
        if (tryStmt.getBlock() != null) {
            tryNode = DelegatingNodeFactory.create(astpp, "try", (ControlFlowElement)tryStmt, (ControlFlowElement)tryStmt.getBlock());
        }
        if (tryStmt.getCatch() != null && tryStmt.getCatch().getBlock() != null) {
            CatchBlock catchClause = tryStmt.getCatch();
            ct = new CatchToken(ControlFlowType.Throw);
            catchNode = DelegatingNodeFactory.create(astpp, "catch", (ControlFlowElement)tryStmt, (ControlFlowElement)catchClause.getBlock());
            catchNode.addCatchToken(ct);
        }
        if (tryStmt.getFinally() != null && tryStmt.getFinally().getBlock() != null) {
            FinallyBlock finallyElem = tryStmt.getFinally();
            ct = new CatchToken(ControlFlowType.CatchesAll);
            finallyNode = DelegatingNodeFactory.create(astpp, "finally", (ControlFlowElement)tryStmt, (ControlFlowElement)finallyElem.getBlock());
            finallyNode.addCatchToken(ct);
        }
        HelperNode exitNode = new HelperNode("exit", astpp.pos(), (ControlFlowElement)tryStmt);
        cNode.addNode(entryNode);
        cNode.addNode(tryNode);
        cNode.addNode(catchNode);
        cNode.addNode(finallyNode);
        cNode.addNode(exitNode);
        LinkedList<Node> nodes = new LinkedList<Node>();
        nodes.add(entryNode);
        nodes.add(tryNode);
        nodes.add(finallyNode);
        nodes.add(exitNode);
        cNode.connectInternalSucc(nodes);
        cNode.connectInternalSucc(entryNode, catchNode);
        LinkedList<Node> parts = ListUtils.filterNulls(finallyNode, exitNode);
        Node tgtFrgmt = parts.getFirst();
        cNode.connectInternalSucc(tryNode, catchNode);
        cNode.connectInternalSucc(catchNode, tgtFrgmt);
        cNode.setEntryNode(entryNode);
        cNode.setExitNode(exitNode);
        return cNode;
    }
}

