/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.conversion;

import java.math.BigDecimal;
import org.eclipse.n4js.conversion.N4JSValueConverterException;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class ScientificIntValueConverter
extends AbstractLexerBasedConverter<BigDecimal> {
    protected String toEscapedString(BigDecimal value) {
        return value.toString();
    }

    protected void assertValidValue(BigDecimal value) {
        super.assertValidValue((Object)value);
        if (value.signum() == -1) {
            throw new N4JSValueConverterException(IssueCodes.getMessageForVCO_SCIINT_NEGATIVE(this.getRuleName(), value), "VCO_SCIINT_NEGATIVE", null, null);
        }
    }

    public BigDecimal toValue(String string, INode node) {
        if (Strings.isEmpty((String)string)) {
            throw new N4JSValueConverterException(IssueCodes.getMessageForVCO_SCIINT_CONVERT_EMPTY_STR(), "VCO_SCIINT_CONVERT_EMPTY_STR", node, null);
        }
        try {
            return new BigDecimal(string);
        }
        catch (NumberFormatException e) {
            throw new N4JSValueConverterException(IssueCodes.getMessageForVCO_SCIINT_CONVERT_STR(string), "VCO_SCIINT_CONVERT_STR", node, null);
        }
    }
}

