/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.members;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.MemberAccess;
import org.eclipse.n4js.ts.typeRefs.TypeRef;

public class MemberScopeRequest {
    public final TypeRef originalReceiverTypeRef;
    public final EObject context;
    public final boolean provideContainedMembers;
    public final boolean checkVisibility;
    public final boolean staticAccess;
    public final boolean structFieldInitMode;

    public MemberScopeRequest(TypeRef originalReceiverTypeRef, EObject context, boolean provideContainedMembers, boolean checkVisibility, boolean staticAccess, boolean structFieldInitMode) {
        if (provideContainedMembers && !(context instanceof MemberAccess)) {
            throw new IllegalStateException("member scoping can only guarantee to provide contained members if given a context of type " + MemberAccess.class.getSimpleName());
        }
        this.originalReceiverTypeRef = originalReceiverTypeRef;
        this.context = context;
        this.provideContainedMembers = provideContainedMembers;
        this.checkVisibility = checkVisibility;
        this.staticAccess = staticAccess;
        this.structFieldInitMode = structFieldInitMode;
    }

    public MemberScopeRequest enforceStatic() {
        if (this.staticAccess) {
            return this;
        }
        return new MemberScopeRequest(this.originalReceiverTypeRef, this.context, this.provideContainedMembers, this.checkVisibility, true, this.structFieldInitMode);
    }

    public MemberScopeRequest enforceInstance() {
        if (!this.staticAccess) {
            return this;
        }
        return new MemberScopeRequest(this.originalReceiverTypeRef, this.context, this.provideContainedMembers, this.checkVisibility, false, this.structFieldInitMode);
    }

    public MemberScopeRequest setStructFieldInitMode(boolean structFieldInitMode) {
        if (this.structFieldInitMode == structFieldInitMode) {
            return this;
        }
        return new MemberScopeRequest(this.originalReceiverTypeRef, this.context, this.provideContainedMembers, this.checkVisibility, this.staticAccess, structFieldInitMode);
    }
}

