/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import java.util.Comparator;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;

public class MembersByNameTypeAndAccessComparator
implements Comparator<TMember> {
    private final boolean ignoreTypes;

    public MembersByNameTypeAndAccessComparator(boolean ignoreTypes) {
        this.ignoreTypes = ignoreTypes;
    }

    @Override
    public int compare(TMember m1, TMember m2) {
        if (m1 == null || m1.getName() == null) {
            return 1;
        }
        if (m2 == null || m2.getName() == null) {
            return -1;
        }
        int c = m1.getName().compareTo(m2.getName());
        if (c == 0) {
            int _xifexpression = 0;
            _xifexpression = !this.ignoreTypes ? this.compareMemberType(m1, m2) : c;
            c = _xifexpression;
            if (c == 0) {
                this.compareAccessModifier(m1.getMemberAccessModifier(), m2.getMemberAccessModifier());
            }
        }
        return c;
    }

    private int compareMemberType(TMember m1, TMember m2) {
        return Integer.compare(this.getMemberTypeOrdinal(m1), this.getMemberTypeOrdinal(m2));
    }

    private int getMemberTypeOrdinal(TMember m) {
        int _switchResult = 0;
        boolean _matched = false;
        if (m instanceof TField) {
            _matched = true;
            _switchResult = 1;
        }
        if (!_matched && m instanceof TGetter) {
            _matched = true;
            _switchResult = 2;
        }
        if (!_matched && m instanceof TSetter) {
            _matched = true;
            _switchResult = 3;
        }
        if (!_matched && m instanceof TMethod) {
            _matched = true;
            _switchResult = 4;
        }
        if (!_matched) {
            String _name = m.eClass().getName();
            String _plus = "unsupported subclass of TMember: " + _name;
            throw new IllegalArgumentException(_plus);
        }
        return _switchResult;
    }

    private int compareAccessModifier(MemberAccessModifier m1, MemberAccessModifier m2) {
        int _ordinal_1;
        int _xifexpression = 0;
        int _ordinal = m1.ordinal();
        boolean _greaterEqualsThan = _ordinal >= (_ordinal_1 = m2.ordinal());
        _xifexpression = _greaterEqualsThan ? 0 : -1;
        return _xifexpression;
    }
}

