/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.expectation.impl;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;

public class StringCollection<T extends Item>
implements Iterable<T> {
    protected static final Pattern WS = Pattern.compile("\\s+", 8);
    protected boolean caseSensitive = true;
    protected Collection<T> items;
    protected boolean ordered = true;
    protected char quote = (char)34;
    protected boolean quoted = true;
    protected char separator = (char)44;
    protected boolean whitespaceSensitive = true;

    protected Collection<T> createCollection() {
        return this.ordered ? Lists.newArrayList() : HashMultiset.create();
    }

    protected String escape(String str) {
        str = str.replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r");
        if (this.quoted) {
            return String.valueOf(this.quote) + str.replace(String.valueOf(this.quote), "\\" + this.quote) + this.quote;
        }
        if (str.startsWith("!") || str.equals("...")) {
            str = "\\" + str;
        }
        str = str.replace(String.valueOf(this.separator), "\\" + this.separator);
        if (this.whitespaceSensitive) {
            return str;
        }
        return str.trim();
    }

    protected String escapeUnquoted(String str) {
        return str.replaceAll("\\s+", " ");
    }

    public char getQuote() {
        return this.quote;
    }

    public char getSeparator() {
        return this.separator;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isQuoted() {
        return this.quoted;
    }

    public boolean isWhitespaceSensitive() {
        return this.whitespaceSensitive;
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    protected String normalize(String item) {
        if (!this.quoted) {
            item = item.trim();
        }
        if (!this.whitespaceSensitive) {
            item = WS.matcher(item).replaceAll("");
        }
        if (!this.caseSensitive) {
            item = item.toLowerCase();
        }
        return item;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public void setQuote(char quote) {
        this.quote = quote;
    }

    public void setQuoted(boolean quoted) {
        this.quoted = quoted;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public void setWhitespaceSensitive(boolean whitespaceSensitive) {
        this.whitespaceSensitive = whitespaceSensitive;
    }

    public class Item
    implements Comparable<Item> {
        protected String escaped = null;
        protected String normalized = null;
        protected String pure;

        public Item(String pure) {
            this.pure = pure;
        }

        public boolean equals(Object obj) {
            if (obj == null || !Item.class.isInstance(obj)) {
                return false;
            }
            return this.getNormalized().equals(((Item)obj).getNormalized());
        }

        public String getEscaped() {
            if (this.escaped == null) {
                this.escaped = StringCollection.this.escape(this.pure);
            }
            return this.escaped;
        }

        public String getNormalized() {
            if (this.normalized == null) {
                this.normalized = StringCollection.this.normalize(this.pure);
            }
            return this.normalized;
        }

        public String getPure() {
            return this.pure;
        }

        public int hashCode() {
            return this.getNormalized().hashCode();
        }

        public String toString() {
            return this.pure;
        }

        @Override
        public int compareTo(Item o) {
            if (this.normalized == null) {
                return -1;
            }
            if (o == null || o.normalized == null) {
                return 1;
            }
            return this.normalized.compareTo(o.normalized);
        }
    }
}

