/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.parameter;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.expectation.IExpectationRegion;
import org.eclipse.xpect.parameter.IStatementRelatedRegion;
import org.eclipse.xpect.parameter.IStatementRelatedRegionProvider;
import org.eclipse.xpect.parameter.ParameterRegion;
import org.eclipse.xpect.parameter.StatementRelatedRegion;
import org.eclipse.xpect.parameter.StatementRelatedRegionProvider;
import org.eclipse.xpect.text.IRegion;
import org.eclipse.xpect.text.Text;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

@StatementRelatedRegionProvider
public class ParameterRegionProvider
implements IStatementRelatedRegionProvider {
    @Override
    public IStatementRelatedRegion getRegion(XpectInvocation invocation) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)invocation);
        int start = node.getOffset() + node.getLength();
        Text text = new Text(invocation.getFile().getDocument());
        int end = text.currentLineEnd(start);
        if (end < 0) {
            end = invocation.getFile().getDocument().length();
        }
        return new RefinableRegion(invocation, start, end - start);
    }

    public class RefinableRegion
    extends StatementRelatedRegion
    implements IStatementRelatedRegionProvider.IRefinableStatementRelatedRegion {
        public RefinableRegion(XpectInvocation invocation, int offset, int length) {
            super(invocation, offset, length);
        }

        @Override
        public IStatementRelatedRegion refine(Collection<IStatementRelatedRegion> allRegions) {
            int start = this.getOffset();
            int end = this.getOffset() + this.getLength();
            for (IRegion iRegion : allRegions) {
                if (iRegion == this) continue;
                int claimOffset = iRegion instanceof IExpectationRegion ? ((IExpectationRegion)iRegion).getOpeningSeparatorOffset() : iRegion.getOffset();
                int claimEnd = iRegion.getOffset() + iRegion.getLength();
                if (end > claimOffset && end <= claimEnd) {
                    end = claimOffset;
                }
                if (start < claimOffset || start >= claimEnd) continue;
                start = claimEnd;
            }
            return new ParameterRegion(this.getStatement(), start, end - start);
        }
    }
}

