/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.workspace;

import com.google.inject.Inject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.n4js.ui.wizard.workspace.WizardPreviewProvider;
import org.eclipse.n4js.ui.wizard.workspace.WorkspaceWizardModel;
import org.eclipse.n4js.ui.wizard.workspace.WorkspaceWizardModelValidator;
import org.eclipse.n4js.ui.wizard.workspace.WorkspaceWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class PreviewableWizardPage<M extends WorkspaceWizardModel>
extends WorkspaceWizardPage<M> {
    private static final Point PREVIEW_MINIMUM_SHELL_SIZE = new Point(900, 600);
    private static final GridLayout ONE_PANE_LAYOUT = GridLayoutFactory.fillDefaults().numColumns(1).create();
    private static final GridLayout TWO_PANES_LAYOUT = GridLayoutFactory.fillDefaults().equalWidth(true).numColumns(2).create();
    private static final GridDataFactory PREVIEW_GRID_DATA_FACTORY = GridDataFactory.fillDefaults().span(1, 2).grab(true, true);
    private static final GridDataFactory EXCLUDE_PREVIEW_GRID_DATA_FACTORY = GridDataFactory.fillDefaults().exclude(true);
    private static final String DIALOG_SETTING_HIDE_PREVIEW_KEY = "org.eclipse.n4js.ui.wizard.workspaces.PreviewableWizardPage.ShowPreview";
    private static final String SHOW_PREVIEW_TEXT = "Show preview >>";
    private static final String HIDE_PREVIEW_TEXT = "<< Hide preview";
    private static final String PREVIEW_BUTTON_TOOLTIP = "Toggles the preview";
    @Inject
    private WizardPreviewProvider previewProvider;
    private Composite paneComposite;
    private WizardPreviewProvider.WizardPreview wizardContentPreview;
    private Button previewToggleButton;
    private boolean previewVisible = true;

    @Override
    public void createControl(Composite parent) {
        this.paneComposite = new Composite(parent, 0);
        this.paneComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).create());
        super.createControl(this.paneComposite);
        this.workspaceWizardControl.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        this.createPreview(this.paneComposite);
        this.createBottomControls(this.paneComposite);
        this.setControl((Control)this.paneComposite);
        boolean hidePreviewSetting = this.getDialogSettings().getBoolean(DIALOG_SETTING_HIDE_PREVIEW_KEY);
        if (hidePreviewSetting) {
            this.hideContentPreview();
        } else {
            this.getShell().setMinimumSize(PREVIEW_MINIMUM_SHELL_SIZE);
        }
    }

    protected void showContentPreview() {
        if (this.previewVisible) {
            return;
        }
        if (this.getValidator().getValidationResult().valid) {
            this.updateContentPreview(this.wizardContentPreview);
        }
        this.paneComposite.setLayout((Layout)TWO_PANES_LAYOUT);
        this.wizardContentPreview.setLayoutData(PREVIEW_GRID_DATA_FACTORY.create());
        this.previewVisible = true;
        this.previewToggleButton.setText(HIDE_PREVIEW_TEXT);
        this.getShell().setMinimumSize(PREVIEW_MINIMUM_SHELL_SIZE);
        this.paneComposite.layout();
        this.getDialogSettings().put(DIALOG_SETTING_HIDE_PREVIEW_KEY, false);
    }

    protected void hideContentPreview() {
        if (!this.previewVisible) {
            return;
        }
        int contentPreviewWidth = this.wizardContentPreview.getClientArea().width;
        this.wizardContentPreview.setLayoutData(EXCLUDE_PREVIEW_GRID_DATA_FACTORY.create());
        this.wizardContentPreview.setBounds(0, 0, 0, 0);
        this.paneComposite.setLayout((Layout)ONE_PANE_LAYOUT);
        this.previewVisible = false;
        this.previewToggleButton.setText(SHOW_PREVIEW_TEXT);
        this.getShell().setMinimumSize(0, 0);
        this.getShell().setSize(this.getShell().getSize().x - contentPreviewWidth, this.getShell().getSize().y);
        this.paneComposite.layout();
        this.getDialogSettings().put(DIALOG_SETTING_HIDE_PREVIEW_KEY, true);
    }

    protected abstract void updateContentPreview(WizardPreviewProvider.WizardPreview var1);

    private void createPreview(Composite parent) {
        this.wizardContentPreview = this.previewProvider.create(parent, 0);
        this.wizardContentPreview.setLayoutData(PREVIEW_GRID_DATA_FACTORY.create());
        ((WorkspaceWizardModel)this.getModel()).addPropertyChangeListener(propertyChange -> {
            WorkspaceWizardModelValidator.ValidationResult result = this.getValidator().getValidationResult();
            if (!this.previewVisible) {
                return;
            }
            if (result.valid) {
                this.wizardContentPreview.setEnabled(true);
                this.updateContentPreview(this.wizardContentPreview);
            } else {
                this.wizardContentPreview.setEnabled(false);
                this.wizardContentPreview.setInfo("");
            }
        });
    }

    private void createBottomControls(Composite parent) {
        Composite bottomControls = new Composite(parent, 0);
        bottomControls.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).align(131072, 0x1000000).create());
        bottomControls.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(1).extendedMargins(0, 5, 0, 0).create());
        this.previewToggleButton = new Button(bottomControls, 8);
        this.previewToggleButton.setText(HIDE_PREVIEW_TEXT);
        this.previewToggleButton.setSelection(true);
        this.previewToggleButton.setLayoutData((Object)GridDataFactory.fillDefaults().align(131072, 1024).create());
        this.previewToggleButton.setToolTipText(PREVIEW_BUTTON_TOOLTIP);
        this.previewToggleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!PreviewableWizardPage.this.previewVisible) {
                    PreviewableWizardPage.this.showContentPreview();
                } else {
                    PreviewableWizardPage.this.hideContentPreview();
                }
            }
        });
    }
}

