/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.BindingPattern;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportableElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.N4ClassDefinition;
import org.eclipse.n4js.n4JS.N4ClassExpression;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.NewTarget;
import org.eclipse.n4js.n4JS.TaggedTemplateString;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.Procedures;

public class UnsupportedFeatureValidator
extends AbstractN4JSDeclarativeValidator {
    private static boolean classExpressionsAreAllowed = false;

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkEmptyImport(ImportDeclaration importDecl) {
        boolean _isEmpty = importDecl.getImportSpecifiers().isEmpty();
        if (_isEmpty) {
            this.unsupported("empty import", (EObject)importDecl);
        }
    }

    @Check
    public void checkAnonymousDefaultExport(ExportableElement decl) {
        if (decl instanceof NamedElement && ((NamedElement)decl).getName() == null && decl.isExportedAsDefault()) {
            this.unsupported("anonymous default export", (EObject)decl);
        }
    }

    @Check
    public void checkSeparateExport(ExportDeclaration exportDecl) {
        boolean _tripleEquals;
        ExportableElement _exportedElement = exportDecl.getExportedElement();
        boolean bl = _tripleEquals = _exportedElement == null;
        if (_tripleEquals) {
            if (exportDecl.isDefaultExport() && exportDecl.getDefaultExportedExpression() != null) {
                this.unsupported("exporting values (only declared classes, interfaces, enums, functions and variables can be exported)", (EObject)exportDecl);
            } else {
                this.unsupported("separate export statements (add keyword 'export' directly before a class, interface, enum, function or variable declaration)", (EObject)exportDecl);
            }
        }
    }

    @Check
    public void checkTaggedTemplateLiteral(TaggedTemplateString tts) {
        this.unsupported("tagged template literals", (EObject)tts, (EStructuralFeature)N4JSPackage.eINSTANCE.getTaggedTemplateString_Target());
    }

    @Check
    public void checkClassExpression(N4ClassExpression classExpr) {
        if (!classExpressionsAreAllowed) {
            boolean _tripleNotEquals;
            String _name = classExpr.getName();
            boolean bl = _tripleNotEquals = _name != null;
            if (_tripleNotEquals) {
                this.unsupported("class expressions", (EObject)classExpr, (EStructuralFeature)N4JSPackage.eINSTANCE.getN4ClassExpression_Name());
            } else {
                this.unsupported("class expressions", (EObject)classExpr, NodeModelUtils.getNode((EObject)classExpr).getOffset(), 5);
            }
        }
    }

    @Check
    public void checkNewTarget(NewTarget newTarget) {
        this.unsupported("new.target", (EObject)newTarget);
    }

    @Check
    public void checkExtendsExpression(N4ClassDefinition classDef) {
        boolean _tripleNotEquals;
        Expression _superClassExpression = classDef.getSuperClassExpression();
        boolean bl = _tripleNotEquals = _superClassExpression != null;
        if (_tripleNotEquals) {
            this.unsupported("extends <expression>", (EObject)classDef, (EStructuralFeature)N4JSPackage.eINSTANCE.getN4ClassDefinition_SuperClassExpression());
        }
    }

    @Check
    public void checkBindingPatternAsFpar(BindingPattern pattern) {
        EObject _eContainer = pattern.eContainer();
        if (_eContainer instanceof FormalParameter) {
            this.unsupported("destructuring patterns as formal parameter", (EObject)pattern);
        }
    }

    @Check
    public void checkSpreadOperatorInNewAndCallExpressions(Argument argument) {
        boolean _isSpread = argument.isSpread();
        if (_isSpread) {
            this.unsupported("spread operator in new and call expressions (only allowed in array destructuring patterns)", (EObject)argument, (EStructuralFeature)N4JSPackage.eINSTANCE.getArgument_Spread());
        }
    }

    private void unsupported(String msg, EObject source) {
        this.unsupported(msg, source, null);
    }

    private void unsupported(String msg, EObject source, EStructuralFeature feature) {
        this.addIssue(IssueCodes.getMessageForUNSUPPORTED(msg), source, feature, "UNSUPPORTED", new String[0]);
    }

    private void unsupported(String msg, EObject source, int offset, int length) {
        this.addIssue(IssueCodes.getMessageForUNSUPPORTED(msg), source, offset, length, "UNSUPPORTED");
    }

    public static void allowClassExpressions(Procedures.Procedure0 r) {
        try {
            classExpressionsAreAllowed = true;
            r.apply();
        }
        finally {
            classExpressionsAreAllowed = false;
        }
    }
}

