/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.internal.ui.viewers.AsynchronousModel;
import org.eclipse.debug.internal.ui.viewers.AsynchronousRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.ModelNode;
import org.eclipse.debug.internal.ui.viewers.provisional.IChildrenRequestMonitor;

class ChildrenRequestMonitor
extends AsynchronousRequestMonitor
implements IChildrenRequestMonitor {
    private boolean fFirstUpdate = true;
    private List<Object> fChildren = new ArrayList<Object>();

    ChildrenRequestMonitor(ModelNode parent, AsynchronousModel model) {
        super(parent, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChild(Object child) {
        List<Object> list = this.fChildren;
        synchronized (list) {
            this.fChildren.add(child);
        }
        this.scheduleViewerUpdate(250L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildren(Object[] children) {
        List<Object> list = this.fChildren;
        synchronized (list) {
            int i = 0;
            while (i < children.length) {
                this.fChildren.add(children[i]);
                ++i;
            }
        }
        this.scheduleViewerUpdate(0L);
    }

    @Override
    protected boolean contains(AsynchronousRequestMonitor update) {
        return update instanceof ChildrenRequestMonitor && this.contains(update.getNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performUpdate() {
        List<Object> list = this.fChildren;
        synchronized (list) {
            if (this.fFirstUpdate) {
                this.getModel().setChildren(this.getNode(), this.fChildren);
                this.fFirstUpdate = false;
            } else {
                for (Object child : this.fChildren) {
                    this.getModel().add(this.getNode(), child);
                }
            }
            this.fChildren.clear();
        }
    }
}

