/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.runner;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.xpect.ui.N4IDEXpectUIPlugin;
import org.eclipse.xpect.Environment;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.XpectJavaModel;
import org.eclipse.xpect.XpectRequiredEnvironment;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.util.IXtInjectorProvider;
import org.eclipse.xpect.xtext.lib.setup.FileSetupContext;
import org.eclipse.xpect.xtext.lib.setup.InjectorSetup;
import org.eclipse.xpect.xtext.lib.setup.ThisFile;
import org.eclipse.xpect.xtext.lib.setup.ThisProject;
import org.eclipse.xpect.xtext.lib.setup.ThisResource;
import org.eclipse.xpect.xtext.lib.setup.XtextTestObjectSetup;
import org.eclipse.xpect.xtext.lib.setup.XtextValidatingSetup;
import org.eclipse.xpect.xtext.lib.util.XtextOffsetAdapter;
import org.eclipse.xpect.xtext.lib.util.XtextTargetSyntaxSupport;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

@XpectSetupFactory
@XpectImport(value={XtextTargetSyntaxSupport.class, XtextTestObjectSetup.class, InjectorSetup.class, XtextValidatingSetup.class, XtextOffsetAdapter.class})
@XpectRequiredEnvironment(value={Environment.WORKBENCH})
public class N4IDEXpectFileSetup {
    private static final boolean ENCODE_PLATFORM_RESOURCE_URIS = System.getProperty("org.eclipse.emf.common.util.URI.encodePlatformResourceURIs") != null && !"false".equalsIgnoreCase(System.getProperty("org.eclipse.emf.common.util.URI.encodePlatformResourceURIs"));
    @Inject
    private IResourceSetProvider resourceSetProvider;
    private final FileSetupContext ctx;

    public N4IDEXpectFileSetup(FileSetupContext ctx, Injector injector) {
        this.ctx = ctx;
        injector.injectMembers((Object)this);
    }

    @Creates(value=ThisFile.class)
    public IFile createThisFile() {
        this.foo("createThisFile");
        return null;
    }

    @Creates(value=ThisProject.class)
    public IProject createThisProject() {
        this.foo("createThisProject");
        return null;
    }

    @Creates
    public IWorkspace createWorkspace() {
        this.foo("createWorkspace");
        return null;
    }

    private void foo(String methodName) throws RuntimeException {
        RuntimeException re = new RuntimeException("unexpected call to " + methodName);
        N4IDEXpectUIPlugin.logError(String.valueOf(this.getClass().getSimpleName()) + " does not impleemnt " + methodName + ", check xpect setups if it should", re);
        throw re;
    }

    @Creates(value=ThisResource.class)
    public XtextResource createThisResource() throws IOException, CoreException {
        Map.Entry<IFile, IProject> file2project = this.findTestResources();
        IFile xpectFile = file2project.getKey();
        IProject userProject = file2project.getValue();
        ResourceSet resourceSet = this.resourceSetProvider.get(userProject);
        URI xpectFilePlatformURI = URI.createPlatformResourceURI((String)xpectFile.getFullPath().toString(), (boolean)ENCODE_PLATFORM_RESOURCE_URIS);
        Injector injector = IXtInjectorProvider.INSTANCE.getInjector((XpectJavaModel)this.ctx.get(XpectJavaModel.class, new Object[0]), xpectFilePlatformURI);
        Resource resource = ((IResourceFactory)injector.getInstance(IResourceFactory.class)).createResource(xpectFilePlatformURI);
        resourceSet.getResources().add((Object)resource);
        try (InputStream input = xpectFile.getContents();){
            resource.load(input, null);
        }
        return (XtextResource)resource;
    }

    private Map.Entry<IFile, IProject> findTestResources() throws RuntimeException {
        HashMap<IFile, IProject> files2projects = new HashMap<IFile, IProject>();
        IProject[] worksapceProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        String xtFileLocation = this.ctx.getXpectFileURI().toString();
        IProject[] iProjectArray = worksapceProjects;
        int n = worksapceProjects.length;
        int n2 = 0;
        while (n2 < n) {
            String lkp;
            IFile lkpFile;
            IProject iProject = iProjectArray[n2];
            String projLoc = iProject.getLocationURI().toString();
            if (xtFileLocation.startsWith(projLoc) && (lkpFile = (IFile)iProject.findMember(lkp = xtFileLocation.substring(projLoc.length()))) != null) {
                files2projects.put(lkpFile, iProject);
            }
            ++n2;
        }
        RuntimeException re = null;
        switch (files2projects.size()) {
            case 0: {
                re = new RuntimeException("cannot find any file and project for processed xpect file");
                N4IDEXpectUIPlugin.logError("no projects with files mathching " + xtFileLocation + " found", re);
                throw re;
            }
            case 1: {
                return files2projects.entrySet().iterator().next();
            }
        }
        re = new RuntimeException("cannot find single file and project for processed xpect file");
        StringBuilder sb = new StringBuilder("multiple projects matching " + xtFileLocation + " found");
        files2projects.forEach((file, project) -> sb.append("\n file : " + file.getRawLocation().toString() + ", project :: " + project.getRawLocation().toString()));
        N4IDEXpectUIPlugin.logError(sb.toString(), re);
        throw re;
    }
}

