/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.tests;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.CommaSeparatedValuesExpectation;
import org.eclipse.xpect.expectation.ICommaSeparatedValuesExpectation;
import org.eclipse.xpect.expectation.IStringExpectation;
import org.eclipse.xpect.expectation.StringExpectation;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.runner.LiveExecutionType;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.runner.XpectRunner;
import org.eclipse.xpect.xtext.lib.setup.ThisOffset;
import org.eclipse.xpect.xtext.lib.setup.XtextStandaloneSetup;
import org.eclipse.xpect.xtext.lib.setup.XtextWorkspaceSetup;
import org.eclipse.xpect.xtext.lib.util.XtextOffsetAdapter;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.XtextResource;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=XpectRunner.class)
@XpectImport(value={XtextStandaloneSetup.class, XtextWorkspaceSetup.class})
public class LinkingTest {
    protected String deresolve(URI base, URI uri) {
        if (base.equals(uri.trimFragment())) {
            return uri.fragment();
        }
        return uri.deresolve(base).toString();
    }

    protected String getLinkedFragment(EObject targetObject, URI baseUri) {
        Resource targetResource;
        if (targetObject.eIsProxy()) {
            Assert.fail((String)("Reference is a Proxy: " + ((InternalEObject)targetObject).eProxyURI()));
        }
        if ((targetResource = targetObject.eResource()) == null) {
            Assert.fail((String)"Referenced EObject is not in a resource.");
        }
        URI target = EcoreUtil.getURI((EObject)targetObject);
        return this.deresolve(baseUri, target);
    }

    @Xpect(liveExecution=LiveExecutionType.FAST)
    @ParameterParser(syntax="('at' arg1=OFFSET)?")
    public void linkedFragment(IStringExpectation expectation, @ThisOffset XtextOffsetAdapter.ICrossEReferenceAndEObject arg1) {
        Object targetObject = arg1.getEObject().eGet((EStructuralFeature)arg1.getCrossEReference());
        if (targetObject == null) {
            Assert.fail((String)"Reference is null");
        } else if (targetObject instanceof EObject) {
            URI baseUri = arg1.getEObject().eResource().getURI();
            String actual = this.getLinkedFragment((EObject)targetObject, baseUri);
            expectation.assertEquals((Object)actual);
        } else if (targetObject instanceof EList) {
            Assert.fail((String)"use 'XPECT linkedFragment' (plural)");
        }
    }

    @Xpect(liveExecution=LiveExecutionType.FAST)
    @ParameterParser(syntax="('at' arg1=OFFSET)?")
    public void linkedFragments(@CommaSeparatedValuesExpectation(ordered=true) ICommaSeparatedValuesExpectation expectation, @ThisOffset XtextOffsetAdapter.ICrossEReferenceAndEObject arg1) {
        Object targetObject = arg1.getEObject().eGet((EStructuralFeature)arg1.getCrossEReference());
        if (targetObject == null) {
            Assert.fail((String)"Reference is null");
        } else if (targetObject instanceof EObject) {
            Assert.fail((String)"use 'XPECT linkedFragment' (singular)");
        } else if (targetObject instanceof EList) {
            URI baseUri = arg1.getEObject().eResource().getURI();
            ArrayList result = Lists.newArrayList();
            for (EObject target : (List)targetObject) {
                String fragment = this.getLinkedFragment(target, baseUri);
                result.add(fragment);
            }
            expectation.assertEquals((Iterable)result);
        }
    }

    @Xpect(liveExecution=LiveExecutionType.FAST)
    @ParameterParser(syntax="('at' arg1=OFFSET)?")
    public void linkedName(@StringExpectation IStringExpectation expectation, @ThisOffset XtextOffsetAdapter.ICrossEReferenceAndEObject arg1) {
        Resource targetResource;
        EObject targetObject = (EObject)arg1.getEObject().eGet((EStructuralFeature)arg1.getCrossEReference());
        if (targetObject == null) {
            Assert.fail((String)"Reference is null");
        }
        if (targetObject.eIsProxy()) {
            Assert.fail((String)("Reference is a Proxy: " + ((InternalEObject)targetObject).eProxyURI()));
        }
        if ((targetResource = targetObject.eResource()) instanceof TypeResource) {
            targetResource = arg1.getEObject().eResource();
        }
        if (!(targetResource instanceof XtextResource)) {
            Assert.fail((String)"Referenced EObject is not in an XtextResource.");
        }
        IQualifiedNameProvider provider = (IQualifiedNameProvider)((XtextResource)targetResource).getResourceServiceProvider().get(IQualifiedNameProvider.class);
        QualifiedName name = provider.getFullyQualifiedName(targetObject);
        expectation.assertEquals((Object)name);
    }
}

