/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.generator.headless;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.generator.GeneratorException;
import org.eclipse.n4js.generator.headless.BuildSet;
import org.eclipse.n4js.generator.headless.BuildSetComputer;
import org.eclipse.n4js.generator.headless.ConfiguredGenerator;
import org.eclipse.n4js.generator.headless.ConfiguredGeneratorFactory;
import org.eclipse.n4js.generator.headless.DismissingIssueAcceptor;
import org.eclipse.n4js.generator.headless.HeadlessHelper;
import org.eclipse.n4js.generator.headless.IssueAcceptor;
import org.eclipse.n4js.generator.headless.IssueAcceptorTee;
import org.eclipse.n4js.generator.headless.IssueCollector;
import org.eclipse.n4js.generator.headless.IssueFilter;
import org.eclipse.n4js.generator.headless.MarkedProject;
import org.eclipse.n4js.generator.headless.N4JSCompileErrorException;
import org.eclipse.n4js.generator.headless.N4JSCompileException;
import org.eclipse.n4js.generator.headless.N4JSCompoundCompileException;
import org.eclipse.n4js.generator.headless.N4JSProjectComparator;
import org.eclipse.n4js.generator.headless.N4ProgressStateRecorder;
import org.eclipse.n4js.generator.headless.logging.IHeadlessLogger;
import org.eclipse.n4js.internal.FileBasedWorkspace;
import org.eclipse.n4js.internal.N4FilebasedWorkspaceResourceSetContainerState;
import org.eclipse.n4js.internal.N4JSProject;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.resource.OrderedResourceDescriptionsData;
import org.eclipse.n4js.utils.Lazy;
import org.eclipse.n4js.utils.ResourceType;
import org.eclipse.n4js.utils.io.FileUtils;
import org.eclipse.n4js.utils.resources.IBuildSuppressingResourceDescriptionManager;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.containers.DelegatingIAllContainerAdapter;
import org.eclipse.xtext.resource.containers.IAllContainersState;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class N4HeadlessCompiler {
    @Inject
    private ConfiguredGeneratorFactory generatorFactory;
    @Inject
    private FileBasedWorkspace n4jsFileBasedWorkspace;
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private IHeadlessLogger logger;
    @Inject
    private N4FilebasedWorkspaceResourceSetContainerState rsbAcs;
    @Inject
    private Provider<XtextResourceSet> xtextResourceSetProvider;
    @Inject
    private ClassLoader classLoader;
    @Inject
    private HeadlessHelper headlessHelper;
    @Inject
    private BuildSetComputer buildSetComputer;
    private boolean keepOnCompiling = false;
    private boolean processTestCode = true;
    private boolean compileSourceCode = true;
    private String logFile = null;

    public void compile(BuildSet buildSet) throws N4JSCompileException {
        this.compile(buildSet, new DismissingIssueAcceptor());
    }

    public void compile(BuildSet buildSet, IssueAcceptor issueAcceptor) throws N4JSCompileException {
        Set<N4JSProject> allProjects = buildSet.getAllProjects();
        Set<N4JSProject> requestedProjects = buildSet.requestedProjects;
        Predicate<URI> singleSourceFilter = buildSet.resourceFilter;
        this.headlessHelper.registerProjects(buildSet, this.n4jsFileBasedWorkspace);
        this.configureResourceSetContainerState(allProjects);
        List<MarkedProject> buildOrder = this.computeBuildOrder(allProjects, requestedProjects);
        this.printBuildOrder(buildOrder);
        this.processProjects(buildOrder, singleSourceFilter, issueAcceptor);
    }

    public void cleanProjectsInSearchPath(List<File> searchPaths) throws N4JSCompileException {
        List<File> absProjectPaths = this.headlessHelper.toAbsoluteFileList(searchPaths);
        List<File> projectPaths = this.headlessHelper.collectAllProjectPaths(absProjectPaths);
        this.cleanProjects(projectPaths);
    }

    public void cleanProjects(List<File> projectPaths) throws N4JSCompileException {
        List<URI> projectURIs = this.convertProjectPathsToProjectURIs(projectPaths);
        this.headlessHelper.registerProjectsToFileBasedWorkspace(projectURIs, this.n4jsFileBasedWorkspace);
        List<N4JSProject> projectsToClean = this.headlessHelper.getN4JSProjects(projectURIs);
        projectsToClean.forEach(project -> {
            if (project.getProjectType() != ProjectType.VALIDATION && project.getProjectType() != ProjectType.PLAINJS) {
                this.cleanProject((N4JSProject)project);
            }
        });
    }

    private void cleanProject(N4JSProject project) {
        String outputFolder = project.getOutputPath();
        Path outputPath = project.getLocationPath().resolve(outputFolder);
        FileUtils.cleanFolder((File)outputPath.toFile());
    }

    private List<URI> convertProjectPathsToProjectURIs(List<File> projectPaths) throws N4JSCompileException {
        List<File> absProjectPaths = this.headlessHelper.toAbsoluteFileList(projectPaths);
        List<URI> projectURIs = this.headlessHelper.createFileURIs(absProjectPaths);
        return projectURIs;
    }

    private void configureResourceSetContainerState(Set<N4JSProject> allProjects) {
        LinkedList<String> containers = new LinkedList<String>();
        HashBiMap container2project = HashBiMap.create();
        HashMultimap container2Uris = HashMultimap.create();
        for (N4JSProject project : allProjects) {
            String container = "n4fbprj:" + project.getLocation();
            container2project.put((Object)container, (Object)project);
            containers.add(container);
            for (IN4JSSourceContainer sourceContainer : project.getSourceContainers()) {
                Iterables.addAll((Collection)container2Uris.get((Object)container), (Iterable)sourceContainer);
            }
        }
        this.rsbAcs.configure(containers, (Multimap)container2Uris);
    }

    private List<MarkedProject> computeBuildOrder(Collection<? extends IN4JSProject> allProjectsToCompile, Collection<? extends IN4JSProject> requestedProjects) {
        HashMap<IN4JSProject, MarkedProject> markedProjects = new HashMap<IN4JSProject, MarkedProject>();
        allProjectsToCompile.stream().forEach(project -> {
            MarkedProject markedProject = markedProjects.put((IN4JSProject)project, new MarkedProject((IN4JSProject)project));
        });
        TreeMultimap pendencies = TreeMultimap.create((Comparator)N4JSProjectComparator.INSTANCE, (Comparator)N4JSProjectComparator.INSTANCE);
        TreeMultimap dependencies = TreeMultimap.create((Comparator)N4JSProjectComparator.INSTANCE, (Comparator)N4JSProjectComparator.INSTANCE);
        TreeSet<IN4JSProject> independentProjects = new TreeSet<IN4JSProject>(N4JSProjectComparator.INSTANCE);
        this.computeDependencyGraph(markedProjects.keySet(), (Multimap<IN4JSProject, IN4JSProject>)pendencies, (Multimap<IN4JSProject, IN4JSProject>)dependencies, independentProjects);
        for (IN4JSProject iN4JSProject : new HashSet<IN4JSProject>(requestedProjects)) {
            N4HeadlessCompiler.markDependencies(iN4JSProject, iN4JSProject, markedProjects, (Multimap<IN4JSProject, IN4JSProject>)dependencies);
        }
        return N4HeadlessCompiler.computeBuildOrderDepthFirst(markedProjects, (Multimap<IN4JSProject, IN4JSProject>)pendencies, (Multimap<IN4JSProject, IN4JSProject>)dependencies, independentProjects);
    }

    private static void markDependencies(IN4JSProject marker, IN4JSProject markee, Map<IN4JSProject, MarkedProject> markables, Multimap<IN4JSProject, IN4JSProject> dependencies) {
        MarkedProject projectToMark = markables.get(markee);
        if (projectToMark == null) {
            return;
        }
        projectToMark.markWith(marker);
        for (IN4JSProject dependency : dependencies.get((Object)markee)) {
            N4HeadlessCompiler.markDependencies(marker, dependency, markables, dependencies);
        }
    }

    private void computeDependencyGraph(Set<IN4JSProject> projects, Multimap<IN4JSProject, IN4JSProject> pendencies, Multimap<IN4JSProject, IN4JSProject> dependencies, Collection<IN4JSProject> independent) {
        HashSet<IN4JSProject> visited = new HashSet<IN4JSProject>(projects.size());
        for (IN4JSProject project : projects) {
            this.computeDependencyGraph(project, visited, pendencies, dependencies, independent);
        }
    }

    private void computeDependencyGraph(IN4JSProject project, Set<IN4JSProject> visitedProjects, Multimap<IN4JSProject, IN4JSProject> pendencies, Multimap<IN4JSProject, IN4JSProject> dependencies, Collection<IN4JSProject> independent) {
        if (!visitedProjects.add(project)) {
            return;
        }
        ImmutableList pendingProjects = project.getDependenciesAndImplementedApis();
        if (!this.headlessHelper.isProjectToBeBuilt(project) || !project.hasN4JSNature()) {
            independent.add(project);
            return;
        }
        if (pendingProjects.isEmpty()) {
            independent.add(project);
        } else {
            for (IN4JSProject pendingProject : pendingProjects) {
                pendencies.put((Object)pendingProject, (Object)project);
                dependencies.put((Object)project, (Object)pendingProject);
                this.computeDependencyGraph(pendingProject, visitedProjects, pendencies, dependencies, independent);
            }
        }
    }

    private static List<MarkedProject> computeBuildOrderDepthFirst(Map<IN4JSProject, MarkedProject> markedProjects, Multimap<IN4JSProject, IN4JSProject> pendencies, Multimap<IN4JSProject, IN4JSProject> dependencies, Collection<IN4JSProject> rootProjects) {
        LinkedList<MarkedProject> result = new LinkedList<MarkedProject>();
        for (IN4JSProject rootProject : rootProjects) {
            N4HeadlessCompiler.computeBuildOrderDepthFirst(rootProject, markedProjects, pendencies, dependencies, result);
        }
        return result;
    }

    private static void computeBuildOrderDepthFirst(IN4JSProject project, Map<IN4JSProject, MarkedProject> markedProjects, Multimap<IN4JSProject, IN4JSProject> pendencies, Multimap<IN4JSProject, IN4JSProject> dependencies, List<MarkedProject> result) {
        if (dependencies.get((Object)project).isEmpty()) {
            MarkedProject markedProject = markedProjects.get(project);
            if (markedProject != null) {
                result.add(markedProject);
            }
            for (IN4JSProject dependentProject : pendencies.get((Object)project)) {
                dependencies.get((Object)dependentProject).remove(project);
                N4HeadlessCompiler.computeBuildOrderDepthFirst(dependentProject, markedProjects, pendencies, dependencies, result);
            }
        }
    }

    private void processProjects(List<MarkedProject> projects, Predicate<URI> filter, IssueAcceptor issueAcceptor) throws N4JSCompileException {
        Lazy collectedErrors = Lazy.create(() -> new N4JSCompoundCompileException("Errors during compiling."));
        N4ProgressStateRecorder recorder = new N4ProgressStateRecorder();
        ResourceSet resourceSet = this.createResourceSet();
        LinkedList<MarkedProject> loadedProjects = new LinkedList<MarkedProject>();
        for (MarkedProject markedProject : projects) {
            block9: {
                if (!markedProject.hasMarkers()) continue;
                recorder.markProcessing(markedProject.project);
                try {
                    try {
                        loadedProjects.add(markedProject);
                        this.loadProject(markedProject, resourceSet, recorder, issueAcceptor);
                        this.validateProject(markedProject, recorder, issueAcceptor);
                        if (markedProject.hasMarker(markedProject.project) && !markedProject.project.isExternal()) {
                            this.generateProject(markedProject, resourceSet, filter, recorder);
                        }
                    }
                    catch (N4JSCompileErrorException e) {
                        recorder.compileException(e);
                        if (!this.isKeepOnCompiling()) {
                            throw e;
                        }
                        ((N4JSCompoundCompileException)collectedErrors.get()).add(e);
                        markedProject.unloadASTAndClearCaches();
                        this.unmarkAndUnloadProjects(loadedProjects, markedProject, resourceSet, recorder);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    markedProject.unloadASTAndClearCaches();
                    this.unmarkAndUnloadProjects(loadedProjects, markedProject, resourceSet, recorder);
                    throw throwable;
                }
                markedProject.unloadASTAndClearCaches();
                this.unmarkAndUnloadProjects(loadedProjects, markedProject, resourceSet, recorder);
            }
            recorder.markEndProcessing(markedProject.project);
        }
        recorder.dumpToLogfile(this.logFile);
        if (collectedErrors.isInitialized()) {
            throw (N4JSCompoundCompileException)collectedErrors.get();
        }
    }

    private ResourceSet createResourceSet() {
        XtextResourceSet resourceSet = (XtextResourceSet)this.xtextResourceSetProvider.get();
        resourceSet.setClasspathURIContext((Object)this.classLoader);
        resourceSet.eAdapters().add((Object)new DelegatingIAllContainerAdapter((IAllContainersState)this.rsbAcs));
        OrderedResourceDescriptionsData index = new OrderedResourceDescriptionsData(Collections.emptyList());
        ResourceDescriptionsData.ResourceSetAdapter.installResourceDescriptionsData((ResourceSet)resourceSet, (ResourceDescriptionsData)index);
        return resourceSet;
    }

    private void loadProject(MarkedProject markedProject, ResourceSet resSet, N4ProgressStateRecorder recorder, IssueAcceptor issueAcceptor) throws N4JSCompileErrorException {
        recorder.markStartLoading(markedProject);
        if (this.logger.isCreateDebugOutput()) {
            this.logger.debug("Loading project " + markedProject.project.getProjectName());
        }
        this.collectResources(markedProject, resSet, recorder);
        this.loadResources(markedProject, recorder);
        this.indexResources(markedProject, resSet);
        this.postProcessResources(markedProject);
        this.indexResources(markedProject, resSet);
    }

    private void collectResources(MarkedProject markedProject, ResourceSet resourceSet, N4ProgressStateRecorder recorder) {
        markedProject.clearResources();
        for (IN4JSSourceContainer container : markedProject.project.getSourceContainers()) {
            if (!this.shouldLoadSourceContainer(container)) continue;
            if (this.logger.isCreateDebugOutput()) {
                this.logger.debug("Collecting resources from source container " + container.getLocation());
            }
            Iterables.filter((Iterable)container, uri -> this.shouldLoadResource((URI)uri)).forEach(uri -> {
                Resource resource = resourceSet.createResource(uri);
                if (resource != null) {
                    if (this.logger.isCreateDebugOutput()) {
                        this.logger.debug("  Creating resource " + resource.getURI());
                    }
                    markedProject.resources.add(resource);
                    if (container.isExternal()) {
                        markedProject.externalResources.add(resource);
                    }
                    if (container.isTest()) {
                        markedProject.testResources.add(resource);
                    }
                } else {
                    recorder.markFailedCreateResource((URI)uri);
                    this.logger.warn("  Could not create resource for " + uri);
                }
            });
        }
    }

    private boolean shouldLoadSourceContainer(IN4JSSourceContainer sourceContainer) {
        return this.isProcessTestCode() || !sourceContainer.isTest();
    }

    private boolean shouldLoadResource(URI uri) {
        ResourceType resourceType = ResourceType.getResourceType((URI)uri);
        switch (resourceType) {
            case UNKOWN: {
                return false;
            }
        }
        return true;
    }

    private void loadResources(MarkedProject markedProject, N4ProgressStateRecorder recorder) throws N4JSCompileErrorException {
        if (this.logger.isCreateDebugOutput()) {
            this.logger.debug("Loading resources for project " + markedProject.project.getProjectName());
        }
        for (Resource resource : markedProject.resources) {
            try {
                if (this.logger.isCreateDebugOutput()) {
                    this.logger.debug("  Loading resource " + resource.getURI());
                }
                resource.load(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                recorder.markLoadResourceFailed(resource);
                String message = "Cannot load resource=" + resource.getURI();
                if (!this.isKeepOnCompiling()) {
                    throw new N4JSCompileErrorException(message, markedProject.project.getProjectName(), e);
                }
                this.logger.warn(message);
            }
        }
    }

    private void indexResources(MarkedProject markedProject, ResourceSet resourceSet) {
        Resource manifestResource;
        ResourceDescriptionsData index = ResourceDescriptionsData.ResourceSetAdapter.findResourceDescriptionsData((ResourceSet)resourceSet);
        if (this.logger.isCreateDebugOutput()) {
            this.logger.debug("Indexing project " + markedProject.project.getProjectName());
        }
        for (Resource resource : markedProject.resources) {
            this.indexResource(resource, index);
        }
        Optional manifestUri = markedProject.project.getProjectDescriptionLocation();
        if (manifestUri.isPresent() && (manifestResource = resourceSet.getResource((URI)manifestUri.get(), true)) != null) {
            this.indexResource(manifestResource, index);
        }
    }

    private void indexResource(Resource resource, ResourceDescriptionsData index) {
        if (!this.shouldIndexResource(resource)) {
            return;
        }
        URI uri = resource.getURI();
        IResourceServiceProvider serviceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(uri);
        if (serviceProvider != null) {
            if (this.logger.isCreateDebugOutput()) {
                this.logger.debug("  Indexing resource " + uri);
            }
            IResourceDescription.Manager resourceDescriptionManager = serviceProvider.getResourceDescriptionManager();
            IResourceDescription resourceDescription = resourceDescriptionManager.getResourceDescription(resource);
            if (resourceDescriptionManager instanceof IBuildSuppressingResourceDescriptionManager && !((IBuildSuppressingResourceDescriptionManager)resourceDescriptionManager).isToBeBuilt(uri, resource)) {
                return;
            }
            if (resourceDescription != null) {
                index.addDescription(uri, resourceDescription);
            }
        }
    }

    private boolean shouldIndexResource(Resource resource) {
        URI uri = resource.getURI();
        ResourceType resourceType = ResourceType.getResourceType((URI)uri);
        switch (resourceType) {
            case JS: {
                return this.n4jsCore.findN4JSSourceContainer(uri).isPresent();
            }
            case JSX: {
                return this.n4jsCore.findN4JSSourceContainer(uri).isPresent();
            }
            case UNKOWN: {
                return false;
            }
        }
        return true;
    }

    private void postProcessResources(MarkedProject markedProject) {
        if (this.logger.isCreateDebugOutput()) {
            this.logger.debug(" PostProcessing " + markedProject);
        }
        Iterables.filter(markedProject.resources, resource -> resource.isLoaded()).forEach(resource -> {
            if (resource instanceof N4JSResource) {
                N4JSResource n4jsResource = (N4JSResource)resource;
                n4jsResource.performPostProcessing();
            }
        });
    }

    private void validateProject(MarkedProject markedProject, N4ProgressStateRecorder recorder, IssueAcceptor issueAcceptor) throws N4JSCompileErrorException {
        if (this.logger.isVerbose()) {
            this.logger.info(" Validating project " + markedProject);
        }
        IssueCollector issueCollector = new IssueCollector();
        IssueFilter issueFilter = new IssueFilter(issueCollector, issue -> issue.getSeverity() == Severity.ERROR);
        issueAcceptor = new IssueAcceptorTee(issueAcceptor, issueFilter);
        for (Resource resource : markedProject.resources) {
            XtextResource xtextResource;
            IResourceValidator validator;
            List issues;
            if (!(resource instanceof XtextResource) || this.n4jsCore.isNoValidate(resource.getURI()) || markedProject.externalResources.contains(resource)) continue;
            if (this.logger.isCreateDebugOutput()) {
                this.logger.debug("   Validating resource " + resource.getURI());
            }
            if ((issues = (validator = (xtextResource = (XtextResource)resource).getResourceServiceProvider().getResourceValidator()).validate((Resource)xtextResource, CheckMode.ALL, CancelIndicator.NullImpl)).isEmpty()) continue;
            recorder.markResourceIssues(resource, issues);
            issueAcceptor.acceptAll(issues);
            issues.stream().forEach(this.logger::issue);
        }
        if (!this.isKeepOnCompiling()) {
            this.failOnErrors(issueCollector.getCollectedIssues(), markedProject.project.getProjectName());
        }
    }

    private void failOnErrors(List<Issue> errors, String projectName) throws N4JSCompileErrorException {
        if (!errors.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append("Cannot compile project " + projectName + " due to " + errors.size() + " errors.");
            errors.forEach(error -> {
                StringBuilder stringBuilder2 = message.append("\n").append(error);
            });
            throw new N4JSCompileErrorException(message.toString(), projectName);
        }
    }

    private void generateProject(MarkedProject markedProject, ResourceSet resSet, Predicate<URI> compileFilter, N4ProgressStateRecorder rec) throws N4JSCompileException {
        rec.markStartCompiling(markedProject);
        String projectName = markedProject.project.getProjectName();
        if (this.logger.isVerbose()) {
            this.logger.info("Generating " + projectName);
        }
        Lazy collectedErrors = Lazy.create(() -> new N4JSCompoundCompileException("Errors during generation of project " + projectName));
        ConfiguredGenerator generator = this.generatorFactory.getConfiguredGenerator(markedProject.project);
        for (Resource resource : markedProject.resources) {
            boolean compile;
            if (!compileFilter.test(resource.getURI())) continue;
            boolean isTest = markedProject.isTest(resource);
            boolean bl = compile = isTest && this.isProcessTestCode() || !isTest && this.isCompileSourceCode();
            if (compile) {
                try {
                    rec.markStartCompile(resource);
                    if (this.logger.isVerbose()) {
                        this.logger.info("  Generating resource " + resource.getURI());
                    }
                    generator.generate(resource);
                    rec.markEndCompile(resource);
                    continue;
                }
                catch (GeneratorException e) {
                    rec.markBrokenCompile(e);
                    if (this.isKeepOnCompiling()) {
                        ((N4JSCompoundCompileException)collectedErrors.get()).add(new N4JSCompileErrorException(e.getMessage(), projectName, e));
                        if (!this.logger.isVerbose()) continue;
                        this.logger.info(e.getMessage());
                        continue;
                    }
                    throw e;
                }
            }
            rec.markSkippedCompile(resource);
        }
        rec.markEndCompiling(markedProject);
        if (collectedErrors.isInitialized()) {
            throw (N4JSCompoundCompileException)collectedErrors.get();
        }
    }

    private void unmarkAndUnloadProjects(List<MarkedProject> loadedProjects, MarkedProject markedProject, ResourceSet resourceSet, N4ProgressStateRecorder recorder) {
        ListIterator<MarkedProject> loadedIter = loadedProjects.listIterator();
        while (loadedIter.hasNext()) {
            MarkedProject loaded = loadedIter.next();
            loaded.remove(markedProject.project);
            if (loaded.hasMarkers()) continue;
            if (this.logger.isCreateDebugOutput()) {
                this.logger.debug("Unloading project " + loaded.project);
            }
            loaded.unload(resourceSet, recorder);
            loadedIter.remove();
        }
    }

    private void printBuildOrder(List<MarkedProject> buildOrder) {
        if (this.logger.isCreateDebugOutput()) {
            this.logger.debug("Building " + buildOrder.size() + " projects in the following order");
            long generated = buildOrder.stream().filter(mp -> mp.hasMarkers()).count();
            int decimals = Long.toString(generated).length();
            StringBuilder pattern = new StringBuilder();
            StringBuilder placeHolderB = new StringBuilder();
            long i = 0L;
            while (i < (long)decimals) {
                pattern.append("#");
                placeHolderB.append("-");
                ++i;
            }
            DecimalFormat indexFormat = new DecimalFormat(pattern.toString());
            String indexPlaceHolder = placeHolderB.toString();
            int index = 1;
            for (MarkedProject mp2 : buildOrder) {
                boolean generate = mp2.hasMarkers();
                StringBuilder msg = new StringBuilder();
                if (generate) {
                    msg.append(indexFormat.format(index)).append(".");
                    ++index;
                } else {
                    msg.append(indexPlaceHolder).append(" ");
                }
                msg.append(" Project ").append(mp2.project);
                msg.append(" used by [").append(Joiner.on((String)", ").join(mp2.markers)).append("]");
                this.logger.debug(msg.toString());
            }
        }
    }

    public boolean isKeepOnCompiling() {
        return this.keepOnCompiling;
    }

    public void setKeepOnCompiling(boolean keepOnCompiling) {
        this.keepOnCompiling = keepOnCompiling;
    }

    public boolean isProcessTestCode() {
        return this.processTestCode;
    }

    public void setProcessTestCode(boolean processTestCode) {
        this.processTestCode = processTestCode;
    }

    public boolean isCompileSourceCode() {
        return this.compileSourceCode;
    }

    public void setCompileSourceCode(boolean compileSourceCode) {
        this.compileSourceCode = compileSourceCode;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public BuildSetComputer getBuildSetComputer() {
        return this.buildSetComputer;
    }
}

