/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.server.resources.tests;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.n4js.tester.events.TestEvent;
import org.eclipse.n4js.tester.events.TestStartedEvent;
import org.eclipse.n4js.tester.server.HttpConstants;
import org.eclipse.n4js.tester.server.resources.ClientResourceException;
import org.eclipse.n4js.tester.server.resources.ContentType;
import org.eclipse.n4js.tester.server.resources.HttpMethod;
import org.eclipse.n4js.tester.server.resources.Resource;
import org.eclipse.n4js.tester.server.resources.tests.TestResource;

@Resource(path="/{sessionId}/tests/{testId}/start/", method={HttpMethod.POST}, requestContentType={ContentType.START_TEST}, responseContentType="application/vnd.n4js.start_test_res.tm+json")
public class StartTestResource
extends TestResource {
    private static final String TIMEOUT_KEY = "timeout";
    private static final String PROPERTIES = "properties";
    @Inject
    private ObjectMapper mapper;

    @Override
    protected TestEvent createEvent(String sessionId, String testId, String body) throws ClientResourceException {
        if (Strings.isNullOrEmpty((String)body)) {
            throw new ClientResourceException(400);
        }
        HashMap values = Maps.newHashMap();
        try {
            values.putAll((Map)this.mapper.readValue(body, Map.class));
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ClientResourceException(HttpConstants.SC_UNPROCESSABLE_ENTITY);
        }
        catch (IOException e) {
            throw new ClientResourceException(400);
        }
        Object value = values.get(TIMEOUT_KEY);
        if (value == null) {
            throw new ClientResourceException(HttpConstants.SC_UNPROCESSABLE_ENTITY);
        }
        final HashMap properties = Maps.newHashMap();
        if (values.get(PROPERTIES) != null) {
            if (!(values.get(PROPERTIES) instanceof Map)) {
                throw new ClientResourceException(HttpConstants.SC_UNPROCESSABLE_ENTITY);
            }
            ((Map)values.get(PROPERTIES)).entrySet().forEach(new Consumer<Map.Entry<?, ?>>(){

                @Override
                public void accept(Map.Entry<?, ?> entry) {
                    properties.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                }
            });
        }
        try {
            long timeout = Long.parseLong(String.valueOf(value));
            return new TestStartedEvent(sessionId, testId, timeout, properties);
        }
        catch (NumberFormatException e) {
            throw new ClientResourceException(400);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void handleStatusOk(HttpServletRequest req, HttpServletResponse resp, String escapedPathInfo) throws ClientResourceException {
        TestResource.TestResourceParameters parameters = this.getParametersFromPathInfo(escapedPathInfo);
        if (parameters == null || Strings.isNullOrEmpty((String)parameters.sessionId) || Strings.isNullOrEmpty((String)parameters.testId)) return;
        try {
            String body = this.mapper.writeValueAsString(new StartTestResponse(parameters.sessionId, parameters.testId).data);
            Throwable throwable = null;
            Object var7_9 = null;
            try {
                ServletOutputStream os = resp.getOutputStream();
                try {
                    try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os);){
                        osw.write(body);
                        osw.flush();
                    }
                    if (os == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (os == null) throw throwable;
                    os.close();
                    throw throwable;
                }
                os.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ClientResourceException(400);
        }
    }

    private static final class StartTestResponse {
        private static final String PING_TEMP = "/n4js/testing/sessions/{0}/tests/{1}/ping";
        private static final String END_TEMP = "/n4js/testing/sessions/{0}/tests/{1}/end";
        private final Object data;

        private StartTestResponse(String sessionId, String testId) {
            this.data = Collections.singletonMap("links", Lists.newArrayList((Object[])new ImmutableMap[]{ImmutableMap.builder().put((Object)"rel", (Object)"ping test").put((Object)"uri", (Object)MessageFormat.format(PING_TEMP, sessionId, testId)).build(), ImmutableMap.builder().put((Object)"rel", (Object)"end test").put((Object)"uri", (Object)MessageFormat.format(END_TEMP, sessionId, testId)).build()}));
        }
    }
}

