/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.changes;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.n4js.ui.changes.IChange;
import org.eclipse.n4js.ui.changes.Replacement;
import org.eclipse.n4js.ui.utils.DocumentUtilN4;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;

public class ChangeProvider {
    private static URI getURI(IXtextDocument doc) {
        return (URI)doc.readOnly(resource -> resource.getURI().trimFragment());
    }

    public static IChange replace(IXtextDocument doc, int offset, int length, String replacementText) {
        return new Replacement(ChangeProvider.getURI(doc), offset, length, replacementText);
    }

    public static IChange insertLineAbove(IXtextDocument doc, int offset, String txt, boolean sameIndentation) throws BadLocationException {
        String NL = ChangeProvider.lineDelimiter(doc, offset);
        IRegion currLineReg = doc.getLineInformationOfOffset(offset);
        String indent = "";
        if (sameIndentation) {
            String currLine = doc.get(currLineReg.getOffset(), currLineReg.getLength());
            int idx = 0;
            while (idx < currLine.length() && Character.isWhitespace(currLine.charAt(idx))) {
                ++idx;
            }
            indent = currLine.substring(0, idx);
        }
        return new Replacement(ChangeProvider.getURI(doc), currLineReg.getOffset(), 0, String.valueOf(indent) + txt + NL);
    }

    public static String lineDelimiter(IXtextDocument doc, int offset) throws BadLocationException {
        String nl = doc.getLineDelimiter(doc.getLineOfOffset(offset));
        if (nl == null && doc instanceof AbstractDocument) {
            nl = ((AbstractDocument)doc).getDefaultLineDelimiter();
        }
        return nl;
    }

    public static IChange removeSemanticObject(IXtextDocument doc, EObject obj, boolean removeEntireLineIfEmpty) throws BadLocationException {
        if (obj == null) {
            return IChange.IDENTITY;
        }
        return ChangeProvider.removeNode(doc, (INode)NodeModelUtils.findActualNodeFor((EObject)obj), removeEntireLineIfEmpty);
    }

    public static IChange removeNode(IXtextDocument doc, INode node, boolean removeEntireLineIfEmpty) throws BadLocationException {
        if (node == null) {
            return IChange.IDENTITY;
        }
        return ChangeProvider.removeText(doc, node.getOffset(), node.getLength(), removeEntireLineIfEmpty);
    }

    public static IChange removeText(IXtextDocument doc, int offset, int length, boolean removeEntireLineIfEmpty) throws BadLocationException {
        int offsetRelative;
        if (!removeEntireLineIfEmpty) {
            return new Replacement(ChangeProvider.getURI(doc), offset, length, "");
        }
        IRegion linesRegion = DocumentUtilN4.getLineInformationOfRegion((IDocument)doc, offset, length, true);
        String lines = doc.get(linesRegion.getOffset(), linesRegion.getLength());
        String lineAfterRemoval = ChangeProvider.removeSubstring(lines, offsetRelative = offset - linesRegion.getOffset(), length);
        boolean isEmptyAfterRemoval = lineAfterRemoval.trim().isEmpty();
        if (isEmptyAfterRemoval) {
            return new Replacement(ChangeProvider.getURI(doc), linesRegion.getOffset(), linesRegion.getLength(), "");
        }
        return new Replacement(ChangeProvider.getURI(doc), offset, length, "");
    }

    public static IChange deleteLine(IXtextDocument doc, int offset, boolean deleteOnlyIfEmpty) throws BadLocationException {
        if (deleteOnlyIfEmpty && !DocumentUtilN4.getLine((IDocument)doc, offset).trim().isEmpty()) {
            return IChange.IDENTITY;
        }
        int lineNo = doc.getLineOfOffset(offset);
        int currLineOffset = doc.getLineOffset(lineNo);
        int currLineLen = doc.getLineLength(lineNo);
        return new Replacement(ChangeProvider.getURI(doc), currLineOffset, currLineLen, "");
    }

    private static String removeSubstring(String str, int beginIndex, int length) {
        int len = str.length();
        String part1 = str.substring(0, Math.max(beginIndex, 0));
        String part2 = str.substring(Math.min(beginIndex + length, len), len);
        return String.valueOf(part1) + part2;
    }
}

