/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.ui;

import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.n4js.jsdoc2spec.SpecFile;
import org.eclipse.n4js.jsdoc2spec.ui.OriginalElementFromFile;
import org.eclipse.n4js.jsdoc2spec.ui.SpecPage;
import org.eclipse.n4js.jsdoc2spec.ui.TargetElementFromString;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SpecComparePage
extends SpecPage {
    private static final String PREFIX_SUFFIX_PROPERTY = "org.eclipse.jdt.internal.junit.ui.CompareResultDialog.prefixSuffix";
    private final int[] fPrefixSuffix = new int[2];
    private final String docTypeName;
    CompareViewerPane pane;
    private TextMergeViewer fViewer;
    List<SpecFile> specChanges;
    int current;
    Combo comboCurrentFile;

    public SpecComparePage(String pageName, String docTypeName) {
        super(pageName);
        this.docTypeName = docTypeName;
        this.setMessage("View changes.");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        Composite controls = new Composite(composite, 0);
        controls.setLayout((Layout)new GridLayout(3, false));
        this.comboCurrentFile = new Combo(controls, 12);
        this.comboCurrentFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.comboCurrentFile.add("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
        this.comboCurrentFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpecComparePage.this.current = ((Combo)e.getSource()).getSelectionIndex();
                SpecComparePage.this.setCompareViewerInput(SpecComparePage.this.current);
            }
        });
        Button prev = new Button(controls, 8);
        prev.setText("prev");
        prev.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SpecComparePage.this.current > 0) {
                    --SpecComparePage.this.current;
                    SpecComparePage.this.comboCurrentFile.select(SpecComparePage.this.current);
                    SpecComparePage.this.setCompareViewerInput(SpecComparePage.this.current);
                }
            }
        });
        Button next = new Button(controls, 8);
        next.setText("next");
        next.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SpecComparePage.this.current < SpecComparePage.this.specChanges.size() - 1) {
                    ++SpecComparePage.this.current;
                    SpecComparePage.this.comboCurrentFile.select(SpecComparePage.this.current);
                    SpecComparePage.this.setCompareViewerInput(SpecComparePage.this.current);
                }
            }
        });
        this.pane = new CompareViewerPane(composite, 0x800800);
        this.pane.setText("Compare");
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(120);
        data.heightHint = this.convertHeightInCharsToPixels(13);
        this.pane.setLayoutData((Object)data);
        Control previewer = this.createPreviewer((Composite)this.pane);
        this.pane.setContent(previewer);
        GridData gd = new GridData(1808);
        previewer.setLayoutData((Object)gd);
        previewer.setFont(parent.getFont());
        this.setControl((Control)composite);
    }

    private Control createPreviewer(Composite parent) {
        final CompareConfiguration compareConfiguration = new CompareConfiguration();
        compareConfiguration.setLeftLabel("Original " + this.docTypeName);
        compareConfiguration.setLeftEditable(false);
        compareConfiguration.setRightLabel("Updated " + this.docTypeName);
        compareConfiguration.setRightEditable(false);
        compareConfiguration.setProperty("IGNORE_WHITESPACE", (Object)Boolean.FALSE);
        compareConfiguration.setProperty(PREFIX_SUFFIX_PROPERTY, (Object)this.fPrefixSuffix);
        this.fViewer = new TextMergeViewer(parent, 0, compareConfiguration);
        this.fViewer.setInput((Object)new DiffNode((ITypedElement)new TargetElementFromString(""), (ITypedElement)new TargetElementFromString("")));
        Control control = this.fViewer.getControl();
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                compareConfiguration.dispose();
            }
        });
        return control;
    }

    public void setSpecChanges(List<SpecFile> specChanges) {
        this.specChanges = specChanges;
        this.initcomboBox();
        this.comboCurrentFile.select(0);
        this.setCompareViewerInput(0);
    }

    private void initcomboBox() {
        String[] items = new String[this.specChanges.size()];
        int i = 0;
        for (SpecFile specChange : this.specChanges) {
            String fileName = specChange.getFile().getName();
            String module = specChange.getPackageDisplayName();
            String itemName = fileName;
            if (module != null && module.length() > 0) {
                itemName = String.valueOf(itemName) + " (" + module + ")";
            }
            items[i++] = itemName;
        }
        this.comboCurrentFile.setItems(items);
    }

    private void setCompareViewerInput(int dataIndex) {
        if (this.fViewer.getControl().isDisposed()) {
            return;
        }
        if (this.specChanges.isEmpty()) {
            return;
        }
        SpecFile specChange = this.specChanges.get(dataIndex);
        this.fViewer.setInput((Object)new DiffNode((ITypedElement)new OriginalElementFromFile(specChange.getFile()), (ITypedElement)new TargetElementFromString(specChange.getNewContent())));
        this.fViewer.refresh();
    }
}

