/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.adoc;

import java.io.File;
import org.eclipse.n4js.jsdoc2spec.SpecFile;
import org.eclipse.n4js.jsdoc2spec.adoc.FileSystem;
import org.eclipse.n4js.jsdoc2spec.adoc.IndexEntry;
import org.eclipse.n4js.jsdoc2spec.adoc.IndexEntryWriter;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecIndexFile;

public class IndexFileWriter
extends IndexEntryWriter {
    @Override
    protected String getFileName() {
        return "index.idx";
    }

    @Override
    protected SpecFile createSpecFile(File file, String content) {
        return new SpecIndexFile(file, content);
    }

    @Override
    protected void appendEntry(IndexEntry ie) {
        boolean superDirChanged = false;
        int i = 0;
        while (i < ie.adocPathElems.length) {
            if (superDirChanged || !this.isEqualFileName(ie, this.lastIE, i)) {
                superDirChanged = true;
                int j = 0;
                while (j < i) {
                    this.strb.append("\t");
                    ++j;
                }
                String pathElem = this.setExtensionOnLastPathElem(ie, i);
                this.strb.append(pathElem);
                this.strb.append("\n");
            }
            ++i;
        }
        this.appendElement(ie);
    }

    private String setExtensionOnLastPathElem(IndexEntry ie, int i) {
        String pathElem = ie.adocPathElems[i];
        if (ie.adocPathElems.length - 1 == i) {
            pathElem = pathElem.replace(".adoc", ie.extension);
        }
        return pathElem;
    }

    private boolean isEqualFileName(IndexEntry ie1, IndexEntry ie2, int i) {
        if (ie1 == null || ie2 == null) {
            return false;
        }
        if (ie1.adocPathElems.length <= i || ie2.adocPathElems.length <= i) {
            return false;
        }
        return this.setExtensionOnLastPathElem(ie1, i).equals(this.setExtensionOnLastPathElem(ie2, i));
    }

    private void appendElement(IndexEntry ie) {
        this.strb.append("\t\t\t\t");
        this.strb.append(ie.element);
        this.strb.append(ie.delimiter);
        this.strb.append(ie.property);
        this.strb.append("::");
        this.strb.append(ie.sourceLine);
        this.strb.append("::");
        this.strb.append(ie.offsetStart);
        this.strb.append("::");
        this.strb.append(ie.offsetEnd);
        if (!ie.folder.equals(ie.trueFolder)) {
            this.strb.append("::");
            this.strb.append(ie.repository);
            this.strb.append(":");
            this.strb.append(ie.path.replace("/", "."));
            this.strb.append(":");
            this.strb.append(ie.project);
            this.strb.append(":");
            this.strb.append(ie.trueFolder.replace("/", "."));
        }
        this.strb.append(FileSystem.NL);
    }
}

