/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc.tags;

import org.eclipse.n4js.jsdoc.JSDocCharScanner;
import org.eclipse.n4js.jsdoc.JSDocToken;
import org.eclipse.n4js.jsdoc.dom.InlineTag;
import org.eclipse.n4js.jsdoc.dom.Tag;
import org.eclipse.n4js.jsdoc.dom.TagTitle;
import org.eclipse.n4js.jsdoc.dom.TagValue;
import org.eclipse.n4js.jsdoc.dom.Text;
import org.eclipse.n4js.jsdoc.tags.AbstractInlineTagDefinition;
import org.eclipse.n4js.jsdoc.tokenizers.InlineTagTokenizer;

public class DefaultInlineTagDefinition
extends AbstractInlineTagDefinition {
    public static final String VALUE = "VALUE";

    public DefaultInlineTagDefinition(String title) {
        this.setTitles(title);
    }

    @Override
    public Tag parse(TagTitle title, JSDocCharScanner scanner) {
        InlineTag tag = this.createInlineTag(title);
        scanner.skipWS();
        JSDocToken description = InlineTagTokenizer.INSTANCE.nextToken(scanner);
        if (description != null) {
            String raw = this.convertToText(description).getText();
            int titleOff = raw.indexOf(title.getTitle());
            int titleLen = title.getTitle().length();
            int fix = titleOff + titleLen;
            raw = raw.substring(fix);
            Text text = DOM.createText();
            text.setText(raw);
            text.setBegin(description.start + fix);
            text.setEnd(description.end);
            this.addValue((Tag)tag, VALUE, text);
        }
        return tag;
    }

    public String getValue(InlineTag tag, String defaultValue) {
        if (tag == null || !this.getTitle().equals(tag.getTitle().getTitle())) {
            return defaultValue;
        }
        TagValue tv = tag.getValueByKey(VALUE);
        if (tv.getContents().isEmpty()) {
            return defaultValue;
        }
        return ((Text)tv.getContents()).getText();
    }
}

