/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public enum ImageDescriptorCache {
    INSTANCE;

    private static final String PLUGIN_ID;
    private static final String ICON_FOLDER = "icons";
    private static final LoadingCache<Optional<ImageDescriptor>, Optional<Image>> IMAGE_CACHE;

    static {
        PLUGIN_ID = N4JSActivator.getInstance().getBundle().getSymbolicName();
        IMAGE_CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Optional<ImageDescriptor>, Optional<Image>>(){

            public Optional<Image> load(Optional<ImageDescriptor> key) throws Exception {
                if (key == null || !key.isPresent()) {
                    return Optional.fromNullable((Object)ImageDescriptor.getMissingImageDescriptor().createImage());
                }
                return Optional.fromNullable((Object)((ImageDescriptor)key.get()).createImage());
            }
        });
    }

    private synchronized Optional<ImageDescriptor> getImageDescriptor(ImageRef ref) {
        N4JSActivator activator = N4JSActivator.getInstance();
        if (activator == null) {
            return Optional.absent();
        }
        ImageRegistry registry = activator.getImageRegistry();
        if (registry == null) {
            return Optional.absent();
        }
        ImageDescriptor descriptor = registry.getDescriptor(ref.fileName);
        if (descriptor == null) {
            String imageFilePath = ICON_FOLDER + File.separator + ref.fileName;
            descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)imageFilePath);
            registry.put(ref.fileName, descriptor);
        }
        return Optional.fromNullable((Object)descriptor);
    }

    public static enum ImageRef {
        PROJECT_TYPE_TEST_DECOR("test_project_type.png"),
        PROJECT_TYPE_APP_DECOR("app_project_type.png"),
        PROJECT_TYPE_LIB_DECOR("lib_project_type.png"),
        PROJECT_TYPE_PROC_DECOR("proc_project_type.png"),
        PROJECT_TYPE_RE_DECOR("re_project_type.png"),
        PROJECT_TYPE_RL_DECOR("rl_project_type.png"),
        LIB_PATH("classpath.gif"),
        EXTERNAL_LIB_PATH("native_lib_path_attrib.png"),
        SRC_FOLDER("packagefolder_obj.gif"),
        EXTERNAL_LIB_PROJECT("jar_l_obj.gif"),
        NEW_PROJECT_WIZBAN("newprj_wizban.png"),
        NEW_CLASS_WIZBAN("newclass_wizban.png"),
        NEW_INTERFACE_WIZBAN("newint_wizban.png"),
        NEW_ENUM_WIZBAN("newenum_wizban.png"),
        SMART_LIGHTBULB("smartmode_co.png"),
        WORKING_SET("workset.gif"),
        WORKING_SET_WIZBAN("workset_wiz.png"),
        LEFT_ARROW("nav_backward.gif"),
        RIGHT_ARROW("nav_forward.gif"),
        CLEAR("clear.gif"),
        REPOSITORY("remote_history_mode.gif"),
        URL_LOCATION("url.gif"),
        VARIABLE_TAB("var_simple.gif"),
        TYPES("javaassist_co.gif"),
        PROJECT_MODE("prj_mode.gif"),
        SHOW_HIDDEN_WORKING_SETS("show_hidden.gif"),
        TINY_CLOCK("tiny_clock_ovr.gif");

        private static final Logger LOGGER;
        private final String fileName;

        static {
            LOGGER = Logger.getLogger(ImageRef.class);
        }

        private ImageRef(String fileName) {
            this.fileName = fileName;
        }

        public Optional<ImageDescriptor> asImageDescriptor() {
            return INSTANCE.getImageDescriptor(this);
        }

        public Optional<Image> asImage() {
            try {
                return (Optional)IMAGE_CACHE.get(this.asImageDescriptor());
            }
            catch (ExecutionException e) {
                LOGGER.error((Object)("Error while trying to get image from image descriptor of: " + (Object)((Object)this)));
                return Optional.absent();
            }
        }
    }
}

