/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.utils;

import com.google.inject.Inject;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;

public final class PrefixMatcherHelper {
    private final PrefixMatcher.IgnoreCase prefixMatcher;
    private final boolean canDoCamelCaseMatch;

    @Inject
    public PrefixMatcherHelper(PrefixMatcher.IgnoreCase prefixMatcher) {
        if (!(prefixMatcher instanceof N4JSPrefixMatcher)) {
            throw new IllegalStateException("wrong injection setup: PrefixMatcher.IgnoreCase is expected to be bound to " + N4JSPrefixMatcher.class.getSimpleName() + " but is bound to " + prefixMatcher.getClass().getName());
        }
        this.prefixMatcher = prefixMatcher;
        this.canDoCamelCaseMatch = ((N4JSPrefixMatcher)prefixMatcher).isJdtAvailable();
    }

    public boolean camelCaseMatch(String name, String prefix) {
        return this.canDoCamelCaseMatch && ((N4JSPrefixMatcher)this.prefixMatcher).camelCaseMatch(name, prefix);
    }

    public static final class N4JSPrefixMatcher
    extends PrefixMatcher.CamelCase {
        protected boolean isJdtAvailable() {
            return super.isJdtAvailable();
        }

        protected boolean camelCaseMatch(String name, String prefix) {
            return super.camelCaseMatch(name, prefix);
        }
    }
}

