/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.n4js.ui.workingsets.ManualAssociationAwareWorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetDiffBuilder;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerBroker;
import org.eclipse.n4js.utils.Diff;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;

public class N4JSProjectInWorkingSetDropAdapterAssistant
extends CommonDropAdapterAssistant {
    @Inject
    private WorkingSetManagerBroker workingSetManagerBroker;

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        if (operation != 2) {
            return Status.CANCEL_STATUS;
        }
        WorkingSet targetWorkingSet = null;
        if (target instanceof WorkingSet) {
            targetWorkingSet = (WorkingSet)target;
        }
        if (targetWorkingSet == null) {
            return Status.CANCEL_STATUS;
        }
        if (!LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            return Status.CANCEL_STATUS;
        }
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project;
                Object item = objectArray[n2];
                if (item instanceof IAdaptable && (project = (IProject)((IAdaptable)item).getAdapter(IProject.class)) != null && !this.workingSetContains(targetWorkingSet, project)) {
                    WorkingSetManager manager = ((WorkingSet)target).getWorkingSetManager();
                    if (ManualAssociationAwareWorkingSetManager.class.getName().equals(manager.getId())) {
                        return Status.OK_STATUS;
                    }
                }
                ++n2;
            }
            Object[] elements = ((IStructuredSelection)selection).toArray();
            if (elements.length == 1 && elements[0] instanceof WorkingSet) {
                this.getCommonDropAdapter().setExpandEnabled(false);
                this.getCommonDropAdapter().setFeedbackEnabled(true);
                return Status.OK_STATUS;
            }
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object target) {
        int n;
        WorkingSet oldTarget = (WorkingSet)target;
        WorkingSetManager manager = oldTarget.getWorkingSetManager();
        ArrayList allItems = Lists.newArrayList((Object[])manager.getAllWorkingSets());
        ArrayList visibleItems = Lists.newArrayList((Object[])manager.getWorkingSets());
        WorkingSetDiffBuilder diffBuilder = new WorkingSetDiffBuilder(manager);
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof ITreeSelection) {
            ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet oldSource = null;
            TreePath[] treePathArray = ((ITreeSelection)selection).getPaths();
            int n2 = treePathArray.length;
            n = 0;
            while (n < n2) {
                TreePath path = treePathArray[n];
                IProject project = (IProject)((IAdaptable)path.getLastSegment()).getAdapter(IProject.class);
                if (project != null) {
                    int visibleIndex;
                    int allIndex;
                    HashSet projectNames;
                    if (!(target instanceof ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet)) {
                        return Status.CANCEL_STATUS;
                    }
                    if (!ManualAssociationAwareWorkingSetManager.class.getName().equals(manager.getId())) {
                        return Status.CANCEL_STATUS;
                    }
                    if (!this.workingSetContains(oldTarget, project) && !"Other Projects".equals(oldTarget.getId())) {
                        projectNames = Sets.newHashSet(((ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet)oldTarget).getAssociatedProjectNames());
                        projectNames.add(project.getName());
                        ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet newTarget = new ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet(projectNames, oldTarget.getId(), manager);
                        allIndex = this.indexOfById(oldTarget, allItems);
                        allItems.remove(allIndex);
                        allItems.add(allIndex, newTarget);
                        visibleIndex = this.indexOfById(oldTarget, visibleItems);
                        if (visibleIndex >= 0) {
                            visibleItems.remove(visibleIndex);
                            visibleItems.add(visibleIndex, newTarget);
                        }
                        diffBuilder.edit(oldTarget, newTarget);
                        oldTarget = newTarget;
                    }
                    if (path.getFirstSegment() instanceof ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet) {
                        if (oldSource == null) {
                            oldSource = (ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet)path.getFirstSegment();
                        }
                        if (oldSource != null && !"Other Projects".equals(oldSource.getId())) {
                            projectNames = Sets.newHashSet(oldSource.getAssociatedProjectNames());
                            projectNames.remove(project.getName());
                            ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet newSource = new ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet(projectNames, oldSource.getId(), manager);
                            allIndex = this.indexOfById(oldSource, allItems);
                            allItems.remove(allIndex);
                            allItems.add(allIndex, newSource);
                            visibleIndex = this.indexOfById(oldSource, visibleItems);
                            if (visibleIndex >= 0) {
                                visibleItems.remove(visibleIndex);
                                visibleItems.add(visibleIndex, newSource);
                            }
                            diffBuilder.edit(oldSource, newSource);
                            oldSource = newSource;
                        }
                    }
                } else if (path.getLastSegment() instanceof WorkingSet) {
                    WorkingSet movedWorkingSet = (WorkingSet)path.getLastSegment();
                    int sourceVisibleIndex = this.indexOfById(movedWorkingSet, visibleItems);
                    int sourceAllIndex = this.indexOfById(movedWorkingSet, allItems);
                    if (sourceVisibleIndex == -1 || sourceAllIndex == -1) {
                        return Status.CANCEL_STATUS;
                    }
                    Object currentTarget = this.getCommonDropAdapter().getCurrentTarget();
                    if (currentTarget instanceof WorkingSet) {
                        int targetVisibleIndex = this.indexOfById((WorkingSet)currentTarget, visibleItems);
                        int targetAllIndex = this.indexOfById((WorkingSet)currentTarget, allItems);
                        if (targetVisibleIndex == -1 || targetAllIndex == -1) {
                            return Status.CANCEL_STATUS;
                        }
                        if (this.getCommonDropAdapter().getCurrentLocation() == 2) {
                            ++targetVisibleIndex;
                            ++targetAllIndex;
                        }
                        WorkingSet visibleRemoved = (WorkingSet)visibleItems.remove(sourceVisibleIndex);
                        visibleItems.add(sourceVisibleIndex >= targetVisibleIndex ? targetVisibleIndex : targetVisibleIndex - 1, visibleRemoved);
                        WorkingSet allRemoved = (WorkingSet)allItems.remove(sourceAllIndex);
                        allItems.add(sourceAllIndex >= targetAllIndex ? targetAllIndex : targetAllIndex - 1, allRemoved);
                    } else {
                        return Status.CANCEL_STATUS;
                    }
                }
                ++n;
            }
        } else if (selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            n = objectArray.length;
            int path = 0;
            while (path < n) {
                Object item = objectArray[path];
                IProject project = (IProject)((IAdaptable)item).getAdapter(IProject.class);
                if (project != null && !this.workingSetContains(oldTarget, project) && !"Other Projects".equals(oldTarget.getId())) {
                    HashSet projectNames = Sets.newHashSet(((ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet)oldTarget).getAssociatedProjectNames());
                    projectNames.add(project.getName());
                    ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet newTarget = new ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet(projectNames, oldTarget.getId(), manager);
                    allItems.remove(oldTarget);
                    allItems.add(newTarget);
                    if (visibleItems.remove(oldTarget)) {
                        visibleItems.add(newTarget);
                    }
                    diffBuilder.edit(oldTarget, newTarget);
                    oldTarget = newTarget;
                }
                ++path;
            }
        }
        Object[] newItems = (WorkingSet[])Iterables.toArray((Iterable)visibleItems, WorkingSet.class);
        Object[] newAllItems = (WorkingSet[])Iterables.toArray((Iterable)allItems, WorkingSet.class);
        Diff diff = diffBuilder.build(newItems, newAllItems);
        if (!diff.isEmpty()) {
            manager.updateState((Diff<WorkingSet>)diff);
            manager.saveState((IProgressMonitor)new NullProgressMonitor());
            this.workingSetManagerBroker.refreshNavigator();
        }
        return Status.OK_STATUS;
    }

    @VisibleForTesting
    public CommonDropAdapter getCommonDropAdapter() {
        return super.getCommonDropAdapter();
    }

    private int indexOfById(WorkingSet element, List<WorkingSet> items) {
        int i = 0;
        while (i < items.size()) {
            if (items.get(i).getId().equals(element.getId())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean workingSetContains(WorkingSet workingSet, IProject project) {
        IAdaptable[] iAdaptableArray = workingSet.getElements();
        int n = iAdaptableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable element = iAdaptableArray[n2];
            if (project.equals(element.getAdapter(IProject.class))) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

