/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.changes;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportedVariableStatement;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.ModifiableElement;
import org.eclipse.n4js.n4JS.ModifierUtils;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSFeatureUtils;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4Modifier;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ui.changes.ChangeProvider;
import org.eclipse.n4js.ui.changes.IChange;
import org.eclipse.n4js.ui.changes.ICompositeChange;
import org.eclipse.n4js.utils.nodemodel.NodeModelAccess;
import org.eclipse.n4js.validation.N4JSElementKeywordProvider;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class SemanticChangeProvider {
    private static final String INTERNAL_ANNOTATION = AnnotationDefinition.INTERNAL.name;
    @Inject
    private NodeModelAccess nodeModelAccess;
    @Inject
    private N4JSElementKeywordProvider elementKeywordProvider;

    public IChange setAccessModifiers(IXtextDocument document, ModifiableElement element, N4Modifier modifier) throws BadLocationException {
        return this.setAccessModifiers(document, element, modifier, false);
    }

    public IChange setAccessModifier(IXtextDocument document, TypeDefiningElement element, N4Modifier modifier, boolean export) throws BadLocationException {
        if (!element.getDefinedType().isExported() && export) {
            return this.setAccessModifiers(document, (ModifiableElement)element, modifier, true);
        }
        if (element instanceof ModifiableElement) {
            return this.setAccessModifiers(document, (ModifiableElement)element, modifier, false);
        }
        return null;
    }

    private IChange setAccessModifiers(IXtextDocument document, ModifiableElement element, N4Modifier modifier, boolean export) {
        EList _declaredModifiers = element.getDeclaredModifiers();
        ArrayList modifiers = new ArrayList(_declaredModifiers);
        Functions.Function1 _function = it -> {
            boolean _isAccessModifier = ModifierUtils.isAccessModifier((N4Modifier)it);
            return !_isAccessModifier;
        };
        List nonAccessModifier = IterableExtensions.toList((Iterable)IterableExtensions.filter(modifiers, (Functions.Function1)_function));
        CollectionExtensions.addAll((Collection)nonAccessModifier, (Object[])new N4Modifier[]{modifier});
        String exportPrefix = "";
        if (export) {
            boolean _greaterThan;
            exportPrefix = "export";
            int _length = ((Object[])Conversions.unwrapArray((Object)nonAccessModifier, Object.class)).length;
            boolean bl = _greaterThan = _length > 0;
            if (_greaterThan) {
                String _exportPrefix = exportPrefix;
                exportPrefix = String.valueOf(_exportPrefix) + " ";
            }
        }
        String _sortedModifierString = this.sortedModifierString(nonAccessModifier);
        String _plus = String.valueOf(exportPrefix) + _sortedModifierString;
        return this.setModifiers(document, (EObject)element, _plus);
    }

    public IChange addCustomModifier(IXtextDocument document, ModifiableElement element, String modifier) {
        boolean _greaterThan;
        EList _declaredModifiers = element.getDeclaredModifiers();
        ArrayList<N4Modifier> modifiers = new ArrayList<N4Modifier>((Collection<N4Modifier>)_declaredModifiers);
        String exportPrefix = modifier;
        int _length = ((Object[])Conversions.unwrapArray(modifiers, Object.class)).length;
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            String _exportPrefix = exportPrefix;
            exportPrefix = String.valueOf(_exportPrefix) + " ";
        }
        String _sortedModifierString = this.sortedModifierString(modifiers);
        String _plus = String.valueOf(exportPrefix) + _sortedModifierString;
        return this.setModifiers(document, (EObject)element, _plus);
    }

    public IChange setModifiers(IXtextDocument document, EObject element, String modifiers) {
        boolean _equals;
        boolean _greaterThan;
        int startOffset;
        IChange _xblockexpression = null;
        List _xifexpression = null;
        _xifexpression = element instanceof ModifiableElement ? ((ModifiableElement)element).getDeclaredModifiers() : Collections.EMPTY_LIST;
        List declaredModifiers = _xifexpression;
        String extra_whitespace = "";
        int delete_extra_whitespace = 0;
        int endOffset = startOffset = this.modifierOffset(element);
        List _converted_declaredModifiers = declaredModifiers;
        int _length = ((Object[])Conversions.unwrapArray((Object)_converted_declaredModifiers, Object.class)).length;
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            int _plus;
            List _converted_declaredModifiers_1 = declaredModifiers;
            int _length_1 = ((Object[])Conversions.unwrapArray((Object)_converted_declaredModifiers_1, Object.class)).length;
            int _minus = _length_1 - 1;
            ILeafNode endNode = ModifierUtils.getNodeForModifier((ModifiableElement)((ModifiableElement)element), (int)_minus);
            int _offset = endNode.getOffset();
            int _length_2 = endNode.getLength();
            endOffset = _plus = _offset + _length_2;
        } else {
            boolean _greaterThan_1;
            int _length_3 = modifiers.length();
            boolean bl2 = _greaterThan_1 = _length_3 > 0;
            if (_greaterThan_1) {
                extra_whitespace = " ";
            }
        }
        int _length_4 = modifiers.length();
        boolean bl3 = _equals = _length_4 == 0;
        if (_equals) {
            delete_extra_whitespace = 1;
        }
        int modifierLength = endOffset - startOffset + delete_extra_whitespace;
        _xblockexpression = ChangeProvider.replace(document, startOffset, modifierLength, String.valueOf(modifiers) + extra_whitespace);
        return _xblockexpression;
    }

    public IChange setModifiers(IXtextDocument document, ModifiableElement element, List<N4Modifier> modifiers) throws BadLocationException {
        return this.setModifiers(document, (EObject)element, this.sortedModifierString(modifiers));
    }

    public IChange addModifier(IXtextDocument document, ModifiableElement element, N4Modifier modifier) throws BadLocationException {
        EList _declaredModifiers = element.getDeclaredModifiers();
        ArrayList<N4Modifier> modifiers = new ArrayList<N4Modifier>((Collection<N4Modifier>)_declaredModifiers);
        modifiers.add(modifier);
        return this.setModifiers(document, (EObject)element, this.sortedModifierString(modifiers));
    }

    public IChange removeModifier(IXtextDocument document, ModifiableElement element, N4Modifier modifier) throws BadLocationException {
        Functions.Function1 _function = it -> {
            String _name_1;
            String _name = it.name();
            return !Objects.equal((Object)_name, (Object)(_name_1 = modifier.name()));
        };
        List modifiers = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)element.getDeclaredModifiers(), (Functions.Function1)_function));
        return this.setModifiers(document, (EObject)element, this.sortedModifierString(modifiers));
    }

    public IChange addAnnotation(IXtextDocument document, AnnotableElement element, String annotation) throws BadLocationException {
        boolean _tripleEquals;
        Functions.Function1 _function;
        boolean _equals = annotation.equals(INTERNAL_ANNOTATION);
        if (_equals) {
            return this.addInternalAnnotation(document, element);
        }
        EList _annotations = element.getAnnotations();
        ArrayList annotations = new ArrayList(_annotations);
        Annotation _findFirst = (Annotation)IterableExtensions.findFirst(annotations, (Functions.Function1)(_function = it -> {
            String _name = it.getName();
            return Objects.equal((Object)_name, (Object)annotation);
        }));
        boolean bl = _tripleEquals = _findFirst == null;
        if (_tripleEquals) {
            ICompositeNode elementNode = NodeModelUtils.findActualNodeFor((EObject)element);
            return ChangeProvider.insertLineAbove(document, elementNode.getOffset(), "@" + annotation, true);
        }
        return IChange.IDENTITY;
    }

    private IChange addInternalAnnotation(IXtextDocument document, AnnotableElement element) {
        boolean _tripleEquals;
        ICompositeChange _xblockexpression = null;
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equal((Object)_name, (Object)INTERNAL_ANNOTATION);
        };
        Annotation _findFirst = (Annotation)IterableExtensions.findFirst((Iterable)element.getAnnotations(), (Functions.Function1)_function);
        boolean bl = _tripleEquals = _findFirst == null;
        if (_tripleEquals && element instanceof ModifiableElement) {
            int offset = this.internalAnnotationOffset((ModifiableElement)element);
            return ChangeProvider.replace(document, offset, 0, "@" + INTERNAL_ANNOTATION + " ");
        }
        _xblockexpression = IChange.IDENTITY;
        return _xblockexpression;
    }

    private int internalAnnotationOffset(ModifiableElement element) {
        if (!(element instanceof AnnotableElement)) {
            throw new IllegalArgumentException("Can't compute @Internal offset for non-annotable element");
        }
        EObject containerExportDeclaration = element.eContainer();
        if (containerExportDeclaration instanceof ExportDeclaration) {
            ILeafNode node = this.nodeModelAccess.nodeForKeyword(containerExportDeclaration, "export");
            if (node != null) {
                return node.getOffset();
            }
            throw new NullPointerException("Failed to retrieve node for export keyword");
        }
        return this.modifierOffset((EObject)element);
    }

    private INode astNodeForKeyword(EObject element, String keyword) {
        return this.nodeModelAccess.nodeForKeyword(element, keyword);
    }

    private int modifierOffset(EObject element) {
        int offset = -1;
        if (element instanceof ModifiableElement && ((Object[])Conversions.unwrapArray((Object)((ModifiableElement)element).getDeclaredModifiers(), Object.class)).length > 0) {
            offset = ModifierUtils.getNodeForModifier((ModifiableElement)((ModifiableElement)element), (int)0).getOffset();
        } else {
            int _xblockexpression;
            int _switchResult = 0;
            boolean _matched = false;
            if (element instanceof N4GetterDeclaration) {
                _matched = true;
                _switchResult = this.astNodeForKeyword(element, "get").getOffset();
            }
            if (!_matched && element instanceof N4SetterDeclaration) {
                _matched = true;
                _switchResult = this.astNodeForKeyword(element, "set").getOffset();
            }
            if (!_matched) {
                if (element instanceof FunctionDeclaration) {
                    _matched = true;
                }
                if (!_matched && element instanceof N4ClassDeclaration) {
                    _matched = true;
                }
                if (!_matched && element instanceof N4InterfaceDeclaration) {
                    _matched = true;
                }
                if (!_matched && element instanceof N4EnumDeclaration) {
                    _matched = true;
                }
                if (_matched) {
                    _switchResult = this.astNodeForKeyword(element, this.elementKeywordProvider.keyword((Object)element)).getOffset();
                }
            }
            if (!_matched && element instanceof ExportedVariableStatement) {
                _matched = true;
                _xblockexpression = 0;
                INode exportKeyword = this.astNodeForKeyword(((ExportedVariableStatement)element).eContainer(), "export");
                int _offset = exportKeyword.getOffset();
                int _length = exportKeyword.getLength();
                int _plus = _offset + _length;
                _switchResult = _xblockexpression = _plus + 1;
            }
            if (!_matched && element instanceof N4MethodDeclaration) {
                boolean _isEmpty_3;
                boolean _isEmpty_2;
                boolean _isEmpty_1;
                _matched = true;
                _xblockexpression = 0;
                List nodes = null;
                nodes = NodeModelUtils.findNodesForFeature((EObject)element, (EStructuralFeature)N4JSPackage.Literals.GENERIC_DECLARATION__TYPE_VARS);
                boolean _isEmpty = nodes.isEmpty();
                if (_isEmpty) {
                    nodes = NodeModelUtils.findNodesForFeature((EObject)element, (EStructuralFeature)N4JSPackage.Literals.TYPED_ELEMENT__BOGUS_TYPE_REF);
                }
                if (_isEmpty_1 = nodes.isEmpty()) {
                    nodes = NodeModelUtils.findNodesForFeature((EObject)element, (EStructuralFeature)N4JSPackage.Literals.FUNCTION_DEFINITION__GENERATOR);
                }
                if (_isEmpty_2 = nodes.isEmpty()) {
                    nodes = NodeModelUtils.findNodesForFeature((EObject)element, (EStructuralFeature)N4JSPackage.Literals.FUNCTION_DEFINITION__DECLARED_ASYNC);
                }
                if (_isEmpty_3 = nodes.isEmpty()) {
                    nodes = NodeModelUtils.findNodesForFeature((EObject)element, (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME);
                }
                int _xifexpression = 0;
                if (nodes != null && !nodes.isEmpty()) {
                    int _xblockexpression_1 = 0;
                    INode node = (INode)nodes.get(0);
                    EObject semElem = node.getSemanticElement();
                    int _xifexpression_1 = 0;
                    if (semElem instanceof TypeVariable) {
                        int _offset = node.getOffset();
                        _xifexpression_1 = _offset - 1;
                    } else {
                        _xifexpression_1 = node.getOffset();
                    }
                    _xifexpression = _xblockexpression_1 = _xifexpression_1;
                } else {
                    _xifexpression = -1;
                }
                _switchResult = _xblockexpression = _xifexpression;
            }
            if (!_matched && element instanceof NamedElement) {
                _matched = true;
                _xblockexpression = 0;
                EStructuralFeature attr = N4JSFeatureUtils.attributeOfNameFeature((NamedElement)((NamedElement)element));
                List nodes = NodeModelUtils.findNodesForFeature((EObject)element, (EStructuralFeature)attr);
                int _xifexpression = 0;
                _xifexpression = nodes != null && !nodes.isEmpty() ? ((INode)nodes.get(0)).getOffset() : -1;
                _switchResult = _xblockexpression = _xifexpression;
            }
            if (!_matched) {
                _switchResult = -1;
            }
            offset = _switchResult;
        }
        if (offset == -1) {
            throw new IllegalArgumentException("Couldn't determine element modifier offset");
        }
        return offset;
    }

    public IChange removeAnnotation(IXtextDocument document, AnnotableElement element, String annotation) throws BadLocationException {
        boolean _tripleEquals;
        boolean _tripleNotEquals;
        AnnotableElement annotatedElement = element;
        EList sourceList = null;
        Annotation targetAnnotation = null;
        Functions.Function1 _function = it -> it.getName().equals(annotation);
        Annotation _findFirst = (Annotation)IterableExtensions.findFirst((Iterable)annotatedElement.getAnnotations(), (Functions.Function1)_function);
        boolean bl = _tripleNotEquals = _findFirst != null;
        if (_tripleNotEquals) {
            sourceList = annotatedElement.getAnnotations();
            Functions.Function1 _function_1 = it -> it.getName().equals(annotation);
            targetAnnotation = (Annotation)IterableExtensions.findFirst((Iterable)annotatedElement.getAnnotations(), (Functions.Function1)_function_1);
        } else if (element.eContainer() instanceof ExportDeclaration && IterableExtensions.findFirst((Iterable)((ExportDeclaration)element.eContainer()).getAnnotations(), it -> it.getName().equals(annotation)) != null) {
            EObject _eContainer = element.eContainer();
            sourceList = ((ExportDeclaration)_eContainer).getAnnotations();
            EObject _eContainer_1 = element.eContainer();
            Functions.Function1 _function_2 = it -> it.getName().equals(annotation);
            targetAnnotation = (Annotation)IterableExtensions.findFirst((Iterable)((ExportDeclaration)_eContainer_1).getAnnotations(), (Functions.Function1)_function_2);
        } else {
            return IChange.IDENTITY;
        }
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)targetAnnotation);
        int offset = node.getOffset();
        int length = node.getLength();
        Annotation _head = (Annotation)IterableExtensions.head((Iterable)sourceList);
        boolean bl2 = _tripleEquals = targetAnnotation == _head;
        if (_tripleEquals) {
            int _minus;
            ICompositeNode containerNode = NodeModelUtils.findActualNodeFor((EObject)targetAnnotation.eContainer());
            offset = containerNode.getOffset();
            int _offset = node.getOffset();
            int _length = node.getLength();
            int _plus = _offset + _length;
            int _offset_1 = containerNode.getOffset();
            length = _minus = _plus - _offset_1;
        }
        if (element instanceof ModifiableElement && document.getLineOfOffset(offset) == document.getLineOfOffset(this.modifierOffset((EObject)((ModifiableElement)element)))) {
            char trailingChar = document.getChar(offset + length);
            char leadingChar = document.getChar(offset - 1);
            if (Character.isWhitespace(leadingChar) && Character.isWhitespace(trailingChar)) {
                ++length;
            }
        }
        return ChangeProvider.removeText(document, offset, length, true);
    }

    public String sortedModifierString(List<N4Modifier> modifierList) {
        return IterableExtensions.join((Iterable)ModifierUtils.getSortedModifiers(modifierList), (CharSequence)" ");
    }
}

