/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassExpression;
import org.eclipse.n4js.n4JS.N4FieldAccessor;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TransformationDependency;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.assistants.TypeAssistant;
import org.eclipse.n4js.transpiler.es.assistants.BootstrapCallAssistant;
import org.eclipse.n4js.transpiler.es.assistants.ClassConstructorAssistant;
import org.eclipse.n4js.transpiler.es.transform.MemberPatchingTransformation;
import org.eclipse.n4js.transpiler.es.transform.SuperLiteralTransformation;
import org.eclipse.n4js.transpiler.im.DelegatingMember;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.transpiler.utils.TranspilerUtils;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@TransformationDependency.RequiresBefore(value={MemberPatchingTransformation.class, SuperLiteralTransformation.class})
public class ClassDeclarationTransformation
extends Transformation {
    @Inject
    private ClassConstructorAssistant classConstructorAssistant;
    @Inject
    private BootstrapCallAssistant bootstrapCallAssistant;
    @Inject
    private TypeAssistant typeAssistant;

    public void assertPreConditions() {
        this.typeAssistant.assertClassifierPreConditions();
        Functions.Function1 _function = it -> it instanceof N4ClassExpression;
        this.assertFalse("class expressions are not supported yet", IteratorExtensions.exists((Iterator)this.getState().im.eAllContents(), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> {
            boolean _isTopLevel = this.typeAssistant.isTopLevel((TypeDefiningElement)it);
            return !_isTopLevel;
        };
        this.assertFalse("only top-level classes are supported, for now", IterableExtensions.exists((Iterable)this.collectNodes((EObject)this.getState().im, N4ClassDeclaration.class, false), (Functions.Function1)_function_1));
    }

    public void assertPostConditions() {
        Functions.Function1 _function = it -> it instanceof N4ClassDeclaration;
        this.assertFalse("there should not be any N4ClassDeclarations in the intermediate model", IteratorExtensions.exists((Iterator)this.getState().im.eAllContents(), (Functions.Function1)_function));
    }

    public void analyze() {
    }

    public void transform() {
        Consumer<N4ClassDeclaration> _function = it -> this.transformClassDecl((N4ClassDeclaration)it);
        this.collectNodes((EObject)this.getState().im, N4ClassDeclaration.class, false).forEach(_function);
    }

    private void transformClassDecl(N4ClassDeclaration classDecl) {
        SymbolTableEntry classSTE = this.findSymbolTableEntryForElement((NamedElement)classDecl, false);
        SymbolTableEntryOriginal superClassSTE = this.typeAssistant.getSuperClassSTE(classDecl);
        FunctionDeclaration ctorDecl = this.classConstructorAssistant.createCtorDecl(classDecl, superClassSTE);
        ExpressionStatement makeClassCall = this.bootstrapCallAssistant.createMakeClassCall(classDecl, (SymbolTableEntry)superClassSTE);
        List<Statement> staticInits = this.createStaticFieldInitializations(classSTE, classDecl);
        this.getState().tracer.copyTrace((EObject)classDecl, new EObject[]{ctorDecl});
        this.getState().tracer.copyTrace((EObject)classDecl, new EObject[]{makeClassCall});
        this.replace(classDecl, ctorDecl);
        this.insertAfter(TranspilerUtils.orContainingExportDeclaration((EObject)ctorDecl), new EObject[]{makeClassCall});
        this.insertAfter((EObject)makeClassCall, (EObject[])Conversions.unwrapArray(staticInits, EObject.class));
        this.getState().info.markAsToHoist(ctorDecl);
    }

    protected List<Statement> createStaticFieldInitializations(SymbolTableEntry steClass, N4ClassDeclaration classDecl) {
        Functions.Function1 _function = it -> it.isStatic();
        Functions.Function1 _function_1 = it -> this.createStaticInitialiserCode((N4MemberDeclaration)it, steClass);
        return IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)classDecl.getOwnedMembers(), (Functions.Function1)_function), (Functions.Function1)_function_1)));
    }

    private Statement _createStaticInitialiserCode(N4FieldDeclaration fieldDecl, SymbolTableEntry steClass) {
        if (!fieldDecl.isStatic() || fieldDecl.getExpression() == null) {
            return null;
        }
        TMember _originalDefinedMember = this.getState().info.getOriginalDefinedMember((N4MemberDeclaration)fieldDecl);
        TField tField = (TField)_originalDefinedMember;
        ParameterizedPropertyAccessExpression_IM __PropertyAccessExpr = TranspilerBuilderBlocks._PropertyAccessExpr();
        Procedures.Procedure1 _function = it -> {
            it.setTarget((Expression)this.__NSSafe_IdentRef(steClass));
            it.setProperty_IM((SymbolTableEntry)this.getSymbolTableEntryOriginal((IdentifiableElement)tField, true));
        };
        ParameterizedPropertyAccessExpression_IM _doubleArrow = (ParameterizedPropertyAccessExpression_IM)ObjectExtensions.operator_doubleArrow((Object)__PropertyAccessExpr, (Procedures.Procedure1)_function);
        ExpressionStatement exprStmnt = TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._AssignmentExpr((Expression)_doubleArrow, (Expression)fieldDecl.getExpression()));
        this.getState().tracer.copyTrace((EObject)fieldDecl, new EObject[]{exprStmnt});
        return exprStmnt;
    }

    private Statement _createStaticInitialiserCode(N4FieldAccessor fieldDecl, SymbolTableEntry steClass) {
        return null;
    }

    private Statement _createStaticInitialiserCode(N4MethodDeclaration methodDecl, SymbolTableEntry steClass) {
        return null;
    }

    private Statement _createStaticInitialiserCode(DelegatingMember accDecl, SymbolTableEntry steClass) {
        return null;
    }

    private Statement createStaticInitialiserCode(N4MemberDeclaration methodDecl, SymbolTableEntry steClass) {
        if (methodDecl instanceof N4MethodDeclaration) {
            return this._createStaticInitialiserCode((N4MethodDeclaration)methodDecl, steClass);
        }
        if (methodDecl instanceof N4FieldAccessor) {
            return this._createStaticInitialiserCode((N4FieldAccessor)methodDecl, steClass);
        }
        if (methodDecl instanceof N4FieldDeclaration) {
            return this._createStaticInitialiserCode((N4FieldDeclaration)methodDecl, steClass);
        }
        if (methodDecl instanceof DelegatingMember) {
            return this._createStaticInitialiserCode((DelegatingMember)methodDecl, steClass);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(methodDecl, steClass).toString());
    }
}

