/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.projectModel.dependencies;

import java.util.Objects;
import org.eclipse.n4js.projectDescription.DependencyType;
import org.eclipse.n4js.projectDescription.ProjectDependency;
import org.eclipse.n4js.projectDescription.ProjectReference;
import org.eclipse.n4js.semver.Semver.NPMVersionRequirement;
import org.eclipse.n4js.semver.SemverUtils;

public class DependencyInfo {
    public final String name;
    public final NPMVersionRequirement version;
    public final DependencyType type;

    public DependencyInfo(String id, NPMVersionRequirement version, DependencyType type) {
        Objects.requireNonNull(version);
        Objects.requireNonNull(type);
        this.name = id;
        this.version = version;
        this.type = type;
    }

    public static DependencyInfo create(ProjectReference projectReference) {
        return new DependencyInfo(DependencyInfo.toName(projectReference), DependencyInfo.toVersion(projectReference), DependencyType.RUNTIME);
    }

    public static DependencyInfo create(ProjectDependency projectDependency) {
        return new DependencyInfo(DependencyInfo.toName((ProjectReference)projectDependency), DependencyInfo.toVersion((ProjectReference)projectDependency), projectDependency.getType());
    }

    private static String toName(ProjectReference projectReference) {
        return projectReference.getProjectName();
    }

    private static NPMVersionRequirement toVersion(ProjectReference projectReference) {
        ProjectDependency prjDep;
        NPMVersionRequirement vr;
        if (projectReference instanceof ProjectDependency && (vr = (prjDep = (ProjectDependency)projectReference).getVersionRequirement()) != null) {
            return vr;
        }
        return SemverUtils.createEmptyVersionRequirement();
    }
}

