/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.util.JavaReflectAccess;
import org.eclipse.xtext.resource.XtextResourceSet;

public interface IJavaReflectAccess {
    public static final IJavaReflectAccess INSTANCE = EcorePlugin.IS_ECLIPSE_RUNNING ? new Delegate() : new RuntimeJavaReflectAccess();

    public Field getField(JvmField var1);

    public Method getMethod(JvmOperation var1);

    public Class<?> getRawType(JvmType var1);

    public static class Delegate
    implements IJavaReflectAccess {
        private IJavaReflectAccess delegate;

        @Override
        public Field getField(JvmField field) {
            return this.delegate.getField(field);
        }

        @Override
        public Method getMethod(JvmOperation operation) {
            return this.delegate.getMethod(operation);
        }

        @Override
        public Class<?> getRawType(JvmType type) {
            return this.delegate.getRawType(type);
        }

        public void setDelegate(IJavaReflectAccess delegate) {
            this.delegate = delegate;
        }
    }

    public static class RuntimeJavaReflectAccess
    implements IJavaReflectAccess {
        @Override
        public Field getField(JvmField field) {
            XtextResourceSet resourceSet = (XtextResourceSet)field.eResource().getResourceSet();
            JavaReflectAccess access = new JavaReflectAccess();
            access.setClassLoader((ClassLoader)resourceSet.getClasspathURIContext());
            return access.getField(field);
        }

        @Override
        public Method getMethod(JvmOperation operation) {
            XtextResourceSet resourceSet = (XtextResourceSet)operation.eResource().getResourceSet();
            JavaReflectAccess access = new JavaReflectAccess();
            access.setClassLoader((ClassLoader)resourceSet.getClasspathURIContext());
            return access.getMethod(operation);
        }

        @Override
        public Class<?> getRawType(JvmType type) {
            XtextResourceSet resourceSet = (XtextResourceSet)type.eResource().getResourceSet();
            JavaReflectAccess access = new JavaReflectAccess();
            access.setClassLoader((ClassLoader)resourceSet.getClasspathURIContext());
            return access.getRawType(type);
        }
    }
}

