/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.contentassist;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.XtextFactory;
import org.eclipse.xtext.ide.editor.contentassist.IFollowElementAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.antlr.FollowElement;
import org.eclipse.xtext.ide.editor.contentassist.antlr.FollowElementCalculator;
import org.eclipse.xtext.ide.editor.contentassist.antlr.FollowElementComputer;
import org.eclipse.xtext.ide.editor.contentassist.antlr.IContentAssistParser;

public class PatchedFollowElementComputer
extends FollowElementComputer {
    @Inject
    IContentAssistParser parser;
    @Inject
    Provider<FollowElementCalculator> feCalculatorProvider;

    public void collectAbstractElements(Grammar grammar, EStructuralFeature feature, IFollowElementAcceptor followElementAcceptor) {
        for (Grammar superGrammar : grammar.getUsedGrammars()) {
            this.collectAbstractElements(superGrammar, feature, followElementAcceptor);
        }
        EClass declarator = feature.getEContainingClass();
        for (ParserRule rule : GrammarUtil.allParserRules((Grammar)grammar)) {
            for (Assignment assignment : GrammarUtil.containedAssignments((EObject)rule)) {
                EClassifier classifier;
                EClassifier compType;
                if (!assignment.getFeature().equals(feature.getName()) || (compType = EcoreUtil2.getCompatibleType((EClassifier)declarator, (EClassifier)(classifier = GrammarUtil.findCurrentType((AbstractElement)assignment)))) != declarator) continue;
                followElementAcceptor.accept((AbstractElement)assignment);
            }
        }
    }

    public void computeFollowElements(Collection<FollowElement> followElements, final IFollowElementAcceptor followElementAcceptor) {
        FollowElementCalculator calculator = (FollowElementCalculator)this.feCalculatorProvider.get();
        calculator.setAcceptor(new IFollowElementAcceptor(){

            public void accept(AbstractElement element) {
                ParserRule rule = GrammarUtil.containingParserRule((EObject)element);
                if (rule == null || !GrammarUtil.isDatatypeRule((ParserRule)rule)) {
                    followElementAcceptor.accept(element);
                }
            }
        });
        for (FollowElement element : followElements) {
            List paramStack = element.getParamStack();
            if (!paramStack.isEmpty()) {
                calculator.setParameterConfig(((Integer)paramStack.get(paramStack.size() - 1)).intValue());
            } else {
                calculator.setParameterConfig(0);
            }
            this.computeFollowElements(calculator, element);
        }
    }

    public void computeFollowElements(Collection<FollowElement> followElements, final Collection<AbstractElement> result) {
        this.computeFollowElements(followElements, new IFollowElementAcceptor(){

            public void accept(AbstractElement element) {
                result.add(element);
            }
        });
    }

    protected void computeFollowElements(FollowElementCalculator calculator, FollowElement element) {
        HashMultimap visited = HashMultimap.create();
        this.computeFollowElements(calculator, element, (Multimap<Integer, List<AbstractElement>>)visited);
    }

    protected void computeFollowElements(FollowElementCalculator calculator, FollowElement element, Multimap<Integer, List<AbstractElement>> visited) {
        ArrayList currentState = Lists.newArrayList((Iterable)element.getLocalTrace());
        currentState.add(element.getGrammarElement());
        if (!visited.put((Object)element.getLookAhead(), (Object)currentState)) {
            return;
        }
        if (element.getLookAhead() <= 1) {
            ParserRule parserRule;
            for (AbstractElement abstractElement : currentState) {
                AbstractElement next;
                int idx;
                Group group;
                EObject container;
                Assignment ass = (Assignment)EcoreUtil2.getContainerOfType((EObject)abstractElement, Assignment.class);
                if (ass != null) {
                    calculator.doSwitch((EObject)ass);
                    continue;
                }
                if (abstractElement instanceof UnorderedGroup && abstractElement == element.getGrammarElement()) {
                    calculator.doSwitch((UnorderedGroup)abstractElement, element.getHandledUnorderedGroupElements());
                    continue;
                }
                calculator.doSwitch((EObject)abstractElement);
                if (GrammarUtil.isOptionalCardinality((AbstractElement)abstractElement)) {
                    AbstractElement nextElement;
                    container = abstractElement.eContainer();
                    if (!(container instanceof Group)) continue;
                    group = (Group)container;
                    idx = group.getElements().indexOf((Object)abstractElement);
                    if (idx == group.getElements().size() - 1) {
                        if (currentState.contains(group) || !GrammarUtil.isMultipleCardinality((AbstractElement)group)) continue;
                        calculator.doSwitch((EObject)group);
                        continue;
                    }
                    if (idx >= group.getElements().size() - 1 || !"?".equals(abstractElement.getCardinality()) || currentState.contains(nextElement = (AbstractElement)group.getElements().get(idx + 1))) continue;
                    calculator.doSwitch((EObject)nextElement);
                    continue;
                }
                if (!this.isAlternativeWithEmptyPath(abstractElement) || !((container = abstractElement.eContainer()) instanceof Group)) continue;
                group = (Group)container;
                idx = group.getElements().indexOf((Object)abstractElement);
                if (currentState.contains(group) || idx == group.getElements().size() - 1 || currentState.contains(next = (AbstractElement)group.getElements().get(idx + 1))) continue;
                calculator.doSwitch((EObject)next);
            }
            if (element.getTrace().equals(element.getLocalTrace()) && (parserRule = GrammarUtil.containingParserRule((EObject)element.getGrammarElement())) != null) {
                RuleCall ruleCall = XtextFactory.eINSTANCE.createRuleCall();
                ruleCall.setRule((AbstractRule)parserRule);
                calculator.doSwitch((EObject)ruleCall);
            }
            return;
        }
        Collection followElements = this.parser.getFollowElements(element);
        for (FollowElement newElement : followElements) {
            if (newElement.getLookAhead() == element.getLookAhead() && newElement.getGrammarElement() == element.getGrammarElement()) continue;
            if (newElement.getLookAhead() == element.getLookAhead()) {
                int originalTraceSize = element.getLocalTrace().size();
                List newTrace = newElement.getLocalTrace();
                if (newTrace.size() > originalTraceSize && Collections.indexOfSubList(element.getLocalTrace(), newTrace.subList(originalTraceSize, newTrace.size())) != -1) continue;
            }
            this.computeFollowElements(calculator, newElement, visited);
        }
    }

    private boolean isAlternativeWithEmptyPath(AbstractElement abstractElement) {
        if (abstractElement instanceof Alternatives) {
            Alternatives alternatives = (Alternatives)abstractElement;
            for (AbstractElement path : alternatives.getElements()) {
                if (!GrammarUtil.isOptionalCardinality((AbstractElement)path)) continue;
                return true;
            }
        }
        return false;
    }
}

