/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class SelectAllProjectExplorerHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        IWorkbenchPart activePart = activePage.getActivePart();
        if (!(activePart instanceof CommonNavigator)) {
            return null;
        }
        CommonNavigator navigator = (CommonNavigator)activePart;
        CommonViewer commonViewer = navigator.getCommonViewer();
        Tree navigatorTree = commonViewer.getTree();
        ArrayList<TreeItem> visibleItems = new ArrayList<TreeItem>();
        this.collectChildren(navigatorTree.getItems(), visibleItems);
        List visibleData = visibleItems.stream().map(i -> i.getData()).collect(Collectors.toList());
        commonViewer.setSelection((ISelection)new StructuredSelection(visibleData), false);
        return null;
    }

    private void collectChildren(TreeItem[] items, List<TreeItem> visibleItems) {
        Arrays.asList(items).stream().filter(i -> i.getData() != null).forEach(item -> {
            visibleItems.add((TreeItem)item);
            if (item.getExpanded()) {
                this.collectChildren(item.getItems(), visibleItems);
            }
        });
    }
}

