/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.organize.imports;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkingSet;

public class SelectionFilesCollector {
    private static final Logger LOGGER = Logger.getLogger(SelectionFilesCollector.class);
    private final Predicate<IFile> fileFilter;

    public SelectionFilesCollector(Predicate<IFile> fileFilter) {
        this.fileFilter = fileFilter;
    }

    public List<IFile> collectFiles(IStructuredSelection structuredSelection) {
        HashSet<IFile> collected = new HashSet<IFile>();
        for (Object object : structuredSelection.toList()) {
            this.collectRelevantFiles(object, collected);
        }
        return Lists.newArrayList(collected);
    }

    private void collectRelevantFiles(Object element, Set<IFile> collected) {
        if (element instanceof IWorkingSet) {
            this.collectIAdaptable((IWorkingSet)element, collected);
        } else if (element instanceof IContainer) {
            this.collectResource((IContainer)element, collected);
        } else if (element instanceof IFile) {
            this.collectIFile((IFile)element, collected);
        } else {
            LOGGER.warn((Object)("Files collector ignores " + element.getClass().getName() + "."));
        }
    }

    private void collectIAdaptable(IWorkingSet workingSet, Set<IFile> collected) {
        IAdaptable[] adaptables;
        IAdaptable[] iAdaptableArray = adaptables = workingSet.getElements();
        int n = adaptables.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable adaptable = iAdaptableArray[n2];
            this.collectRelevantFiles(adaptable, collected);
            ++n2;
        }
    }

    private void collectResource(IContainer container, Set<IFile> collected) {
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = container.members(4);
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                this.collectRelevantFiles(resource, collected);
                ++n2;
            }
        }
        catch (CoreException c) {
            LOGGER.warn((Object)"Error while collecting files", (Throwable)c);
        }
    }

    private void collectIFile(IFile iFile, Set<IFile> collected) {
        if (this.fileFilter.test(iFile)) {
            collected.add(iFile);
        }
    }
}

