/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.preferences.external;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.n4js.semver.Semver.NPMVersionRequirement;
import org.eclipse.n4js.semver.Semver.VersionRangeSetRequirement;
import org.eclipse.n4js.semver.SemverHelper;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.n4js.ui.preferences.external.InstallNpmDependencyDialog;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.utils.StatusHelper;
import org.eclipse.n4js.utils.StatusUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class InstallNpmDependencyButtonListener
extends SelectionAdapter {
    private final Supplier<IInputValidator> packageNameValidator;
    private final Supplier<IInputValidator> packageVersionValidator;
    private final SemverHelper semverHelper;
    private final StatusHelper statusHelper;
    private final BiFunction<Map<String, NPMVersionRequirement>, IProgressMonitor, IStatus> installAction;

    InstallNpmDependencyButtonListener(BiFunction<Map<String, NPMVersionRequirement>, IProgressMonitor, IStatus> installAction, Supplier<IInputValidator> packageNameValidator, Supplier<IInputValidator> packageVersionValidator, SemverHelper semverHelper, StatusHelper statusHelper) {
        this.installAction = installAction;
        this.packageNameValidator = packageNameValidator;
        this.packageVersionValidator = packageVersionValidator;
        this.semverHelper = semverHelper;
        this.statusHelper = statusHelper;
    }

    public void widgetSelected(SelectionEvent e) {
        block12: {
            InstallNpmDependencyDialog dialog = new InstallNpmDependencyDialog(UIUtils.getShell(), this.packageNameValidator.get(), this.packageVersionValidator.get());
            dialog.open();
            String packageName = dialog.getPackageName();
            MultiStatus multistatus = this.statusHelper.createMultiStatus("Installing npm '" + packageName + "'.");
            if (!StringExtensions.isNullOrEmpty((String)packageName) && dialog.getReturnCode() == 0) {
                try {
                    String packageVersionStr = dialog.getVersionConstraint();
                    VersionRangeSetRequirement packageVersion = this.semverHelper.parseVersionRangeSet(packageVersionStr);
                    if (packageVersion != null) {
                        new ProgressMonitorDialog(UIUtils.getShell()).run(true, true, arg_0 -> this.lambda$1(packageName, (NPMVersionRequirement)packageVersion, multistatus, arg_0));
                    }
                }
                catch (InterruptedException | OperationCanceledException packageVersionStr) {
                    if (!multistatus.isOK()) {
                        N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
                        UIUtils.getDisplay().asyncExec(() -> {
                            String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                            ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Install Failed", (String)descr, (IStatus)multistatus);
                        });
                    }
                    break block12;
                }
                catch (Exception exc) {
                    try {
                        String msg = "Error while installing npm dependency: '" + packageName + "'.";
                        Throwable causingExc = exc.getCause() == null ? exc : exc.getCause();
                        multistatus.merge(this.statusHelper.createError(msg, causingExc));
                    }
                    catch (Throwable throwable) {
                        if (!multistatus.isOK()) {
                            N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
                            UIUtils.getDisplay().asyncExec(() -> {
                                String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                                ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Install Failed", (String)descr, (IStatus)multistatus);
                            });
                        }
                        throw throwable;
                    }
                    if (!multistatus.isOK()) {
                        N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
                        UIUtils.getDisplay().asyncExec(() -> {
                            String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                            ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Install Failed", (String)descr, (IStatus)multistatus);
                        });
                    }
                    break block12;
                }
                if (!multistatus.isOK()) {
                    N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
                    UIUtils.getDisplay().asyncExec(() -> {
                        String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                        ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Install Failed", (String)descr, (IStatus)multistatus);
                    });
                }
            }
        }
    }

    private /* synthetic */ void lambda$1(String string, NPMVersionRequirement nPMVersionRequirement, MultiStatus multiStatus, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Map<String, NPMVersionRequirement> singletonMap = Collections.singletonMap(string, nPMVersionRequirement);
        multiStatus.merge(this.installAction.apply(singletonMap, monitor));
    }
}

