/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.components;

import com.google.common.base.Predicate;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.n4js.ui.wizard.components.DotPathUtils;
import org.eclipse.n4js.ui.wizard.model.ClassifierReference;

public class WizardComponentDataConverters {
    public static UpdateValueStrategy<Object, Boolean> strategyForPredicate(final Predicate<Object> predicate) {
        return new ConditionalConverter(){

            @Override
            public boolean validate(Object object) {
                return predicate.apply(object);
            }
        }.updatingValueStrategy();
    }

    public static class ClassifierReferenceToStringConverter
    extends StrategyProvidingConverter<ClassifierReference, String> {
        public ClassifierReferenceToStringConverter() {
            super(ClassifierReference.class, String.class);
        }

        public String convert(ClassifierReference fromObject) {
            if (fromObject != null) {
                return fromObject.getFullSpecifier();
            }
            return null;
        }
    }

    public static abstract class ConditionalConverter
    extends StrategyProvidingConverter<Object, Boolean> {
        public ConditionalConverter() {
            super(Object.class, Boolean.TYPE);
        }

        public Boolean convert(Object fromObject) {
            if (this.validate(fromObject)) {
                return true;
            }
            return false;
        }

        public abstract boolean validate(Object var1);
    }

    private static abstract class StrategyProvidingConverter<S, D>
    extends Converter<S, D> {
        public StrategyProvidingConverter(Object fromType, Object toType) {
            super(fromType, toType);
        }

        public UpdateValueStrategy<S, D> updatingValueStrategy() {
            UpdateValueStrategy strat = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
            strat.setConverter((IConverter)this);
            return strat;
        }
    }

    public static class StringToClassifierReferenceConverter
    extends StrategyProvidingConverter<String, ClassifierReference> {
        public StringToClassifierReferenceConverter() {
            super(String.class, ClassifierReference.class);
        }

        public ClassifierReference convert(String fromObject) {
            if (fromObject != null) {
                return new ClassifierReference(DotPathUtils.frontDotSegments(fromObject), DotPathUtils.lastDotSegment(fromObject));
            }
            return null;
        }
    }

    public static class StringToPathConverter
    extends StrategyProvidingConverter<String, IPath> {
        public StringToPathConverter() {
            super(String.class, IPath.class);
        }

        public IPath convert(String fromObject) {
            if (fromObject != null) {
                return new Path(fromObject);
            }
            return null;
        }
    }
}

