/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.binary.asm;

import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.common.types.JvmAnnotationAnnotationValue;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.binary.asm.BinarySignatures;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryTypeSignature;
import org.eclipse.xtext.common.types.access.binary.asm.JvmAnnotationValueBuilder;
import org.eclipse.xtext.common.types.access.binary.asm.Proxies;
import org.objectweb.asm.AnnotationVisitor;

public class JvmAnnotationReferenceBuilder
extends AnnotationVisitor {
    protected final Proxies proxies;
    private final InternalEList<JvmAnnotationReference> target;
    private final JvmAnnotationReference result;
    private final InternalEList<JvmAnnotationValue> values;
    private final BinaryTypeSignature annotationType;

    public JvmAnnotationReferenceBuilder(InternalEList<JvmAnnotationReference> target, String desc, Proxies proxies) {
        super(327680);
        this.proxies = proxies;
        this.target = target;
        this.annotationType = BinarySignatures.createTypeSignature(desc);
        this.result = TypesFactory.eINSTANCE.createJvmAnnotationReference();
        this.result.setAnnotation(proxies.createAnnotationProxy(this.annotationType));
        this.values = (InternalEList)this.result.getExplicitValues();
    }

    public void visit(String name, Object value) {
        JvmAnnotationValue annotationValue = this.proxies.createAnnotationValue(value);
        annotationValue.setOperation(this.proxies.createMethodProxy(this.annotationType, name));
        this.values.addUnique((Object)annotationValue);
    }

    public void visitEnum(String name, String desc, String value) {
        JvmEnumAnnotationValue result = TypesFactory.eINSTANCE.createJvmEnumAnnotationValue();
        JvmEnumerationLiteral enumLiteralProxy = this.proxies.createEnumLiteral(value, desc);
        ((InternalEList)result.getValues()).addUnique((Object)enumLiteralProxy);
        result.setOperation(this.proxies.createMethodProxy(this.annotationType, name));
        this.values.addUnique((Object)result);
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        JvmAnnotationAnnotationValue annotationValue = TypesFactory.eINSTANCE.createJvmAnnotationAnnotationValue();
        InternalEList nestedValues = (InternalEList)annotationValue.getValues();
        annotationValue.setOperation(this.proxies.createMethodProxy(this.annotationType, name));
        JvmAnnotationReferenceBuilder annotation = new JvmAnnotationReferenceBuilder((InternalEList<JvmAnnotationReference>)nestedValues, desc, this.proxies);
        this.values.addUnique((Object)annotationValue);
        return annotation;
    }

    public AnnotationVisitor visitArray(final String name) {
        return new JvmAnnotationValueBuilder(this.proxies){

            public void visitEnd() {
                if (this.result == null) {
                    this.result = TypesFactory.eINSTANCE.createJvmCustomAnnotationValue();
                }
                this.result.setOperation(this.proxies.createMethodProxy(JvmAnnotationReferenceBuilder.this.annotationType, name));
                JvmAnnotationReferenceBuilder.this.values.addUnique((Object)this.result);
            }
        };
    }

    public void visitEnd() {
        this.target.addUnique((Object)this.result);
    }
}

