/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.internal;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.internal.AbstractN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.ui.internal.N4JSEclipseModel;
import org.eclipse.n4js.ui.internal.N4JSEclipseProject;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseCore;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseProject;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

@Singleton
public class N4JSEclipseCore
extends AbstractN4JSCore
implements IN4JSEclipseCore {
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    private final N4JSEclipseModel model;

    @Inject
    public N4JSEclipseCore(N4JSEclipseModel model) {
        this.model = model;
    }

    @Override
    public Optional<? extends IN4JSEclipseProject> create(IProject project) {
        if (project == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)this.model.getN4JSProject(project));
    }

    @Override
    public Optional<? extends IN4JSEclipseProject> findProject(URI nestedLocation) {
        if (nestedLocation == null) {
            return Optional.absent();
        }
        N4JSEclipseProject result = this.model.findProjectWith(nestedLocation);
        return Optional.fromNullable((Object)result);
    }

    public Iterable<IN4JSProject> findAllProjects() {
        return this.model.findAllProjects();
    }

    public Map<String, IN4JSProject> findAllProjectMappings() {
        return this.model.findAllProjectMappings();
    }

    public Optional<? extends IN4JSSourceContainer> findN4JSSourceContainer(URI nestedLocation) {
        if (nestedLocation == null) {
            return Optional.absent();
        }
        return this.model.findN4JSSourceContainer(nestedLocation);
    }

    @Override
    public Optional<? extends IN4JSSourceContainer> create(IFile eclipseFile) {
        if (eclipseFile == null) {
            return Optional.absent();
        }
        return this.model.getN4JSSourceContainer((IResource)eclipseFile);
    }

    @Override
    public Optional<? extends IN4JSSourceContainer> create(IFolder eclipseFolder) {
        if (eclipseFolder == null) {
            return Optional.absent();
        }
        return this.model.getN4JSSourceContainer((IResource)eclipseFolder);
    }

    @Override
    public IN4JSEclipseProject create(URI location) {
        if (location == null) {
            return null;
        }
        return this.model.getN4JSProject(location);
    }

    public ResourceSet createResourceSet(Optional<IN4JSProject> contextProject) {
        IProject eclipseProject = contextProject.isPresent() ? ((IN4JSEclipseProject)contextProject.get()).getProject() : null;
        ResourceSet resourceSet = this.resourceSetProvider.get(eclipseProject);
        resourceSet.getLoadOptions().put("org.eclipse.xtext.builder.impl.PersistentDataAwareDirtyResource.PERSISTED_DESCRIPTIONS", Boolean.TRUE);
        return resourceSet;
    }

    public IResourceDescriptions getXtextIndex(ResourceSet resourceSet) {
        return this.resourceDescriptionsProvider.getResourceDescriptions(resourceSet);
    }
}

