/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.navigator;

import com.google.inject.Inject;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.navigator.N4JSProjectExplorerProblemsDecorator;
import org.eclipse.n4js.ui.navigator.internal.N4JSProjectExplorerHelper;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetLabelProvider;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerBroker;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class N4JSProjectExplorerLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final Image SRC_FOLDER_IMG = (Image)ImageDescriptorCache.ImageRef.SRC_FOLDER.asImage().orNull();
    private static final Image WORKING_SET_IMG = (Image)ImageDescriptorCache.ImageRef.WORKING_SET.asImage().orNull();
    @Inject
    private N4JSProjectExplorerHelper helper;
    @Inject
    private WorkingSetManagerBroker workingSetManagerBroker;
    private final ILabelProvider delegate;
    private final ProblemsLabelDecorator decorator = new N4JSProjectExplorerProblemsDecorator();
    private final ILabelProviderListener workingSetLabelProviderListener;
    private final WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();

    public N4JSProjectExplorerLabelProvider() {
        this.delegate = new DecoratingLabelProvider((ILabelProvider)this.workbenchLabelProvider, (ILabelDecorator)this.decorator);
        this.workingSetLabelProviderListener = new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                LabelProviderChangedEvent wrapperEvent = N4JSProjectExplorerLabelProvider.this.createWorkingSetWrapperEvent(event);
                if (wrapperEvent != null) {
                    UIUtils.getDisplay().asyncExec(() -> N4JSProjectExplorerLabelProvider.this.fireLabelProviderChanged(wrapperEvent));
                }
            }
        };
        this.delegate.addListener(this.workingSetLabelProviderListener);
    }

    public String getText(Object element) {
        if (element instanceof WorkingSet) {
            return WorkingSetLabelProvider.INSTANCE.getText(element);
        }
        return this.delegate.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof WorkingSet) {
            return this.decorator.decorateImage(WORKING_SET_IMG, element);
        }
        return this.delegate.getImage(element);
    }

    public void dispose() {
        super.dispose();
        this.delegate.removeListener(this.workingSetLabelProviderListener);
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof WorkingSet) {
            return WorkingSetLabelProvider.INSTANCE.getStyledText(element);
        }
        return this.workbenchLabelProvider.getStyledText(element);
    }

    private LabelProviderChangedEvent createWorkingSetWrapperEvent(LabelProviderChangedEvent event) {
        Object[] workingSets;
        WorkingSetManager manager;
        if (event instanceof ProblemsLabelDecorator.ProblemsLabelChangedEvent && this.workingSetManagerBroker.isWorkingSetTopLevel() && (manager = this.workingSetManagerBroker.getActiveManager()) != null && !Arrays2.isEmpty((Object[])(workingSets = manager.getWorkingSets()))) {
            return new LabelProviderChangedEvent((IBaseLabelProvider)this.delegate, workingSets);
        }
        return null;
    }
}

