/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.state;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xpect.state.Configuration;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.state.Default;
import org.eclipse.xpect.state.Invalidates;
import org.eclipse.xpect.state.Managed;
import org.eclipse.xpect.state.ManagedImpl;
import org.eclipse.xpect.state.StateContainer;
import org.eclipse.xpect.state.XpectStateAnnotation;
import org.eclipse.xpect.text.CharSequences;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class ResolvedConfiguration {
    private final List<Throwable> errors;
    private final String name;
    private final List<Class<?>> overwrittenFactories;
    private final ResolvedConfiguration parent;
    private final List<Factory> resolvedFactories;
    private final List<Factory> unresolvedFactories;
    private final Multimap<Class<? extends Annotation>, Value> values;

    public ResolvedConfiguration(Configuration configuration) {
        this(null, configuration);
    }

    public ResolvedConfiguration(ResolvedConfiguration parent, Configuration configuration) {
        this.parent = parent;
        this.errors = Lists.newArrayList();
        this.name = configuration.getName();
        Set<Class<?>> allFactoryClasses = this.collectAllFactoryClasses(parent, configuration);
        Set<Class<?>> overwrittenFactoryClasses = this.collectOverwrittenClasses(allFactoryClasses);
        Sets.SetView activeFactoryClasses = Sets.difference(allFactoryClasses, overwrittenFactoryClasses);
        Multimap<Class<? extends Annotation>, Value> allValues = this.collectAllValues((Collection<Class<?>>)activeFactoryClasses, configuration);
        Multimap<Class<?>, DerivedValue> annotatio2value = this.collectDerivedValuesByFactory(allValues.values());
        Set<Factory> allFactories = this.collectAllFactories(allValues, annotatio2value);
        Set<Factory> resolvedFactories = this.collectResolvedFactories(allFactories);
        Multimap<Class<? extends Annotation>, Value> resolvedValues = this.collectValues(allValues, resolvedFactories);
        this.overwrittenFactories = ImmutableList.copyOf(overwrittenFactoryClasses);
        this.resolvedFactories = ImmutableList.copyOf(resolvedFactories);
        this.unresolvedFactories = ImmutableList.copyOf((Collection)Sets.difference(allFactories, resolvedFactories));
        this.values = ImmutableMultimap.copyOf(resolvedValues);
    }

    protected void checkMarkerAnnotation(Class<? extends Annotation> annotation) {
        Retention retention = annotation.getAnnotation(Retention.class);
        if (retention == null) {
            throw new IllegalStateException("@Retention annotation missing on @" + annotation.getName());
        }
        if (retention.value() != RetentionPolicy.RUNTIME) {
            throw new IllegalStateException("RetentionPolicy on @" + annotation.getName() + " must be RUNTIME");
        }
        XpectStateAnnotation stateAnnotation = annotation.getAnnotation(XpectStateAnnotation.class);
        if (stateAnnotation == null) {
            throw new IllegalStateException("@" + XpectStateAnnotation.class.getSimpleName() + " annotation missing on @" + annotation.getName());
        }
    }

    protected Set<Factory> collectAllFactories(Multimap<Class<? extends Annotation>, Value> all, Multimap<Class<?>, DerivedValue> derived) {
        ConstructorComparator comparator = new ConstructorComparator();
        LinkedHashSet result = Sets.newLinkedHashSet();
        block0: for (Class factory : derived.keySet()) {
            ArrayList constructors = Lists.newArrayList((Object[])factory.getConstructors());
            Collections.sort(constructors, comparator);
            for (Constructor constructor : constructors) {
                Value[] in = this.findParams(all, constructor);
                Collection out = derived.get((Object)factory);
                Factory fact = new Factory(constructor, in, out);
                result.add(fact);
                boolean resolved = true;
                Value[] valueArray = in;
                int n = in.length;
                int n2 = 0;
                while (n2 < n) {
                    Value i = valueArray[n2];
                    resolved &= i != null;
                    ++n2;
                }
                if (!resolved) continue;
                for (DerivedValue m : out) {
                    m.factory = fact;
                }
                continue block0;
            }
        }
        return result;
    }

    protected Set<Class<?>> collectAllFactoryClasses(ResolvedConfiguration parent, Configuration cfg) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        if (parent != null) {
            for (Factory fact : parent.getUnresolvedFactories()) {
                result.add(fact.getOwner());
            }
        }
        result.addAll(cfg.getFactories());
        return result;
    }

    protected Multimap<Class<? extends Annotation>, Value> collectAllValues(Collection<Class<?>> factories2, Configuration config) {
        LinkedHashMultimap annotatio2value = LinkedHashMultimap.create();
        annotatio2value.put(Default.class, (Object)new PrimaryValue(Default.class, StateContainer.class, new ManagedImpl<Object>(null)));
        for (Map.Entry entry : config.getValues().asMap().entrySet()) {
            for (Pair value : (Collection)entry.getValue()) {
                this.checkMarkerAnnotation((Class)entry.getKey());
                annotatio2value.put((Object)((Class)entry.getKey()), (Object)new PrimaryValue((Class)entry.getKey(), (Class)value.getFirst(), (Managed)value.getSecond()));
            }
        }
        for (Class clazz : factories2) {
            DerivedValue value;
            Annotation annotation;
            Method m;
            Method[] methods;
            boolean found = false;
            Map<TypeVariable<?>, Class<?>> parameterBindings = this.getTypeParameterBindings(clazz, (Multimap<Class<? extends Annotation>, Value>)annotatio2value);
            HashMap values = Maps.newHashMap();
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                m = methodArray[n2];
                annotation = m.getAnnotation(Creates.class);
                if (annotation != null) {
                    found = true;
                    Class<?> returnType = this.getReturnType(m, parameterBindings);
                    value = new DerivedValue(clazz, m, returnType);
                    this.checkMarkerAnnotation(annotation.value());
                    annotatio2value.put(annotation.value(), (Object)value);
                    values.put(Tuples.create(annotation.value(), value.getType()), value);
                }
                ++n2;
            }
            if (!found) {
                this.errors.add(new IllegalStateException("No CreateMethods found in " + clazz));
            }
            methodArray = methods;
            n = methods.length;
            n2 = 0;
            while (n2 < n) {
                m = methodArray[n2];
                annotation = m.getAnnotation(Invalidates.class);
                if (annotation != null) {
                    Class<?>[] parameterTypes = m.getParameterTypes();
                    if (parameterTypes.length != 1) {
                        this.errors.add(new IllegalStateException("Invalidate-methods must have exactly one parameter. method: " + m));
                    } else {
                        value = (DerivedValue)values.get(Tuples.create(annotation.annotatedWith(), parameterTypes[0]));
                        if (value == null) {
                            this.errors.add(new IllegalStateException("No @Creates-method found for invalidate-method. method: " + m));
                        } else if (value.invalidator != null) {
                            this.errors.add(new IllegalStateException("Can not have two invalidate-methods for the same annotation/type. method: " + m));
                        } else {
                            value.invalidator = m;
                        }
                    }
                }
                ++n2;
            }
        }
        return annotatio2value;
    }

    protected Multimap<Class<?>, DerivedValue> collectDerivedValuesByFactory(Collection<Value> values) {
        LinkedHashMultimap annotatio2value = LinkedHashMultimap.create();
        for (Value val : values) {
            if (!(val instanceof DerivedValue)) continue;
            DerivedValue cm = (DerivedValue)val;
            annotatio2value.put(cm.getOwner(), (Object)cm);
        }
        return annotatio2value;
    }

    protected Set<Class<?>> collectOverwrittenClasses(Set<Class<?>> classes) {
        LinkedHashSet superClasses = Sets.newLinkedHashSet();
        for (Class<?> c : classes) {
            Class<?> current = c.getSuperclass();
            while (current != Object.class && superClasses.add(current)) {
                current = current.getSuperclass();
            }
        }
        return Sets.intersection(classes, (Set)superClasses);
    }

    protected Set<Factory> collectResolvedFactories(Collection<Factory> factory) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        HashMap cache = Maps.newHashMap();
        for (Factory fact : factory) {
            if (!this.isResolved(fact, cache)) continue;
            result.add(fact);
        }
        return result;
    }

    protected Multimap<Class<? extends Annotation>, Value> collectValues(Multimap<Class<? extends Annotation>, Value> all, Set<Factory> factories) {
        HashMultimap result = HashMultimap.create();
        for (Value v : all.values()) {
            if (v instanceof PrimaryValue) {
                result.put(v.getAnnotatedWith(), (Object)v);
                continue;
            }
            if (!(v instanceof DerivedValue) || !factories.contains(((DerivedValue)v).getFactory())) continue;
            result.put(v.getAnnotatedWith(), (Object)v);
        }
        return result;
    }

    protected Value[] findParams(Multimap<Class<? extends Annotation>, Value> annotation2values, Constructor<?> constructor) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Value[] result = new Value[parameterTypes.length];
        Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
        int i = 0;
        while (i < parameterTypes.length) {
            Collection<Value> vals = this.findValues(annotation2values, parameterAnnotations[i]);
            if (vals != null) {
                Value value = this.findValue(vals, parameterTypes[i]);
                if (value == null && this.parent != null) {
                    value = this.parent.getValue(parameterAnnotations[i].length > 0 ? parameterAnnotations[i][0].annotationType() : Default.class, parameterTypes[i]);
                }
                result[i] = value;
            }
            ++i;
        }
        return result;
    }

    protected Value findValue(Collection<Value> values, Class<?> expectedType) {
        for (Value val : values) {
            Class<?> type = val.getType();
            if (type == null || !expectedType.isAssignableFrom(type)) continue;
            return val;
        }
        return null;
    }

    protected Collection<Value> findValues(Multimap<Class<? extends Annotation>, Value> annotation2values, Annotation[] annotations) {
        if (annotations.length == 0) {
            return annotation2values.get(Default.class);
        }
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            Collection result = annotation2values.get(a.annotationType());
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    public String getName() {
        return this.name;
    }

    public List<Class<?>> getOverwrittenFactories() {
        return this.overwrittenFactories;
    }

    public ResolvedConfiguration getParent() {
        return this.parent;
    }

    public List<PrimaryValue> getPrimaryValues() {
        ArrayList result = Lists.newArrayList();
        for (Value val : this.values.values()) {
            if (!(val instanceof PrimaryValue)) continue;
            result.add((PrimaryValue)val);
        }
        return result;
    }

    public List<Factory> getResolvedFactories() {
        return this.resolvedFactories;
    }

    protected Class<?> getReturnType(Method method, Map<TypeVariable<?>, Class<?>> parameterBindings) {
        Type genericReturnType = method.getGenericReturnType();
        if (genericReturnType instanceof TypeVariable) {
            Class<?> binding = parameterBindings.get(genericReturnType);
            return binding;
        }
        Class<?> returnType = method.getReturnType();
        if (returnType == Managed.class) {
            ParameterizedType type = (ParameterizedType)method.getGenericReturnType();
            return (Class)type.getActualTypeArguments()[0];
        }
        return returnType;
    }

    protected Map<TypeVariable<?>, Class<?>> getTypeParameterBindings(Class<?> client, Multimap<Class<? extends Annotation>, Value> annotatio2value) {
        if (client.getTypeParameters().length == 0) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        Constructor<?>[] constructorArray = client.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> c = constructorArray[n2];
            Type[] parameterTypes = c.getGenericParameterTypes();
            Annotation[][] annotations = c.getParameterAnnotations();
            int i = 0;
            while (i < parameterTypes.length) {
                ParameterizedType pt;
                if (parameterTypes[i] instanceof ParameterizedType && (pt = (ParameterizedType)parameterTypes[i]).getRawType() == Class.class) {
                    Class<Default> a = annotations[i].length > 0 ? annotations[i][0].annotationType() : Default.class;
                    Type[] typeArray = pt.getActualTypeArguments();
                    int n3 = typeArray.length;
                    int n4 = 0;
                    block2: while (n4 < n3) {
                        Type arg = typeArray[n4];
                        if (arg instanceof TypeVariable) {
                            TypeVariable var = (TypeVariable)arg;
                            Class binding = null;
                            for (Value value : annotatio2value.get(a)) {
                                if (!(value instanceof PrimaryValue) || value.getType() != Class.class) continue;
                                binding = (Class)((PrimaryValue)value).getValue().get();
                            }
                            if (binding != null && !binding.getName().startsWith("org.eclipse.xpect")) {
                                Type[] typeArray2 = var.getBounds();
                                int n5 = typeArray2.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    Type bound = typeArray2[n6];
                                    if (!(bound instanceof Class) || !((Class)bound).isAssignableFrom(binding)) break block2;
                                    ++n6;
                                }
                                result.put(var, binding);
                            }
                        }
                        ++n4;
                    }
                }
                ++i;
            }
            ++n2;
        }
        return result;
    }

    public List<Factory> getUnresolvedFactories() {
        return this.unresolvedFactories;
    }

    public Value getValue(Class<? extends Annotation> annotatedWith, Class<?> expectedType) {
        for (Value val : this.values.get(annotatedWith)) {
            if (expectedType != val.getType()) continue;
            return val;
        }
        if (this.parent != null) {
            return this.parent.getValue(annotatedWith, expectedType);
        }
        return null;
    }

    public Multimap<Class<? extends Annotation>, Value> getValues() {
        return this.values;
    }

    protected boolean isResolved(Factory fact, Map<Factory, Boolean> cache) {
        if (fact == null || !fact.isResolved()) {
            return false;
        }
        Boolean result = cache.get(fact);
        if (result != null) {
            return result;
        }
        Value[] valueArray = fact.getIn();
        int n = valueArray.length;
        int n2 = 0;
        while (n2 < n) {
            Value in = valueArray[n2];
            if (in == null || in instanceof DerivedValue && !this.isResolved(((DerivedValue)in).getFactory(), cache)) {
                cache.put(fact, false);
                return false;
            }
            ++n2;
        }
        cache.put(fact, true);
        return true;
    }

    /*
     * Could not resolve type clashes
     */
    public String toString() {
        ArrayList result = Lists.newArrayList();
        if (this.name != null) {
            result.add("------------ " + this.name + " ------------");
        }
        if (!this.errors.isEmpty()) {
            result.add("Errors {");
            ArrayList err = Lists.newArrayList();
            for (Throwable error : this.errors) {
                err.add("    " + error.getMessage());
            }
            Collections.sort(err);
            result.addAll(err);
            result.add("}");
        }
        result.add("Primary Values {");
        ArrayList vals = Lists.newArrayList();
        for (Value val : this.values.values()) {
            if (!(val instanceof PrimaryValue)) continue;
            vals.add("    " + val.toString());
        }
        Collections.sort(vals);
        result.addAll(vals);
        result.add("}");
        result.add("Derived Values {");
        for (Factory fact : Iterables.concat(this.resolvedFactories, this.unresolvedFactories)) {
            result.add("    " + (fact.isResolved() ? "" : "UNRESOLVED ") + fact.getConstructor().getName() + " {");
            ArrayList f = Lists.newArrayList();
            Value[] in2 = fact.getIn();
            int i = 0;
            while (i < in2.length) {
                if (in2[i] == null) {
                    f.add("        in (unresolved " + fact.getConstructor().getParameterTypes()[i] + ")");
                } else {
                    f.add("        in " + in2[i]);
                }
                ++i;
            }
            for (Value out : fact.getOut()) {
                f.add("        out " + out);
            }
            Collections.sort(f);
            result.addAll(f);
            result.add("    }");
        }
        result.add("}");
        if (this.parent != null) {
            result.add(this.parent.toString());
        }
        return Joiner.on((String)"\n").join((Iterable)result);
    }

    protected static class ConstructorComparator
    implements Comparator<Constructor<?>> {
        private final Map<Class<?>, Integer> depth = Maps.newHashMap();

        protected ConstructorComparator() {
        }

        @Override
        public int compare(Constructor<?> o1, Constructor<?> o2) {
            Class<?>[] p1 = o1.getParameterTypes();
            Class<?>[] p2 = o2.getParameterTypes();
            int r = p2.length - p1.length;
            if (r != 0) {
                return r;
            }
            int i = 0;
            while (i < p1.length) {
                int d = this.depth(p2[i]) - this.depth(p1[i]);
                if (d != 0) {
                    return d;
                }
                ++i;
            }
            return 0;
        }

        protected int depth(Class<?> cls) {
            if (cls == null) {
                return 0;
            }
            Integer integer = this.depth.get(cls);
            if (integer != null) {
                return integer;
            }
            integer = this.depth(cls.getSuperclass());
            Class<?>[] classArray = cls.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> iface = classArray[n2];
                Integer d = this.depth(iface);
                if (d > integer) {
                    integer = d;
                }
                ++n2;
            }
            return integer + 1;
        }
    }

    public static class DerivedValue
    extends Value {
        private Factory factory;
        private Method invalidator;
        private final Method method;
        private final Class<?> owner;

        public DerivedValue(Class<?> owner, Method method, Class<?> returnType) {
            super(returnType);
            this.owner = owner;
            this.method = method;
        }

        @Override
        public Class<? extends Annotation> getAnnotatedWith() {
            return this.method.getAnnotation(Creates.class).value();
        }

        public Factory getFactory() {
            return this.factory;
        }

        public Method getInvalidator() {
            return this.invalidator;
        }

        public Method getMethod() {
            return this.method;
        }

        public Class<?> getOwner() {
            return this.owner;
        }

        public String toString() {
            Class<? extends Annotation> annotatedWith = this.getAnnotatedWith();
            String an = annotatedWith != Default.class ? "@" + annotatedWith.getSimpleName() + " " : "";
            String m = String.valueOf(this.owner.getSimpleName()) + "." + this.method.getName() + "()";
            String t = this.getType() != null ? this.getType().getSimpleName() : "(unresolved)";
            return String.valueOf(this.getClass().getSimpleName()) + "[" + an + t + " " + m + "]";
        }
    }

    public static class Factory {
        private final Constructor<?> constructor;
        private final Value[] in;
        private final Collection<DerivedValue> out;

        public Factory(Constructor<?> constructor, Value[] in, Collection<DerivedValue> out) {
            this.constructor = constructor;
            this.in = in;
            this.out = Collections.unmodifiableCollection(out);
        }

        public Constructor<?> getConstructor() {
            return this.constructor;
        }

        public Value[] getIn() {
            return this.in;
        }

        public Collection<DerivedValue> getOut() {
            return this.out;
        }

        public Class<?> getOwner() {
            return this.constructor.getDeclaringClass();
        }

        public boolean isResolved() {
            Value[] valueArray = this.in;
            int n = this.in.length;
            int n2 = 0;
            while (n2 < n) {
                Value i = valueArray[n2];
                if (i == null) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var2_3;
            ArrayList f = Lists.newArrayList();
            boolean bl = false;
            while (var2_3 < this.in.length) {
                if (this.in == null) {
                    f.add("unresolved " + this.constructor.getParameterTypes()[var2_3]);
                } else {
                    f.add("  in " + this.in);
                }
                ++var2_3;
            }
            for (Value value : this.getOut()) {
                f.add("  out " + value);
            }
            Collections.sort(f);
            return this.getConstructor() + " {\n  " + Joiner.on((char)'\n').join((Iterable)f) + "\n}";
        }
    }

    public static class PrimaryValue
    extends Value {
        private final Class<? extends Annotation> annotatedWith;
        private final Managed<?> value;

        public PrimaryValue(Class<? extends Annotation> annotatedWith, Class<?> type, Managed<?> value) {
            super(type);
            this.annotatedWith = annotatedWith;
            this.value = value;
        }

        @Override
        public Class<? extends Annotation> getAnnotatedWith() {
            return this.annotatedWith;
        }

        public Managed<?> getValue() {
            return this.value;
        }

        public String toString() {
            String an = this.annotatedWith != Default.class ? "@" + this.annotatedWith.getSimpleName() + " " : "";
            String val = CharSequences.toSingleLineString(this.value, 80);
            return String.valueOf(this.getClass().getSimpleName()) + "[" + an + this.getType().getSimpleName() + " " + val + "]";
        }
    }

    public static abstract class Value {
        private final Class<?> type;

        public Value(Class<?> type) {
            this.type = type;
        }

        public abstract Class<? extends Annotation> getAnnotatedWith();

        public Class<?> getType() {
            return this.type;
        }
    }
}

