/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.n4js.conversion.N4JSValueConverterException;
import org.eclipse.n4js.conversion.N4JSValueConverterWithValueException;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class OctalIntValueConverter
extends AbstractLexerBasedConverter<BigDecimal> {
    protected String toEscapedString(BigDecimal value) {
        return "0o" + value.toBigInteger().toString(8);
    }

    protected void assertValidValue(BigDecimal value) {
        super.assertValidValue((Object)value);
        if (value.signum() == -1) {
            throw new N4JSValueConverterException(IssueCodes.getMessageForVCO_HEXINT_NEGATIVE(this.getRuleName(), value), "VCO_OCTALINT_NEGATIVE", null, null);
        }
    }

    public BigDecimal toValue(String string, INode node) {
        if (Strings.isEmpty((String)string)) {
            throw new N4JSValueConverterException(IssueCodes.getMessageForVCO_OCTALINT_CONVERT_EMPTY_STR(), "VCO_OCTALINT_CONVERT_EMPTY_STR", node, null);
        }
        if (string.length() <= 2) {
            throw new N4JSValueConverterWithValueException(IssueCodes.getMessageForVCO_OCTALINT_CONVERT_TOO_SHORT(string), "VCO_OCTALINT_CONVERT_TOO_SHORT", node, BigDecimal.ZERO, null);
        }
        try {
            return new BigDecimal(new BigInteger(string.substring(2), 8));
        }
        catch (NumberFormatException e) {
            throw new N4JSValueConverterException(IssueCodes.getMessageForVCO_OCTALINT_CONVERT_STR(string), "VCO_OCTALINT_CONVERT_STR", node, null);
        }
    }
}

