/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.classifiers;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ui.wizard.classifiers.N4JSClassifierWizardModel;
import org.eclipse.n4js.ui.wizard.model.AccessModifier;
import org.eclipse.n4js.ui.wizard.model.ClassifierReference;
import org.eclipse.n4js.ui.wizard.workspace.WorkspaceWizardModelValidator;
import org.eclipse.n4js.utils.N4JSLanguageHelper;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;

public abstract class N4JSClassifierWizardModelValidator<M extends N4JSClassifierWizardModel>
extends WorkspaceWizardModelValidator<M> {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private N4JSLanguageHelper languageHelper;
    private IResourceDescriptions descriptions;

    protected void validateClassifierName() throws WorkspaceWizardModelValidator.ValidationException {
        if (((N4JSClassifierWizardModel)this.getModel()).getName().trim().length() < 1) {
            throw new WorkspaceWizardModelValidator.ValidationException(String.format("The %s name field must not be empty.", this.getClassifierName()));
        }
        String className = ((N4JSClassifierWizardModel)this.getModel()).getName();
        if (!N4JSLanguageUtils.isValidIdentifier((String)className)) {
            throw new WorkspaceWizardModelValidator.ValidationException(String.format("Invalid %s name.", this.getClassifierName()));
        }
        if (this.languageHelper.isReservedIdentifier(className)) {
            throw new WorkspaceWizardModelValidator.ValidationException(String.format("The %s name '%s' is a reserved N4JS identifier.", this.getClassifierName(), className));
        }
    }

    @Override
    protected void validateModuleSpecifier() throws WorkspaceWizardModelValidator.ValidationException {
        String effectiveModuleSpecifier = ((N4JSClassifierWizardModel)this.getModel()).getEffectiveModuleSpecifier();
        this.doValidateModuleSpecifier(effectiveModuleSpecifier);
        if (this.isFileSpecifyingModuleSpecifier(effectiveModuleSpecifier)) {
            IProject moduleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(((N4JSClassifierWizardModel)this.getModel()).getProject().toString());
            Path effectiveModulePath = new Path(((N4JSClassifierWizardModel)this.getModel()).getEffectiveModuleSpecifier());
            IPath n4jsdPath = ((N4JSClassifierWizardModel)this.getModel()).getSourceFolder().append(effectiveModulePath.addFileExtension("n4jsd"));
            IPath n4jsPath = ((N4JSClassifierWizardModel)this.getModel()).getSourceFolder().append(effectiveModulePath.addFileExtension("n4js"));
            if (((N4JSClassifierWizardModel)this.getModel()).isDefinitionFile() && moduleProject.exists(n4jsPath)) {
                throw new WorkspaceWizardModelValidator.ValidationException(String.format("The new definition module collides with the source file: %s", moduleProject.getFullPath().append(n4jsPath)));
            }
            if (!((N4JSClassifierWizardModel)this.getModel()).isDefinitionFile() && moduleProject.exists(n4jsdPath)) {
                throw new WorkspaceWizardModelValidator.ValidationException(String.format("The new source module collides with the definition file: %s", moduleProject.getFullPath().append(n4jsdPath)));
            }
        }
    }

    protected void validateInterfaces() throws WorkspaceWizardModelValidator.ValidationException {
        ArrayList<ClassifierReference> interfaces = new ArrayList<ClassifierReference>(((N4JSClassifierWizardModel)this.getModel()).getInterfaces());
        int i = 0;
        while (i < interfaces.size()) {
            IEObjectDescription interfaceDescription;
            ClassifierReference iface = interfaces.get(i);
            if (!this.isValidInterface(iface)) {
                throw new WorkspaceWizardModelValidator.ValidationException(String.format("The interface %s cannot be found.", iface.getFullSpecifier()).toString());
            }
            if (iface.uri == null && (interfaceDescription = this.getClassifierObjectDescriptionForFQN(iface.getFullSpecifier())) != null) {
                iface.uri = interfaceDescription.getEObjectURI();
            }
            ++i;
        }
        ((N4JSClassifierWizardModel)this.getModel()).setInterfaces(interfaces);
    }

    protected String getClassifierName() {
        return ((N4JSClassifierWizardModel)this.getModel()).getClassifierName();
    }

    @Override
    protected void prepare() {
        if (!((N4JSClassifierWizardModel)this.getModel()).isDefinitionFile() && ((N4JSClassifierWizardModel)this.getModel()).isN4jsAnnotated()) {
            ((N4JSClassifierWizardModel)this.getModel()).setN4jsAnnotated(false);
        }
        if ((((N4JSClassifierWizardModel)this.getModel()).getAccessModifier() == AccessModifier.PRIVATE || ((N4JSClassifierWizardModel)this.getModel()).getAccessModifier() == AccessModifier.PROJECT) && ((N4JSClassifierWizardModel)this.getModel()).isInternal()) {
            ((N4JSClassifierWizardModel)this.getModel()).setInternal(false);
        }
        if (((N4JSClassifierWizardModel)this.getModel()).getAccessModifier() == AccessModifier.PRIVATE) {
            ((N4JSClassifierWizardModel)this.getModel()).setN4jsAnnotated(false);
        }
        ArrayList<ClassifierReference> interfaces = new ArrayList<ClassifierReference>(((N4JSClassifierWizardModel)this.getModel()).getInterfaces());
        HashSet duplicateFullSpecifiers = Sets.newHashSet();
        Iterator<ClassifierReference> itr = interfaces.iterator();
        while (itr.hasNext()) {
            ClassifierReference next = itr.next();
            if (!duplicateFullSpecifiers.add(next.getFullSpecifier())) {
                itr.remove();
            }
            if (!next.classifierName.isEmpty()) continue;
            itr.remove();
        }
        ((N4JSClassifierWizardModel)this.getModel()).setInterfaces(interfaces);
    }

    @Override
    protected void run() throws WorkspaceWizardModelValidator.ValidationException {
        super.run();
        this.validateClassifierName();
        this.validateFileLocation();
        this.validateInterfaces();
    }

    private void validateFileLocation() throws WorkspaceWizardModelValidator.ValidationException {
        IPath path = ((N4JSClassifierWizardModel)this.getModel()).computeFileLocation();
        IWorkspaceRoot activeContainer = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < path.segmentCount()) {
            String segment = path.segment(i);
            IResource member = activeContainer.findMember(segment);
            if (member == null && i < path.segmentCount() - 1) break;
            if (member instanceof IFile && i < path.segmentCount() - 1) {
                throw new WorkspaceWizardModelValidator.ValidationException(String.format("The specified file location overlaps with the file %s", member.getFullPath()));
            }
            if (member instanceof IContainer) {
                activeContainer = (IContainer)member;
            }
            ++i;
        }
    }

    private boolean isValidReferenceOfType(String absoluteSpecifier, EClass type) {
        if (this.descriptions == null) {
            ResourceSet set = this.n4jsCore.createResourceSet(Optional.fromNullable(null));
            this.descriptions = this.n4jsCore.getXtextIndex(set);
        }
        QualifiedName name = this.qualifiedNameConverter.toQualifiedName(absoluteSpecifier);
        Iterable foundObjects = this.descriptions.getExportedObjects(type, name, false);
        return foundObjects.iterator().hasNext();
    }

    protected boolean isValidClass(ClassifierReference ref) {
        return this.isValidReferenceOfType(ref.getFullSpecifier(), TypesPackage.eINSTANCE.getTClass());
    }

    protected boolean isValidInterface(ClassifierReference ref) {
        return this.isValidReferenceOfType(ref.getFullSpecifier(), TypesPackage.eINSTANCE.getTInterface());
    }

    protected boolean isFileSpecifyingModuleSpecifier(String specifier) {
        return specifier.length() > 0 && specifier.charAt(specifier.length() - 1) != '/';
    }

    protected IEObjectDescription getClassifierObjectDescriptionForFQN(String fqn) {
        QualifiedName name = this.qualifiedNameConverter.toQualifiedName(fqn);
        Iterable foundObjects = this.descriptions.getExportedObjects(TypesPackage.eINSTANCE.getTClassifier(), name, false);
        return (IEObjectDescription)Iterables.getFirst((Iterable)foundObjects, null);
    }

    public static class ErrorMessages {
        private static final String CLASSIFIER_NAME_MUST_NOT_BE_EMPTY = "The %s name field must not be empty.";
        private static final String INVALID_CLASSIFIER_NAME = "Invalid %s name.";
        private static final String RESERVED_CLASSIFIER_NAME = "The %s name '%s' is a reserved N4JS identifier.";
        private static final String THE_INTERFACE_CANNOT_BE_FOUND = "The interface %s cannot be found.";
        private static final String THE_NEW_SOURCE_MODULE_COLLIDES_WITH_THE_DEFINITION_FILE = "The new source module collides with the definition file: %s";
        private static final String THE_NEW_DEFINITION_MODULE_COLLIDES_WITH_THE_SOURCE_FILE = "The new definition module collides with the source file: %s";
        private static final String FILE_LOCATION_OVERLAPS = "The specified file location overlaps with the file %s";
    }
}

