/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets;

import com.google.common.base.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.n4js.ui.workingsets.ProjectNameFilterAwareWorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetEditWizard;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WorkingSetProjectNameFilterWizard
extends WorkingSetEditWizard {
    private static final String TITLE = "Project Name Filter Working Set";
    private static final String DESCRIPTION = "Enter a working set name and specify a project name filter using a regular expression.";
    private final AtomicReference<WorkingSet> workingSetRef = new AtomicReference();
    private final AtomicReference<String> originalName = new AtomicReference();

    public void addPages() {
        this.addPage((IWizardPage)new WizardPage(""){
            private Text nameText;
            private Text filterText;

            public void createControl(Composite parent) {
                Composite composite = new Composite(parent, 0);
                composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).create());
                composite.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).grab(true, true).create());
                new Label(composite, 0).setText("Working set name:");
                this.nameText = new Text(composite, 2048);
                this.nameText.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
                new Label(composite, 0).setText("Project name filter:");
                this.filterText = new Text(composite, 2048);
                this.filterText.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
                this.setPageComplete(false);
                this.setControl((Control)composite);
                composite.getDisplay().asyncExec(() -> {
                    this.setTitle(WorkingSetProjectNameFilterWizard.TITLE);
                    this.setDescription(WorkingSetProjectNameFilterWizard.DESCRIPTION);
                });
                Optional<WorkingSet> editedWorkingSet = WorkingSetProjectNameFilterWizard.this.getEditedWorkingSet();
                if (editedWorkingSet.isPresent()) {
                    ProjectNameFilterAwareWorkingSetManager.ProjectNameFilterWorkingSet workingSet = (ProjectNameFilterAwareWorkingSetManager.ProjectNameFilterWorkingSet)editedWorkingSet.get();
                    WorkingSetProjectNameFilterWizard.this.workingSetRef.set(workingSet);
                    this.nameText.setText(workingSet.getName());
                    this.filterText.setText(workingSet.getFilter().pattern());
                    this.nameText.selectAll();
                    WorkingSetProjectNameFilterWizard.this.originalName.set(workingSet.getName());
                }
                this.nameText.addModifyListener(e -> this.setPageComplete(this.validatePage()));
                this.filterText.addModifyListener(e -> this.setPageComplete(this.validatePage()));
            }

            private boolean validatePage() {
                String errorMessage = null;
                String name = this.nameText.getText();
                String filter = this.filterText.getText();
                WorkingSetManager manager = WorkingSetProjectNameFilterWizard.this.getManager();
                if (manager == null) {
                    errorMessage = "No active working set manager is available.";
                }
                if (errorMessage == null && (name == null || name.trim().length() == 0)) {
                    errorMessage = "Working set name should be specified.";
                }
                if (errorMessage == null && !name.equals(WorkingSetProjectNameFilterWizard.this.originalName.get()) && WorkingSetProjectNameFilterWizard.this.getAllWorkingSets().stream().anyMatch(ws -> ws.getName().equals(name))) {
                    errorMessage = "A working set already exists with name '" + name + "'.";
                }
                if (errorMessage == null && (filter == null || filter.trim().length() == 0)) {
                    errorMessage = "Project name filter should be specified.";
                }
                Pattern pattern = null;
                if (errorMessage == null) {
                    try {
                        pattern = Pattern.compile(filter);
                    }
                    catch (PatternSyntaxException e) {
                        errorMessage = "Invalid project name filter. " + e.getDescription() + ".";
                    }
                }
                if (errorMessage != null || pattern == null) {
                    WorkingSetProjectNameFilterWizard.this.workingSetRef.set(null);
                } else {
                    WorkingSetProjectNameFilterWizard.this.workingSetRef.set(new ProjectNameFilterAwareWorkingSetManager.ProjectNameFilterWorkingSet(pattern, name, manager));
                }
                this.setMessage(errorMessage, 3);
                return errorMessage == null;
            }
        });
    }

    @Override
    public Optional<WorkingSet> getWorkingSet() {
        return Optional.fromNullable((Object)this.workingSetRef.get());
    }

    public boolean performFinish() {
        return this.getWorkingSet() != null;
    }
}

