/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.MutableBits;

class ReadersAndUpdates {
    public final SegmentCommitInfo info;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final IndexWriter writer;
    private SegmentReader reader;
    private Bits liveDocs;
    private int pendingDeleteCount;
    private boolean liveDocsShared;
    private boolean isMerging = false;
    private final Map<String, List<DocValuesFieldUpdates>> pendingDVUpdates = new HashMap<String, List<DocValuesFieldUpdates>>();
    private final Map<String, List<DocValuesFieldUpdates>> mergingDVUpdates = new HashMap<String, List<DocValuesFieldUpdates>>();
    Sorter.DocMap sortMap;
    public final AtomicLong ramBytesUsed = new AtomicLong();

    public ReadersAndUpdates(IndexWriter writer, SegmentCommitInfo info) {
        this.writer = writer;
        this.info = info;
        this.liveDocsShared = true;
    }

    public ReadersAndUpdates(IndexWriter writer, SegmentReader reader) {
        this.writer = writer;
        this.reader = reader;
        this.info = reader.getSegmentInfo();
        this.liveDocs = reader.getLiveDocs();
        this.liveDocsShared = true;
        this.pendingDeleteCount = reader.numDeletedDocs() - this.info.getDelCount();
        assert (this.pendingDeleteCount >= 0) : "got " + this.pendingDeleteCount + " reader.numDeletedDocs()=" + reader.numDeletedDocs() + " info.getDelCount()=" + this.info.getDelCount() + " maxDoc=" + reader.maxDoc() + " numDocs=" + reader.numDocs();
    }

    public void incRef() {
        int rc = this.refCount.incrementAndGet();
        assert (rc > 1) : "seg=" + this.info;
    }

    public void decRef() {
        int rc = this.refCount.decrementAndGet();
        assert (rc >= 0) : "seg=" + this.info;
    }

    public int refCount() {
        int rc = this.refCount.get();
        assert (rc >= 0);
        return rc;
    }

    public synchronized int getPendingDeleteCount() {
        return this.pendingDeleteCount;
    }

    private synchronized boolean assertNoDupGen(List<DocValuesFieldUpdates> fieldUpdates, DocValuesFieldUpdates update) {
        for (int i = 0; i < fieldUpdates.size(); ++i) {
            DocValuesFieldUpdates oldUpdate = fieldUpdates.get(i);
            if (oldUpdate.delGen == update.delGen) {
                throw new AssertionError((Object)("duplicate delGen=" + update.delGen + " for seg=" + this.info));
            }
        }
        return true;
    }

    public synchronized void addDVUpdate(DocValuesFieldUpdates update) {
        if (!update.getFinished()) {
            throw new IllegalArgumentException("call finish first");
        }
        List<DocValuesFieldUpdates> fieldUpdates = this.pendingDVUpdates.get(update.field);
        if (fieldUpdates == null) {
            fieldUpdates = new ArrayList<DocValuesFieldUpdates>();
            this.pendingDVUpdates.put(update.field, fieldUpdates);
        }
        assert (this.assertNoDupGen(fieldUpdates, update));
        this.ramBytesUsed.addAndGet(update.ramBytesUsed());
        fieldUpdates.add(update);
        if (this.isMerging) {
            fieldUpdates = this.mergingDVUpdates.get(update.field);
            if (fieldUpdates == null) {
                fieldUpdates = new ArrayList<DocValuesFieldUpdates>();
                this.mergingDVUpdates.put(update.field, fieldUpdates);
            }
            fieldUpdates.add(update);
        }
    }

    public synchronized long getNumDVUpdates() {
        long count = 0L;
        for (List<DocValuesFieldUpdates> updates : this.pendingDVUpdates.values()) {
            count += (long)updates.size();
        }
        return count;
    }

    public synchronized boolean verifyDocCounts() {
        int count;
        if (this.liveDocs != null) {
            count = 0;
            for (int docID = 0; docID < this.info.info.maxDoc(); ++docID) {
                if (!this.liveDocs.get(docID)) continue;
                ++count;
            }
        } else {
            count = this.info.info.maxDoc();
        }
        assert (this.info.info.maxDoc() - this.info.getDelCount() - this.pendingDeleteCount == count) : "info.maxDoc=" + this.info.info.maxDoc() + " info.getDelCount()=" + this.info.getDelCount() + " pendingDeleteCount=" + this.pendingDeleteCount + " count=" + count;
        return true;
    }

    public synchronized SegmentReader getReader(IOContext context) throws IOException {
        if (this.reader == null) {
            this.reader = new SegmentReader(this.info, this.writer.segmentInfos.getIndexCreatedVersionMajor(), context);
            if (this.liveDocs == null) {
                this.liveDocs = this.reader.getLiveDocs();
            }
        }
        this.reader.incRef();
        return this.reader;
    }

    public synchronized void release(SegmentReader sr) throws IOException {
        assert (this.info == sr.getSegmentInfo());
        sr.decRef();
    }

    public synchronized boolean delete(int docID) throws IOException {
        this.initWritableLiveDocs();
        assert (this.liveDocs != null);
        assert (docID >= 0 && docID < this.liveDocs.length()) : "out of bounds: docid=" + docID + " liveDocsLength=" + this.liveDocs.length() + " seg=" + this.info.info.name + " maxDoc=" + this.info.info.maxDoc();
        assert (!this.liveDocsShared);
        boolean didDelete = this.liveDocs.get(docID);
        if (didDelete) {
            ((MutableBits)this.liveDocs).clear(docID);
            ++this.pendingDeleteCount;
        }
        return didDelete;
    }

    public synchronized void dropReaders() throws IOException {
        if (this.reader != null) {
            try {
                this.reader.decRef();
            }
            finally {
                this.reader = null;
            }
        }
        this.decRef();
    }

    public synchronized SegmentReader getReadOnlyClone(IOContext context) throws IOException {
        if (this.reader == null) {
            this.getReader(context).decRef();
            assert (this.reader != null);
        }
        this.liveDocsShared = true;
        if (this.liveDocs != null) {
            return new SegmentReader(this.reader.getSegmentInfo(), this.reader, this.liveDocs, this.info.info.maxDoc() - this.info.getDelCount() - this.pendingDeleteCount);
        }
        assert (this.reader.getLiveDocs() == null);
        this.reader.incRef();
        return this.reader;
    }

    private synchronized void initWritableLiveDocs() throws IOException {
        assert (this.info.info.maxDoc() > 0);
        if (this.liveDocsShared) {
            LiveDocsFormat liveDocsFormat = this.info.info.getCodec().liveDocsFormat();
            this.liveDocs = this.liveDocs == null ? liveDocsFormat.newLiveDocs(this.info.info.maxDoc()) : liveDocsFormat.newLiveDocs(this.liveDocs);
            this.liveDocsShared = false;
        }
    }

    public synchronized Bits getLiveDocs() {
        return this.liveDocs;
    }

    public synchronized Bits getReadOnlyLiveDocs() {
        this.liveDocsShared = true;
        return this.liveDocs;
    }

    public synchronized void dropChanges() {
        assert (Thread.holdsLock(this.writer));
        this.pendingDeleteCount = 0;
        this.dropMergingUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean writeLiveDocs(Directory dir) throws IOException {
        block7: {
            if (this.pendingDeleteCount == 0) {
                return false;
            }
            assert (this.liveDocs.length() == this.info.info.maxDoc());
            TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(dir);
            boolean success = false;
            try {
                Codec codec = this.info.info.getCodec();
                codec.liveDocsFormat().writeLiveDocs((MutableBits)this.liveDocs, trackingDir, this.info, this.pendingDeleteCount, IOContext.DEFAULT);
                success = true;
                if (success) break block7;
                this.info.advanceNextWriteDelGen();
            }
            catch (Throwable throwable) {
                if (!success) {
                    this.info.advanceNextWriteDelGen();
                    for (String fileName : trackingDir.getCreatedFiles()) {
                        IOUtils.deleteFilesIgnoringExceptions(dir, fileName);
                    }
                }
                throw throwable;
            }
            for (String fileName : trackingDir.getCreatedFiles()) {
                IOUtils.deleteFilesIgnoringExceptions(dir, fileName);
            }
        }
        this.info.advanceDelGen();
        this.info.setDelCount(this.info.getDelCount() + this.pendingDeleteCount);
        this.pendingDeleteCount = 0;
        return true;
    }

    private synchronized void handleNumericDVUpdates(FieldInfos infos, Directory dir, DocValuesFormat dvFormat, final SegmentReader reader, Map<Integer, Set<String>> fieldFiles, long maxDelGen, InfoStream infoStream) throws IOException {
        for (Map.Entry<String, List<DocValuesFieldUpdates>> ent : this.pendingDVUpdates.entrySet()) {
            final String field = ent.getKey();
            List<DocValuesFieldUpdates> updates = ent.getValue();
            if (updates.get((int)0).type != DocValuesType.NUMERIC) continue;
            final ArrayList<DocValuesFieldUpdates> updatesToApply = new ArrayList<DocValuesFieldUpdates>();
            long bytes = 0L;
            for (DocValuesFieldUpdates update : updates) {
                if (update.delGen > maxDelGen) continue;
                bytes += update.ramBytesUsed();
                updatesToApply.add(update);
            }
            if (updatesToApply.isEmpty()) continue;
            if (infoStream.isEnabled("BD")) {
                infoStream.message("BD", String.format(Locale.ROOT, "now write %d pending numeric DV updates for field=%s, seg=%s, bytes=%.3f MB", updatesToApply.size(), field, this.info, (double)bytes / 1024.0 / 1024.0));
            }
            long nextDocValuesGen = this.info.getNextDocValuesGen();
            String segmentSuffix = Long.toString(nextDocValuesGen, 36);
            IOContext updatesContext = new IOContext(new FlushInfo(this.info.info.maxDoc(), bytes));
            final FieldInfo fieldInfo = infos.fieldInfo(field);
            assert (fieldInfo != null);
            fieldInfo.setDocValuesGen(nextDocValuesGen);
            FieldInfos fieldInfos = new FieldInfos(new FieldInfo[]{fieldInfo});
            TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(dir);
            SegmentWriteState state = new SegmentWriteState(null, trackingDir, this.info.info, fieldInfos, null, updatesContext, segmentSuffix);
            try (DocValuesConsumer fieldsConsumer = dvFormat.fieldsConsumer(state);){
                fieldsConsumer.addNumericField(fieldInfo, new EmptyDocValuesProducer(){

                    @Override
                    public NumericDocValues getNumeric(FieldInfo fieldInfoIn) throws IOException {
                        if (fieldInfoIn != fieldInfo) {
                            throw new IllegalArgumentException("wrong fieldInfo");
                        }
                        int maxDoc = reader.maxDoc();
                        DocValuesFieldUpdates.Iterator[] subs = new DocValuesFieldUpdates.Iterator[updatesToApply.size()];
                        for (int i = 0; i < subs.length; ++i) {
                            subs[i] = ((DocValuesFieldUpdates)updatesToApply.get(i)).iterator();
                        }
                        final DocValuesFieldUpdates.Iterator updatesIter = DocValuesFieldUpdates.mergedIterator(subs);
                        final NumericDocValues currentValues = reader.getNumericDocValues(field);
                        return new NumericDocValues(){
                            private int docIDOut = -1;
                            private int docIDIn = -1;
                            private int updateDocID = -1;
                            private long value;

                            @Override
                            public int docID() {
                                return this.docIDOut;
                            }

                            @Override
                            public int advance(int target) {
                                throw new UnsupportedOperationException();
                            }

                            @Override
                            public boolean advanceExact(int target) throws IOException {
                                throw new UnsupportedOperationException();
                            }

                            @Override
                            public long cost() {
                                return 0L;
                            }

                            @Override
                            public long longValue() {
                                return this.value;
                            }

                            @Override
                            public int nextDoc() throws IOException {
                                if (this.docIDIn == this.docIDOut) {
                                    this.docIDIn = currentValues == null ? Integer.MAX_VALUE : currentValues.nextDoc();
                                }
                                if (this.updateDocID == this.docIDOut) {
                                    this.updateDocID = updatesIter.nextDoc();
                                }
                                if (this.docIDIn < this.updateDocID) {
                                    this.docIDOut = this.docIDIn;
                                    this.value = currentValues.longValue();
                                } else {
                                    this.docIDOut = this.updateDocID;
                                    if (this.docIDOut != Integer.MAX_VALUE) {
                                        this.value = (Long)updatesIter.value();
                                    }
                                }
                                return this.docIDOut;
                            }
                        };
                    }
                });
            }
            this.info.advanceDocValuesGen();
            assert (!fieldFiles.containsKey(fieldInfo.number));
            fieldFiles.put(fieldInfo.number, trackingDir.getCreatedFiles());
        }
    }

    private synchronized void handleBinaryDVUpdates(FieldInfos infos, TrackingDirectoryWrapper dir, DocValuesFormat dvFormat, final SegmentReader reader, Map<Integer, Set<String>> fieldFiles, long maxDelGen, InfoStream infoStream) throws IOException {
        for (Map.Entry<String, List<DocValuesFieldUpdates>> ent : this.pendingDVUpdates.entrySet()) {
            final String field = ent.getKey();
            List<DocValuesFieldUpdates> updates = ent.getValue();
            if (updates.get((int)0).type != DocValuesType.BINARY) continue;
            final ArrayList<DocValuesFieldUpdates> updatesToApply = new ArrayList<DocValuesFieldUpdates>();
            long bytes = 0L;
            for (DocValuesFieldUpdates update : updates) {
                if (update.delGen > maxDelGen) continue;
                bytes += update.ramBytesUsed();
                updatesToApply.add(update);
            }
            if (updatesToApply.isEmpty()) continue;
            if (infoStream.isEnabled("BD")) {
                infoStream.message("BD", String.format(Locale.ROOT, "now write %d pending binary DV updates for field=%s, seg=%s, bytes=%.3fMB", updatesToApply.size(), field, this.info, (double)bytes / 1024.0 / 1024.0));
            }
            long nextDocValuesGen = this.info.getNextDocValuesGen();
            String segmentSuffix = Long.toString(nextDocValuesGen, 36);
            IOContext updatesContext = new IOContext(new FlushInfo(this.info.info.maxDoc(), bytes));
            final FieldInfo fieldInfo = infos.fieldInfo(field);
            assert (fieldInfo != null);
            fieldInfo.setDocValuesGen(nextDocValuesGen);
            FieldInfos fieldInfos = new FieldInfos(new FieldInfo[]{fieldInfo});
            TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(dir);
            SegmentWriteState state = new SegmentWriteState(null, trackingDir, this.info.info, fieldInfos, null, updatesContext, segmentSuffix);
            try (DocValuesConsumer fieldsConsumer = dvFormat.fieldsConsumer(state);){
                fieldsConsumer.addBinaryField(fieldInfo, new EmptyDocValuesProducer(){

                    @Override
                    public BinaryDocValues getBinary(FieldInfo fieldInfoIn) throws IOException {
                        if (fieldInfoIn != fieldInfo) {
                            throw new IllegalArgumentException("wrong fieldInfo");
                        }
                        int maxDoc = reader.maxDoc();
                        DocValuesFieldUpdates.Iterator[] subs = new DocValuesFieldUpdates.Iterator[updatesToApply.size()];
                        for (int i = 0; i < subs.length; ++i) {
                            subs[i] = ((DocValuesFieldUpdates)updatesToApply.get(i)).iterator();
                        }
                        final DocValuesFieldUpdates.Iterator updatesIter = DocValuesFieldUpdates.mergedIterator(subs);
                        final BinaryDocValues currentValues = reader.getBinaryDocValues(field);
                        return new BinaryDocValues(){
                            private int docIDOut = -1;
                            private int docIDIn = -1;
                            private int updateDocID = -1;
                            private BytesRef value;

                            @Override
                            public int docID() {
                                return this.docIDOut;
                            }

                            @Override
                            public int advance(int target) {
                                throw new UnsupportedOperationException();
                            }

                            @Override
                            public boolean advanceExact(int target) throws IOException {
                                throw new UnsupportedOperationException();
                            }

                            @Override
                            public long cost() {
                                return currentValues.cost();
                            }

                            @Override
                            public BytesRef binaryValue() {
                                return this.value;
                            }

                            @Override
                            public int nextDoc() throws IOException {
                                if (this.docIDIn == this.docIDOut) {
                                    this.docIDIn = currentValues == null ? Integer.MAX_VALUE : currentValues.nextDoc();
                                }
                                if (this.updateDocID == this.docIDOut) {
                                    this.updateDocID = updatesIter.nextDoc();
                                }
                                if (this.docIDIn < this.updateDocID) {
                                    this.docIDOut = this.docIDIn;
                                    this.value = currentValues.binaryValue();
                                } else {
                                    this.docIDOut = this.updateDocID;
                                    if (this.docIDOut != Integer.MAX_VALUE) {
                                        this.value = (BytesRef)updatesIter.value();
                                    }
                                }
                                return this.docIDOut;
                            }
                        };
                    }
                });
            }
            this.info.advanceDocValuesGen();
            assert (!fieldFiles.containsKey(fieldInfo.number));
            fieldFiles.put(fieldInfo.number, trackingDir.getCreatedFiles());
        }
    }

    private synchronized Set<String> writeFieldInfosGen(FieldInfos fieldInfos, Directory dir, DocValuesFormat dvFormat, FieldInfosFormat infosFormat) throws IOException {
        long nextFieldInfosGen = this.info.getNextFieldInfosGen();
        String segmentSuffix = Long.toString(nextFieldInfosGen, 36);
        long estInfosSize = 40 + 90 * fieldInfos.size();
        IOContext infosContext = new IOContext(new FlushInfo(this.info.info.maxDoc(), estInfosSize));
        TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(dir);
        infosFormat.write(trackingDir, this.info.info, segmentSuffix, fieldInfos, infosContext);
        this.info.advanceFieldInfosGen();
        return trackingDir.getCreatedFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean writeFieldUpdates(Directory dir, long maxDelGen, InfoStream infoStream) throws IOException {
        Set<String> fieldInfosFiles;
        HashMap<Integer, Set<String>> newDVFiles;
        long startTimeNS;
        block31: {
            startTimeNS = System.nanoTime();
            assert (Thread.holdsLock(this.writer));
            newDVFiles = new HashMap<Integer, Set<String>>();
            fieldInfosFiles = null;
            FieldInfos fieldInfos = null;
            boolean any = false;
            int count = 0;
            block8: for (List<DocValuesFieldUpdates> updates : this.pendingDVUpdates.values()) {
                Collections.sort(updates, (a, b) -> Long.compare(a.delGen, b.delGen));
                count += updates.size();
                for (DocValuesFieldUpdates update : updates) {
                    if (update.delGen > maxDelGen || !update.any()) continue;
                    any = true;
                    continue block8;
                }
            }
            if (!any) {
                return false;
            }
            TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(dir);
            boolean success = false;
            try {
                Codec codec = this.info.info.getCodec();
                SegmentReader reader = this.reader == null ? new SegmentReader(this.info, this.writer.segmentInfos.getIndexCreatedVersionMajor(), IOContext.READONCE) : this.reader;
                try {
                    FieldInfos.Builder builder = new FieldInfos.Builder(this.writer.globalFieldNumberMap);
                    for (FieldInfo fieldInfo : reader.getFieldInfos()) {
                        FieldInfo clone = builder.add(fieldInfo);
                        for (Map.Entry<String, String> e : fieldInfo.attributes().entrySet()) {
                            clone.putAttribute(e.getKey(), e.getValue());
                        }
                        clone.setDocValuesGen(fieldInfo.getDocValuesGen());
                    }
                    for (List list : this.pendingDVUpdates.values()) {
                        DocValuesFieldUpdates update = (DocValuesFieldUpdates)list.get(0);
                        FieldInfo fieldInfo = builder.getOrAdd(update.field);
                        fieldInfo.setDocValuesType(update.type);
                    }
                    fieldInfos = builder.finish();
                    DocValuesFormat docValuesFormat = codec.docValuesFormat();
                    this.handleNumericDVUpdates(fieldInfos, trackingDir, docValuesFormat, reader, newDVFiles, maxDelGen, infoStream);
                    this.handleBinaryDVUpdates(fieldInfos, trackingDir, docValuesFormat, reader, newDVFiles, maxDelGen, infoStream);
                    fieldInfosFiles = this.writeFieldInfosGen(fieldInfos, trackingDir, docValuesFormat, codec.fieldInfosFormat());
                }
                finally {
                    if (reader != this.reader) {
                        reader.close();
                    }
                }
                success = true;
                if (success) break block31;
                this.info.advanceNextWriteFieldInfosGen();
                this.info.advanceNextWriteDocValuesGen();
            }
            catch (Throwable throwable) {
                if (!success) {
                    this.info.advanceNextWriteFieldInfosGen();
                    this.info.advanceNextWriteDocValuesGen();
                    for (String fileName : trackingDir.getCreatedFiles()) {
                        IOUtils.deleteFilesIgnoringExceptions(dir, fileName);
                    }
                }
                throw throwable;
            }
            for (String fileName : trackingDir.getCreatedFiles()) {
                IOUtils.deleteFilesIgnoringExceptions(dir, fileName);
            }
        }
        long bytesFreed = 0L;
        Iterator<Map.Entry<String, List<DocValuesFieldUpdates>>> it = this.pendingDVUpdates.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, List<DocValuesFieldUpdates>> ent = it.next();
            int n = 0;
            List<DocValuesFieldUpdates> updates = ent.getValue();
            for (DocValuesFieldUpdates update : updates) {
                if (update.delGen > maxDelGen) {
                    updates.set(n, update);
                    ++n;
                    continue;
                }
                bytesFreed += update.ramBytesUsed();
            }
            if (n == 0) {
                it.remove();
                continue;
            }
            updates.subList(n, updates.size()).clear();
        }
        long bytes = this.ramBytesUsed.addAndGet(-bytesFreed);
        assert (bytes >= 0L);
        if (this.reader != null) {
            SegmentReader newReader = new SegmentReader(this.info, this.reader, this.liveDocs, this.info.info.maxDoc() - this.info.getDelCount() - this.pendingDeleteCount);
            boolean success2 = false;
            try {
                this.reader.decRef();
                this.reader = newReader;
                success2 = true;
            }
            finally {
                if (!success2) {
                    newReader.decRef();
                }
            }
        }
        assert (fieldInfosFiles != null);
        this.info.setFieldInfosFiles(fieldInfosFiles);
        assert (!newDVFiles.isEmpty());
        for (Map.Entry<Integer, Set<String>> e : this.info.getDocValuesUpdatesFiles().entrySet()) {
            if (newDVFiles.containsKey(e.getKey())) continue;
            newDVFiles.put(e.getKey(), e.getValue());
        }
        this.info.setDocValuesUpdatesFiles(newDVFiles);
        this.writer.checkpointNoSIS();
        if (infoStream.isEnabled("BD")) {
            infoStream.message("BD", String.format(Locale.ROOT, "done write field updates for seg=%s; took %.3fs; new files: %s", this.info, (double)(System.nanoTime() - startTimeNS) / 1.0E9, newDVFiles));
        }
        return true;
    }

    public synchronized void setIsMerging() {
        if (!this.isMerging) {
            this.isMerging = true;
            assert (this.mergingDVUpdates.isEmpty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized SegmentReader getReaderForMerge(IOContext context) throws IOException {
        for (Map.Entry<String, List<DocValuesFieldUpdates>> ent : this.pendingDVUpdates.entrySet()) {
            List<DocValuesFieldUpdates> mergingUpdates = this.mergingDVUpdates.get(ent.getKey());
            if (mergingUpdates == null) {
                mergingUpdates = new ArrayList<DocValuesFieldUpdates>();
                this.mergingDVUpdates.put(ent.getKey(), mergingUpdates);
            }
            mergingUpdates.addAll((Collection<DocValuesFieldUpdates>)ent.getValue());
        }
        SegmentReader reader = this.getReader(context);
        int delCount = this.pendingDeleteCount + this.info.getDelCount();
        if (delCount != reader.numDeletedDocs()) {
            assert (delCount > reader.numDeletedDocs()) : "delCount=" + delCount + " reader.numDeletedDocs()=" + reader.numDeletedDocs();
            assert (this.liveDocs != null);
            SegmentReader newReader = new SegmentReader(this.info, reader, this.liveDocs, this.info.info.maxDoc() - delCount);
            boolean success = false;
            try {
                reader.decRef();
                success = true;
            }
            finally {
                if (!success) {
                    newReader.decRef();
                }
            }
            reader = newReader;
        }
        this.liveDocsShared = true;
        assert (this.verifyDocCounts());
        return reader;
    }

    public synchronized void dropMergingUpdates() {
        this.mergingDVUpdates.clear();
        this.isMerging = false;
    }

    public synchronized Map<String, List<DocValuesFieldUpdates>> getMergingDVUpdates() {
        this.isMerging = false;
        return this.mergingDVUpdates;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReadersAndLiveDocs(seg=").append(this.info);
        sb.append(" pendingDeleteCount=").append(this.pendingDeleteCount);
        sb.append(" liveDocsShared=").append(this.liveDocsShared);
        return sb.toString();
    }
}

