/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.hlc.base.running;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.eclipse.n4js.generator.headless.logging.IHeadlessLogger;
import org.eclipse.n4js.runner.extension.IRunnableDescriptor;

@Singleton
public class RunnableLookupHelper {
    @Inject
    private IHeadlessLogger logger;

    public <T extends IRunnableDescriptor> List<T> findRunnableById(String runnableID, Map<String, T> descriptors) {
        if (runnableID == null || runnableID.trim().isEmpty()) {
            this.logger.warn("Expecting non null, non empty, non whitespace runnable ID. Was <" + runnableID + ">.");
            return Collections.emptyList();
        }
        IRunnableDescriptor rd = (IRunnableDescriptor)descriptors.get(runnableID);
        if (rd != null) {
            if (runnableID != rd.getId()) {
                this.logger.warn("Inconsistent mapping of the runnable. ID used as key in the map <" + runnableID + ">, id in the runnable <" + rd.getId() + ">");
            }
            return Collections.singletonList(rd);
        }
        this.logger.info("Could not find runnable by ID: " + runnableID + ", switching to fuzzy search.");
        String lowerRunner = runnableID.toLowerCase();
        List matchingRDs = descriptors.values().stream().filter(descriptor -> {
            String lowerID = descriptor.getId().toLowerCase();
            return lowerID.equals(runnableID) || lowerID.endsWith("." + lowerRunner);
        }).collect(Collectors.toList());
        return matchingRDs;
    }
}

