/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner.ui;

import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.runner.RunConfiguration;
import org.eclipse.n4js.runner.RunnerFrontEnd;
import org.eclipse.n4js.runner.ui.ChooseImplementationHelper;
import org.eclipse.n4js.runner.ui.RunConfigurationConverter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public abstract class AbstractRunnerLaunchShortcut
implements ILaunchShortcut {
    @Inject
    protected IN4JSCore in4jsCore;
    @Inject
    private RunConfigurationConverter runConfigConverter;
    @Inject
    private RunnerFrontEnd runnerFrontEnd;
    @Inject
    private ChooseImplementationHelper chooseImplHelper;

    protected abstract String getRunnerId();

    protected abstract String getLaunchConfigTypeID();

    private static void showDialogNotImplemented(String what) {
        MessageDialog.openWarning(null, (String)"Warning", (String)("Launching of type " + what + " is not implemented yet!"));
    }

    public void launch(ISelection selection, String mode) {
        Object selectObj = ((IStructuredSelection)selection).getFirstElement();
        if (selectObj instanceof IFile) {
            this.launchFile((IFile)selectObj, mode);
        } else {
            AbstractRunnerLaunchShortcut.showDialogNotImplemented(selection.getClass().getName());
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFile selectObj = ((IFileEditorInput)editorInput).getFile();
            this.launchFile(selectObj, mode);
        } else {
            AbstractRunnerLaunchShortcut.showDialogNotImplemented(editor.getClass().getName());
        }
    }

    public static String computeLaunchConfigNameFrom(IFile originalFileToRun, ILaunchConfigurationType type) {
        String configname = originalFileToRun.getFullPath().toString().replace('/', '-');
        if (configname.startsWith("-")) {
            configname = configname.substring(1);
        }
        configname = String.valueOf(configname) + " (" + type.getName() + ")";
        return configname;
    }

    protected void launchFile(IFile originalFileToRun, String mode) {
        String path;
        URI moduleToRun;
        String runnerId = this.getRunnerId();
        String implementationId = this.chooseImplHelper.chooseImplementationIfRequired(runnerId, moduleToRun = URI.createPlatformResourceURI((String)(path = originalFileToRun.getFullPath().toOSString()), (boolean)true));
        if (implementationId == ChooseImplementationHelper.CANCEL) {
            return;
        }
        RunConfiguration runConfig = this.runnerFrontEnd.createConfiguration(runnerId, implementationId, moduleToRun);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType(this.getLaunchConfigTypeID());
        DebugUITools.launch((ILaunchConfiguration)this.runConfigConverter.toLaunchConfiguration(type, runConfig), (String)mode);
    }
}

