/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.generator.headless;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.xtext.generator.OutputConfiguration;

public class WrappedOutputConfiguration
extends OutputConfiguration {
    private final OutputConfiguration delegate;
    private final String pathprefix;
    private final Set<WrappedSourceMapping> sourceMappings;
    private String redefinedOutputSetting = null;

    public WrappedOutputConfiguration(OutputConfiguration delegate, String pathprefix) {
        super(delegate.getName());
        this.delegate = delegate;
        this.pathprefix = WrappedOutputConfiguration.normalize(pathprefix);
        this.sourceMappings = Sets.newHashSet();
        for (OutputConfiguration.SourceMapping sm : delegate.getSourceMappings()) {
            this.sourceMappings.add(new WrappedSourceMapping(sm, this));
        }
    }

    static String normalize(String path) {
        if (path == null) {
            return "";
        }
        if (!path.endsWith("/")) {
            return String.valueOf(path) + "/";
        }
        return path;
    }

    public String getOutputDirectory() {
        String ret = this.pathprefix;
        ret = this.redefinedOutputSetting != null ? String.valueOf(ret) + this.redefinedOutputSetting : String.valueOf(ret) + this.delegate.getOutputDirectory();
        return ret;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.redefinedOutputSetting = outputDirectory;
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public void setDescription(String description) {
        throw new UnsupportedOperationException("Setting of values is not supported.");
    }

    public boolean isCleanUpDerivedResources() {
        return this.delegate.isCleanUpDerivedResources();
    }

    public void setCleanUpDerivedResources(boolean cleanUpDerivedResources) {
        throw new UnsupportedOperationException("Setting of values is not supported.");
    }

    public boolean isOverrideExistingResources() {
        return this.delegate.isOverrideExistingResources();
    }

    public void setOverrideExistingResources(boolean overrideExistingResources) {
        throw new UnsupportedOperationException("Setting of values is not supported.");
    }

    public boolean isSetDerivedProperty() {
        return this.delegate.isSetDerivedProperty();
    }

    public void setSetDerivedProperty(boolean setDerivedProperty) {
        throw new UnsupportedOperationException("Setting of values is not supported.");
    }

    public boolean isCreateOutputDirectory() {
        return this.delegate.isCreateOutputDirectory();
    }

    public void setCreateOutputDirectory(boolean createOutputDirectory) {
        throw new UnsupportedOperationException("Setting of values is not supported.");
    }

    public boolean isCanClearOutputDirectory() {
        return this.delegate.isCanClearOutputDirectory();
    }

    public void setCanClearOutputDirectory(boolean canClearOutputDirectory) {
        throw new UnsupportedOperationException("Setting of values is not supported.");
    }

    public boolean isInstallDslAsPrimarySource() {
        return this.delegate.isInstallDslAsPrimarySource();
    }

    public void setInstallDslAsPrimarySource(boolean installDslAsPrimarySource) {
        throw new UnsupportedOperationException("Setting of values is not supported.");
    }

    public boolean isHideSyntheticLocalVariables() {
        return this.delegate.isHideSyntheticLocalVariables();
    }

    public void setHideSyntheticLocalVariables(boolean hideSyntheticLocalVariables) {
        throw new UnsupportedOperationException("Setting of values is not supported.");
    }

    public Boolean isKeepLocalHistory() {
        return this.delegate.isKeepLocalHistory();
    }

    public void setKeepLocalHistory(Boolean keepLocalHistory) {
        throw new UnsupportedOperationException("Setting of values is not supported.");
    }

    public boolean isUseOutputPerSourceFolder() {
        return this.delegate.isUseOutputPerSourceFolder();
    }

    public void setUseOutputPerSourceFolder(boolean useOutputPerSourceFolder) {
        throw new UnsupportedOperationException("Setting of values is not supported.");
    }

    public Set<OutputConfiguration.SourceMapping> getSourceMappings() {
        return this.delegate.getSourceMappings();
    }

    public String getOutputDirectory(String sourceFolder) {
        return this.delegate.getOutputDirectory(sourceFolder);
    }

    public Set<String> getSourceFolders() {
        return this.delegate.getSourceFolders();
    }

    public Set<String> getOutputDirectories() {
        return this.delegate.getOutputDirectories();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static class WrappedSourceMapping
    extends OutputConfiguration.SourceMapping {
        final OutputConfiguration.SourceMapping delegate;
        final WrappedOutputConfiguration parent;

        WrappedSourceMapping(OutputConfiguration.SourceMapping delegate, WrappedOutputConfiguration parent) {
            super(delegate.getSourceFolder());
            this.parent = parent;
            this.delegate = delegate;
        }

        public String getOutputDirectory() {
            String ret = this.parent.pathprefix;
            this.delegate.getOutputDirectory();
            return ret;
        }

        public String getSourceFolder() {
            return this.delegate.getSourceFolder();
        }

        public void setOutputDirectory(String outputDirectory) {
            throw new UnsupportedOperationException("Setting of values is not supported.");
        }

        public boolean isIgnore() {
            return this.delegate.isIgnore();
        }

        public void setIgnore(boolean ignore) {
            throw new UnsupportedOperationException("Setting of values is not supported.");
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

