/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.utils;

import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.utils.SuperTypesList;
import org.eclipse.n4js.ts.utils.TypeCompareHelper;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class TypeHelper {
    @Inject
    @Extension
    private TypeCompareHelper _typeCompareHelper;

    public SuperTypesList<TypeRef> collectAllDeclaredSuperTypesTypeargsIgnored(TypeRef ref, boolean reflexive) {
        SuperTypesList<TypeRef> allDeclaredSuperTypes = SuperTypesList.newSuperTypesList(this._typeCompareHelper.getTypeRefComparator());
        allDeclaredSuperTypes.add(ref);
        this.collectAllDeclaredSuperTypesTypeargsIgnored(ref, allDeclaredSuperTypes);
        if (!reflexive) {
            allDeclaredSuperTypes.remove(ref);
        }
        return allDeclaredSuperTypes;
    }

    public SuperTypesList<TypeRef> collectAllDeclaredSuperTypesWithTypeargs(TypeRef ref, boolean reflexive) {
        SuperTypesList<TypeRef> allDeclaredSuperTypes = SuperTypesList.newSuperTypesList(this._typeCompareHelper.getTypeRefComparator());
        allDeclaredSuperTypes.add(ref);
        this.collectAllDeclaredSuperTypesTypeargsIgnored(ref, allDeclaredSuperTypes);
        if (!reflexive) {
            allDeclaredSuperTypes.remove(ref);
        }
        return allDeclaredSuperTypes;
    }

    public SuperTypesList<Type> collectAllDeclaredSuperTypes(Type type, boolean reflexive) {
        SuperTypesList<Type> allDeclaredSuperTypes = SuperTypesList.newSuperTypesList(this._typeCompareHelper.getTypeComparator());
        allDeclaredSuperTypes.add(type);
        this.collectAllDeclaredSuperTypes(type, allDeclaredSuperTypes);
        if (!reflexive) {
            allDeclaredSuperTypes.remove(type);
        }
        return allDeclaredSuperTypes;
    }

    public void collectAllDeclaredSuperTypesTypeargsIgnored(TypeRef ref, SuperTypesList<TypeRef> allDeclaredSuperTypes) {
        if (ref != null && ref.getDeclaredType() != null) {
            Iterable<? extends ParameterizedTypeRef> _declaredSuperTypes = TypeUtils.declaredSuperTypes(ref.getDeclaredType());
            for (ParameterizedTypeRef parameterizedTypeRef : _declaredSuperTypes) {
                boolean _add = allDeclaredSuperTypes.add((TypeRef)parameterizedTypeRef);
                if (!_add) continue;
                this.collectAllDeclaredSuperTypesTypeargsIgnored((TypeRef)parameterizedTypeRef, allDeclaredSuperTypes);
            }
        }
    }

    public void collectAllDeclaredSuperTypes(Type type, SuperTypesList<Type> allDeclaredSuperTypes) {
        if (type != null) {
            Functions.Function1 _function = it -> it.getDeclaredType();
            Iterable _map = IterableExtensions.map(TypeUtils.declaredSuperTypes(type), (Functions.Function1)_function);
            for (Type superType : _map) {
                boolean _add = allDeclaredSuperTypes.add(superType);
                if (!_add) continue;
                this.collectAllDeclaredSuperTypes(superType, allDeclaredSuperTypes);
            }
        }
    }

    public boolean removeTypeRef(Iterable<TypeRef> typeRefs, TypeRef toBeRemoved) {
        Iterator<TypeRef> iter = typeRefs.iterator();
        while (iter.hasNext()) {
            boolean _tripleEquals;
            int _compare = this._typeCompareHelper.compare((TypeArgument)toBeRemoved, (TypeArgument)iter.next());
            boolean bl = _tripleEquals = _compare == 0;
            if (!_tripleEquals) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    public void retainAllTypeRefs(Iterable<TypeRef> typeRefs, SuperTypesList<TypeRef> typesToBeRetained) {
        Iterator<TypeRef> iter = typeRefs.iterator();
        while (iter.hasNext()) {
            boolean _not;
            boolean _contains = typesToBeRetained.contains(iter.next());
            boolean bl = _not = !_contains;
            if (!_not) continue;
            iter.remove();
        }
    }

    public boolean containsByType(Iterable<TypeRef> typeRefs, TypeRef typeRef) {
        Functions.Function1 _function = it -> {
            int _compare = this._typeCompareHelper.compare((TypeArgument)typeRef, (TypeArgument)it);
            return _compare == 0;
        };
        return IterableExtensions.exists(typeRefs, (Functions.Function1)_function);
    }

    public int findTypeRefOrAssignmentCompatible(List<TypeRef> typeRefs, TypeRef typeRef) {
        PrimitiveType _xifexpression = null;
        Type _declaredType = typeRef.getDeclaredType();
        if (_declaredType instanceof PrimitiveType) {
            Type _declaredType_1 = typeRef.getDeclaredType();
            _xifexpression = ((PrimitiveType)_declaredType_1).getAssignmentCompatible();
        } else {
            _xifexpression = null;
        }
        PrimitiveType assignmentCompatible = _xifexpression;
        int i = 0;
        while (i < ((Object[])Conversions.unwrapArray(typeRefs, Object.class)).length) {
            Type type;
            boolean _equals;
            TypeRef t = typeRefs.get(i);
            int _compare = this._typeCompareHelper.compare((TypeArgument)typeRef, (TypeArgument)t);
            boolean bl = _equals = _compare == 0;
            if (_equals) {
                return i;
            }
            if (assignmentCompatible != null && (type = t.getDeclaredType()) instanceof PrimitiveType && (this._typeCompareHelper.getTypeComparator().compare((Type)assignmentCompatible, type) == 0 || this._typeCompareHelper.getTypeComparator().compare(typeRef.getDeclaredType(), (Type)((PrimitiveType)type).getAssignmentCompatible()) == 0)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

