/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.types.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.utils.RecursionGuard;

public class ExtendedClassesIterable
implements Iterable<TClass> {
    private final TClass root;

    public ExtendedClassesIterable(TClass root) {
        this.root = root;
    }

    @Override
    public Iterator<TClass> iterator() {
        return new ExtendedClassesIterator();
    }

    @Override
    public Spliterator<TClass> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 257);
    }

    public int getInheritanceDistance(TClassifier superClass) {
        if (this.root == superClass) {
            return 0;
        }
        int distance = 1;
        Iterator<TClass> iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() == superClass) {
                return distance;
            }
            ++distance;
        }
        return -1;
    }

    public class ExtendedClassesIterator
    implements Iterator<TClass> {
        private final RecursionGuard<TClass> guard = new RecursionGuard();
        private TClass next;

        ExtendedClassesIterator() {
            if (ExtendedClassesIterable.this.root != null) {
                this.guard.tryNext((Object)ExtendedClassesIterable.this.root);
                this.next = this.retrieveNext(ExtendedClassesIterable.this.root);
            }
        }

        private TClass retrieveNext(TClass currentClass) {
            TClass superClass;
            ParameterizedTypeRef superTypeRef = currentClass.getSuperClassRef();
            if (superTypeRef == null) {
                return null;
            }
            Type superType = superTypeRef.getDeclaredType();
            if (superType instanceof TClass && this.guard.tryNext((Object)(superClass = (TClass)superType))) {
                return superClass;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public TClass next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            TClass current = this.next;
            this.next = this.retrieveNext(current);
            return current;
        }
    }
}

