/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.preferences;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.n4js.generator.CompilerProperties;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.n4js.ui.preferences.ComponentDetailsFieldEditor;
import org.eclipse.n4js.utils.ComponentDescriptor;
import org.eclipse.n4js.utils.IComponentProperties;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.ui.editor.preferences.AbstractPreferencePage;
import org.eclipse.xtext.ui.editor.preferences.PreferenceStoreAccessImpl;
import org.eclipse.xtext.ui.editor.tasks.dialogfields.DialogField;
import org.eclipse.xtext.ui.editor.tasks.dialogfields.IDialogFieldListener;
import org.eclipse.xtext.ui.editor.tasks.dialogfields.LayoutUtil;
import org.eclipse.xtext.ui.editor.tasks.dialogfields.SelectionButtonDialogField;
import org.eclipse.xtext.ui.preferences.Messages;
import org.eclipse.xtext.ui.preferences.ProjectSelectionDialog;
import org.eclipse.xtext.ui.preferences.StatusInfo;
import org.eclipse.xtext.util.Triple;

public abstract class AbstractN4JSPreferencePage<DESCR_TYPE extends ComponentDescriptor>
extends AbstractPreferencePage
implements Comparator<Triple<String, String, DESCR_TYPE>> {
    protected IProject project;
    protected boolean projectSpecificChanged = false;
    private Composite parentComposite;
    private SelectionButtonDialogField useProjectSettings;
    protected ControlEnableState blockEnableState;
    private Control configurationBlockControl;
    private Link changeWorkspaceSettings;
    protected final IStatus blockStatus;
    protected Map<Object, Object> pageData;
    public static final String DATA_NO_LINK = "N4JSBuilderPreferencePage.nolink";
    public static final String IS_PROJECT_SPECIFIC = "is_project_specific";
    private Map<String, String> disabledProjectSettings;
    private ComponentDetailsFieldEditor field = null;
    private Map<String, MapDifference.ValueDifference<String>> entriesDiffering = null;
    @Inject
    @Named(value="languageName")
    private String languageName;
    @Inject
    private IDialogSettings dialogSettings;
    @Inject
    private PreferenceStoreAccessImpl preferenceStoreAccessImpl;
    protected static final String REBUILD_COUNT_KEY = "preferences_build_requested";
    final List<Triple<String, String, DESCR_TYPE>> components;

    public AbstractN4JSPreferencePage(ArrayList<Triple<String, String, DESCR_TYPE>> components) {
        this.components = components;
        this.blockStatus = new StatusInfo();
        this.blockEnableState = null;
        this.project = null;
        this.pageData = null;
        this.entriesDiffering = null;
    }

    protected abstract IComponentProperties<DESCR_TYPE>[] getComponentPropertiesValues();

    protected abstract void refreshAttributes();

    private ComponentDetailsFieldEditor doCreateField(IPreferenceStore preferenceStore) {
        return new ComponentDetailsFieldEditor("outlet", "Registered compilers", this.getFieldEditorParent(), preferenceStore, this.components){

            @Override
            protected IComponentProperties<?>[] getComponentProperties() {
                return AbstractN4JSPreferencePage.this.getComponentPropertiesValues();
            }
        };
    }

    protected Label createDescriptionLabel(Composite parent) {
        this.parentComposite = parent;
        if (this.isProjectPreferencePage()) {
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            IDialogFieldListener listener = new IDialogFieldListener(){

                public void dialogFieldChanged(DialogField dialogField) {
                    boolean enabled = ((SelectionButtonDialogField)dialogField).isSelected();
                    AbstractN4JSPreferencePage.this.enableProjectSpecificSettings(enabled);
                    AbstractN4JSPreferencePage.this.projectSpecificChanged = true;
                    if (enabled && AbstractN4JSPreferencePage.this.getData() != null) {
                        AbstractN4JSPreferencePage.this.applyData(AbstractN4JSPreferencePage.this.getData());
                    }
                }
            };
            this.useProjectSettings = new SelectionButtonDialogField(32);
            this.useProjectSettings.setDialogFieldListener(listener);
            this.useProjectSettings.setLabelText(Messages.PropertyAndPreferencePage_useprojectsettings_label);
            this.useProjectSettings.doFillIntoGrid(composite, 1);
            LayoutUtil.setHorizontalGrabbing((Control)this.useProjectSettings.getSelectionButton(null));
            if (this.offerLink()) {
                this.changeWorkspaceSettings = this.createLink(composite, Messages.PropertyAndPreferencePage_useworkspacesettings_change);
                this.changeWorkspaceSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            } else {
                LayoutUtil.setHorizontalSpan((Control)this.useProjectSettings.getSelectionButton(null), (int)2);
            }
            Label horizontalLine = new Label(composite, 258);
            horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            horizontalLine.setFont(composite.getFont());
        } else if (this.supportsProjectSpecificOptions() && this.offerLink()) {
            this.changeWorkspaceSettings = this.createLink(parent, Messages.PropertyAndPreferencePage_showprojectspecificsettings_label);
            this.changeWorkspaceSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        }
        return super.createDescriptionLabel(parent);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        GridData data = new GridData(4, 4, true, true);
        this.configurationBlockControl = super.createContents(composite);
        this.configurationBlockControl.setLayoutData((Object)data);
        if (this.isProjectPreferencePage()) {
            boolean useProjectSpecificSettings = this.hasProjectSpecificOptions();
            this.enableProjectSpecificSettings(useProjectSpecificSettings);
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void applyData(Object data) {
        if (data instanceof Map) {
            this.pageData = (Map)data;
        }
        if (this.changeWorkspaceSettings != null && !this.offerLink()) {
            this.changeWorkspaceSettings.dispose();
            this.parentComposite.layout(true, true);
        }
    }

    protected void createFieldEditors() {
        this.refreshAttributes();
        IPreferenceStore preferenceStore = this.preferenceStoreAccessImpl.getWritablePreferenceStore((Object)this.getProject());
        this.field = this.doCreateField(preferenceStore);
        this.addField((FieldEditor)this.field);
    }

    protected boolean processChanges(IWorkbenchPreferenceContainer container) {
        return true;
    }

    public boolean performOk() {
        IWorkbenchPreferenceContainer container = (IWorkbenchPreferenceContainer)this.getContainer();
        if (!this.processChanges(container)) {
            return false;
        }
        boolean retVal = super.performOk();
        if (retVal && this.isProjectPreferencePage()) {
            try {
                IPreferenceStore preferenceStore = this.preferenceStoreAccessImpl.getWritablePreferenceStore((Object)this.getProject());
                if (preferenceStore instanceof IPersistentPreferenceStore) {
                    ((IPersistentPreferenceStore)preferenceStore).save();
                }
            }
            catch (Exception e) {
                System.err.println(e);
                retVal = false;
            }
        }
        return retVal;
    }

    private static void applyToStatusLine(DialogPage page, IStatus status) {
        String message = status.getMessage();
        if (message != null && message.length() == 0) {
            message = null;
        }
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(message, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }

    protected void savePreferences() {
        try {
            if (this.getPreferenceStore() instanceof IPersistentPreferenceStore) {
                ((IPersistentPreferenceStore)this.getPreferenceStore()).save();
            }
        }
        catch (IOException e) {
            Status status = new Status(4, N4JSActivator.getInstance().getBundle().getSymbolicName(), "Unexpected internal error: ", (Throwable)e);
            N4JSActivator.getInstance().getLog().log((IStatus)status);
        }
    }

    public Map<String, MapDifference.ValueDifference<String>> getPreferenceChanges() {
        if (this.entriesDiffering == null) {
            for (Triple<String, String, DESCR_TYPE> compiler : this.components) {
                ComponentDescriptor compilerDescriptor = (ComponentDescriptor)compiler.getThird();
                String outputName = (String)compiler.getFirst();
                boolean initialLoad = false;
                ComponentDescriptor currentlyStoredCompilerDescriptor = compilerDescriptor.getCurrentlyStoredComponentDescriptor();
                if (currentlyStoredCompilerDescriptor == null) {
                    currentlyStoredCompilerDescriptor = compilerDescriptor;
                    initialLoad = true;
                }
                Map originalSettings = currentlyStoredCompilerDescriptor.fillMap(outputName);
                List<IPreferenceStore> preferenceStores = this.field.getPreferenceStores();
                ComponentDescriptor newCompilerDescriptor = compilerDescriptor.copy();
                for (IPreferenceStore preferenceStore : preferenceStores) {
                    this.setDescriptorValuesFromPreferences(preferenceStore, outputName, newCompilerDescriptor);
                }
                Map currentSettings = newCompilerDescriptor.fillMap(outputName);
                Map<String, MapDifference.ValueDifference<String>> changes = this.getPreferenceChanges(originalSettings, currentSettings);
                if (!initialLoad) {
                    compilerDescriptor.setChanges(changes);
                }
                compilerDescriptor.setCurrentlyStoredComponentDescriptor(newCompilerDescriptor);
            }
            this.entriesDiffering = new HashMap<String, MapDifference.ValueDifference<String>>();
            for (Triple<String, String, DESCR_TYPE> compiler : this.components) {
                this.entriesDiffering.putAll(((ComponentDescriptor)compiler.getThird()).getChanges());
            }
        }
        return this.entriesDiffering;
    }

    private void setDescriptorValuesFromPreferences(IPreferenceStore preferenceStore, String outputName, DESCR_TYPE newCompilerDescriptor) {
        IComponentProperties<DESCR_TYPE>[] iComponentPropertiesArray = this.getComponentPropertiesValues();
        int n = iComponentPropertiesArray.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentProperties<DESCR_TYPE> prop = iComponentPropertiesArray[n2];
            if (preferenceStore.contains(prop.getKey(outputName))) {
                if (prop.getType() == Boolean.class) {
                    prop.setValueInCompilerDescriptor(newCompilerDescriptor, outputName, (Object)preferenceStore.getBoolean(prop.getKey(outputName)));
                } else {
                    prop.setValueInCompilerDescriptor(newCompilerDescriptor, outputName, (Object)preferenceStore.getString(prop.getKey(outputName)));
                }
            }
            ++n2;
        }
    }

    private Map<String, MapDifference.ValueDifference<String>> getPreferenceChanges(Map<String, String> originalSettings, Map<String, String> currentSettings) {
        MapDifference mapDifference = Maps.difference(currentSettings, originalSettings);
        return mapDifference.entriesDiffering();
    }

    public IAdaptable getElement() {
        return this.project;
    }

    public void setElement(IAdaptable element) {
        this.project = (IProject)element.getAdapter(IResource.class);
        this.setDescription(null);
    }

    protected IProject getProject() {
        return this.project;
    }

    protected boolean isProjectPreferencePage() {
        return this.project != null;
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        this.useProjectSettings.setSelection(useProjectSpecificSettings);
        this.enablePreferenceContent(useProjectSpecificSettings);
        this.updateLinkVisibility();
        this.doStatusChanged();
        this.useProjectSpecificSettings(useProjectSpecificSettings);
    }

    private void useProjectSpecificSettings(boolean enable) {
        boolean hasProjectSpecificOption;
        boolean bl = hasProjectSpecificOption = this.disabledProjectSettings == null;
        if (enable != hasProjectSpecificOption && this.project != null) {
            IPreferenceStore preferenceStore = this.preferenceStoreAccessImpl.getWritablePreferenceStore((Object)this.getProject());
            if (enable) {
                for (Triple<String, String, DESCR_TYPE> compiler : this.components) {
                    CompilerProperties[] compilerPropertiesArray = CompilerProperties.values();
                    int n = compilerPropertiesArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CompilerProperties prop = compilerPropertiesArray[n2];
                        String curr = prop.getKey((String)compiler.getFirst());
                        String val = this.disabledProjectSettings.get(curr);
                        preferenceStore.putValue(curr, val);
                        ++n2;
                    }
                }
                this.disabledProjectSettings = null;
                this.getPreferenceStore().setValue(IS_PROJECT_SPECIFIC, true);
                try {
                    this.getProject().setPersistentProperty(new QualifiedName(this.qualifiedName(), IS_PROJECT_SPECIFIC), String.valueOf(true));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            } else {
                this.disabledProjectSettings = Maps.newHashMap();
                for (Triple<String, String, DESCR_TYPE> compiler : this.components) {
                    CompilerProperties[] compilerPropertiesArray = CompilerProperties.values();
                    int n = compilerPropertiesArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        CompilerProperties prop = compilerPropertiesArray[n3];
                        String curr = prop.getKey((String)compiler.getFirst());
                        String oldSetting = preferenceStore.getString(curr);
                        this.disabledProjectSettings.put(curr, oldSetting);
                        preferenceStore.setToDefault(curr);
                        ++n3;
                    }
                }
                this.getPreferenceStore().setToDefault(IS_PROJECT_SPECIFIC);
                try {
                    this.getProject().setPersistentProperty(new QualifiedName(this.qualifiedName(), IS_PROJECT_SPECIFIC), String.valueOf(false));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void enablePreferenceContent(boolean enable) {
        if (enable) {
            if (this.blockEnableState != null) {
                this.blockEnableState.restore();
                this.blockEnableState = null;
            }
        } else if (this.blockEnableState == null) {
            this.blockEnableState = ControlEnableState.disable((Control)this.configurationBlockControl);
        }
    }

    private void updateLinkVisibility() {
        if (this.changeWorkspaceSettings == null || this.changeWorkspaceSettings.isDisposed()) {
            return;
        }
        if (this.isProjectPreferencePage()) {
            this.changeWorkspaceSettings.setEnabled(!this.useProjectSettings());
        }
    }

    protected void doStatusChanged() {
        if (!this.isProjectPreferencePage() || this.useProjectSettings()) {
            this.updateStatus(this.blockStatus);
        } else {
            this.updateStatus((IStatus)new StatusInfo());
        }
    }

    protected boolean useProjectSettings() {
        return this.isProjectPreferencePage() && this.useProjectSettings != null && this.useProjectSettings.isSelected();
    }

    private void updateStatus(IStatus status) {
        this.setValid(!status.matches(4));
        AbstractN4JSPreferencePage.applyToStatusLine((DialogPage)this, status);
    }

    protected Map<Object, Object> getData() {
        return this.pageData;
    }

    protected boolean offerLink() {
        return this.pageData == null || !Boolean.TRUE.equals(this.pageData.get(DATA_NO_LINK));
    }

    protected boolean supportsProjectSpecificOptions() {
        return true;
    }

    private Link createLink(Composite composite, String text) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractN4JSPreferencePage.this.doLinkActivated();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractN4JSPreferencePage.this.doLinkActivated();
            }
        });
        return link;
    }

    final void doLinkActivated() {
        Map<Object, Object> data = this.getData();
        if (data == null) {
            data = new HashMap<Object, Object>();
        }
        data.put(DATA_NO_LINK, Boolean.TRUE);
        if (this.isProjectPreferencePage()) {
            this.openWorkspacePreferences(data);
        } else {
            IProject[] projects;
            HashSet projectsWithSpecifics = Sets.newHashSet();
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject proj = iProjectArray[n2];
                if (XtextProjectHelper.hasNature((IProject)proj) && this.hasProjectSpecificOptions()) {
                    projectsWithSpecifics.add(proj);
                }
                ++n2;
            }
            ProjectSelectionDialog dialog = new ProjectSelectionDialog(this.getShell(), (Set)projectsWithSpecifics, this.dialogSettings);
            if (dialog.open() == 0) {
                IProject proj = (IProject)dialog.getFirstResult();
                this.openProjectProperties(proj, data);
            }
        }
    }

    protected final void openWorkspacePreferences(Object data) {
        String id = this.getPreferencePageID();
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, (Object)data).open();
    }

    public boolean hasProjectSpecificOptions() {
        return this.getPreferenceStore().getBoolean(IS_PROJECT_SPECIFIC);
    }

    protected final void openProjectProperties(IProject proj, Object data) {
        String id = this.getPropertyPageID();
        if (id != null) {
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)proj, (String)id, (String[])new String[]{id}, (Object)data).open();
        }
    }

    protected String getPreferencePageID() {
        return String.valueOf(this.languageName) + ".compiler.preferencePage";
    }

    protected String getPropertyPageID() {
        return String.valueOf(this.languageName) + ".compiler.propertyPage";
    }

    @Override
    public int compare(Triple<String, String, DESCR_TYPE> left, Triple<String, String, DESCR_TYPE> right) {
        return ((String)left.getSecond()).compareTo((String)right.getSecond());
    }
}

