/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.xtext.ui.util.JREContainerProvider;
import org.eclipse.xtext.ui.util.Messages;
import org.eclipse.xtext.ui.util.ProjectFactory;

public class JavaProjectFactory
extends ProjectFactory {
    private static final Logger logger = Logger.getLogger(JavaProjectFactory.class);
    private List<IClasspathEntry> extraClasspathEntries = Lists.newArrayList();
    private String defaultOutput = "bin";
    private IClasspathEntry jreContainerEntry;
    private Map<String, String> sourceFolderOutputs = new HashMap<String, String>();
    private Set<String> testSourceFolders = new HashSet<String>();

    @Override
    protected void enhanceProject(IProject project, SubMonitor monitor, Shell shell) throws CoreException {
        super.enhanceProject(project, monitor, shell);
        if (this.builderIds.contains("org.eclipse.jdt.core.javabuilder")) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            try {
                subMonitor.subTask(String.valueOf(Messages.JavaProjectFactory_ConfigureJavaProject) + this.projectName);
                IJavaProject javaProject = JavaCore.create((IProject)project);
                ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
                IProject[] iProjectArray = project.getReferencedProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject referencedProject = iProjectArray[n2];
                    IClasspathEntry referencedProjectClasspathEntry = JavaCore.newProjectEntry((IPath)referencedProject.getFullPath());
                    classpathEntries.add(referencedProjectClasspathEntry);
                    ++n2;
                }
                for (String folderName : this.folders) {
                    IClasspathAttribute[] iClasspathAttributeArray;
                    IFolder sourceFolder = project.getFolder(folderName);
                    String outputFolderName = this.sourceFolderOutputs.get(folderName);
                    IPath iPath = sourceFolder.getFullPath();
                    IPath iPath2 = outputFolderName == null ? null : project.getFolder(outputFolderName).getFullPath();
                    if (this.testSourceFolders.contains(folderName)) {
                        IClasspathAttribute[] iClasspathAttributeArray2 = new IClasspathAttribute[1];
                        iClasspathAttributeArray = iClasspathAttributeArray2;
                        iClasspathAttributeArray2[0] = JavaCore.newClasspathAttribute((String)"test", (String)"true");
                    } else {
                        iClasspathAttributeArray = new IClasspathAttribute[]{};
                    }
                    IClasspathEntry srcClasspathEntry = JavaCore.newSourceEntry((IPath)iPath, (IPath[])ClasspathEntry.INCLUDE_ALL, (IPath[])ClasspathEntry.EXCLUDE_NONE, (IPath)iPath2, (IClasspathAttribute[])iClasspathAttributeArray);
                    classpathEntries.add(srcClasspathEntry);
                }
                classpathEntries.addAll(this.extraClasspathEntries);
                IClasspathEntry defaultJREContainerEntry = this.getJreContainerEntry();
                classpathEntries.add(defaultJREContainerEntry);
                this.addMoreClasspathEntriesTo(classpathEntries);
                javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), (IProgressMonitor)subMonitor.newChild(1));
                javaProject.setOutputLocation((IPath)new Path("/" + project.getName() + "/" + this.defaultOutput), (IProgressMonitor)subMonitor.newChild(1));
                String executionEnvironmentId = JavaRuntime.getExecutionEnvironmentId((IPath)defaultJREContainerEntry.getPath());
                if (executionEnvironmentId != null) {
                    BuildPathSupport.setEEComplianceOptions((IJavaProject)javaProject, (String)executionEnvironmentId, null);
                }
            }
            catch (JavaModelException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private IClasspathEntry getJreContainerEntry() {
        if (this.jreContainerEntry == null) {
            return JREContainerProvider.getDefaultJREContainerEntry();
        }
        return this.jreContainerEntry;
    }

    public void setJreContainerEntry(IClasspathEntry jreContainerEntry) {
        this.jreContainerEntry = jreContainerEntry;
    }

    protected void addMoreClasspathEntriesTo(List<IClasspathEntry> classpathEntries) {
    }

    public JavaProjectFactory addClasspathEntries(IClasspathEntry ... classpathEntries) {
        this.extraClasspathEntries.addAll(Arrays.asList(classpathEntries));
        return this;
    }

    public List<IClasspathEntry> getExtraClasspathEntries() {
        return this.extraClasspathEntries;
    }

    @Override
    public JavaProjectFactory addBuilderIds(String ... builderIds) {
        return (JavaProjectFactory)super.addBuilderIds(builderIds);
    }

    @Override
    public JavaProjectFactory addFolders(List<String> folders) {
        return (JavaProjectFactory)super.addFolders(folders);
    }

    @Override
    public JavaProjectFactory setProjectName(String projectName) {
        return (JavaProjectFactory)super.setProjectName(projectName);
    }

    @Override
    public JavaProjectFactory addProjectNatures(String ... projectNatures) {
        return (JavaProjectFactory)super.addProjectNatures(projectNatures);
    }

    @Override
    public JavaProjectFactory addReferencedProjects(List<IProject> referencedProjects) {
        return (JavaProjectFactory)super.addReferencedProjects(referencedProjects);
    }

    @Override
    public JavaProjectFactory setLocation(IPath location) {
        return (JavaProjectFactory)super.setLocation(location);
    }

    @Override
    public JavaProjectFactory addWorkingSets(List<IWorkingSet> workingSets) {
        return (JavaProjectFactory)super.addWorkingSets(workingSets);
    }

    public JavaProjectFactory setDefaultOutput(String defaultOutput) {
        this.defaultOutput = defaultOutput;
        return this;
    }

    public JavaProjectFactory addSourceFolder(String path, String output, boolean isTest) {
        this.addFolders((List)Collections.singletonList(path));
        this.sourceFolderOutputs.put(path, output);
        if (isTest) {
            this.testSourceFolders.add(path);
        }
        return this;
    }
}

