/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.packagejson;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.BiConsumer;
import org.eclipse.n4js.json.JSON.JSONArray;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONFactory;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.n4js.json.model.utils.JSONModelUtils;
import org.eclipse.n4js.packagejson.PackageJsonProperties;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectDescription.SourceContainerType;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

class PackageJsonContentProvider {
    PackageJsonContentProvider() {
    }

    static JSONDocument getModel(String projectName, Optional<String> version, ProjectType type, Optional<String> vendorId, Optional<String> vendorName, Optional<String> output, Optional<String> extendedRE, SortedMap<String, String> dependencies, Iterable<String> providedRL, Iterable<String> requiredRL, Optional<String> implementationId, Iterable<String> implementedProjects, Iterable<String> testedProjects, Map<SourceContainerType, String> sourceContainers) {
        boolean _isEmpty_4;
        boolean _not_4;
        boolean _isEmpty_3;
        boolean _not_3;
        boolean _isPresent_5;
        boolean _isPresent_4;
        boolean _isEmpty_2;
        boolean _not_2;
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _isPresent_2;
        boolean _isEmpty;
        boolean _not;
        JSONObject root = JSONFactory.eINSTANCE.createJSONObject();
        JSONModelUtils.addProperty((JSONObject)root, (String)PackageJsonProperties.NAME.name, (String)projectName);
        boolean _isPresent = version.isPresent();
        if (_isPresent) {
            JSONModelUtils.addProperty((JSONObject)root, (String)PackageJsonProperties.VERSION.name, (String)((String)version.get()));
        }
        boolean bl = _not = !(_isEmpty = dependencies.isEmpty());
        if (_not) {
            JSONObject dependenciesSection = JSONFactory.eINSTANCE.createJSONObject();
            Functions.Function1 _function = e -> {
                NameValuePair pair = JSONFactory.eINSTANCE.createNameValuePair();
                pair.setName((String)e.getKey());
                pair.setValue((JSONValue)JSONModelUtils.createStringLiteral((String)((String)e.getValue())));
                return pair;
            };
            Iterables.addAll((Collection)dependenciesSection.getNameValuePairs(), (Iterable)IterableExtensions.map(dependencies.entrySet(), (Functions.Function1)_function));
            JSONModelUtils.addProperty((JSONObject)root, (String)PackageJsonProperties.DEPENDENCIES.name, (JSONValue)dependenciesSection);
        }
        JSONObject n4jsRoot = (JSONObject)JSONModelUtils.addProperty((JSONObject)root, (String)PackageJsonProperties.N4JS.name, (JSONValue)JSONFactory.eINSTANCE.createJSONObject());
        JSONModelUtils.addProperty((JSONObject)n4jsRoot, (String)PackageJsonProperties.PROJECT_TYPE.name, (String)PackageJsonContentProvider.getEnumAsString(type));
        boolean _isPresent_1 = vendorId.isPresent();
        if (_isPresent_1) {
            JSONModelUtils.addProperty((JSONObject)n4jsRoot, (String)PackageJsonProperties.VENDOR_ID.name, (String)((String)vendorId.get()));
        }
        if (_isPresent_2 = vendorName.isPresent()) {
            JSONModelUtils.addProperty((JSONObject)n4jsRoot, (String)PackageJsonProperties.VENDOR_NAME.name, (String)((String)vendorName.get()));
        }
        JSONObject sourcesSection = (JSONObject)JSONModelUtils.addProperty((JSONObject)n4jsRoot, (String)PackageJsonProperties.SOURCES.name, (JSONValue)JSONFactory.eINSTANCE.createJSONObject());
        Functions.Function1 _function_1 = e -> ((SourceContainerType)e.getKey()).getLiteral();
        Functions.Function1 _function_2 = e -> (SourceContainerType)e.getKey();
        BiConsumer<SourceContainerType, List> _function_3 = (containerType, paths) -> {
            JSONArray typeSectionArray = (JSONArray)JSONModelUtils.addProperty((JSONObject)sourcesSection, (String)containerType.getLiteral().toLowerCase(), (JSONValue)JSONFactory.eINSTANCE.createJSONArray());
            Functions.Function1 _function_4 = pathEntry -> JSONModelUtils.createStringLiteral((String)((String)pathEntry.getValue()));
            List pathLiterals = ListExtensions.map((List)paths, (Functions.Function1)_function_4);
            typeSectionArray.getElements().addAll((Collection)pathLiterals);
        };
        IterableExtensions.groupBy((Iterable)IterableExtensions.sortBy(sourceContainers.entrySet(), (Functions.Function1)_function_1), (Functions.Function1)_function_2).forEach(_function_3);
        boolean _isPresent_3 = output.isPresent();
        if (_isPresent_3) {
            JSONModelUtils.addProperty((JSONObject)n4jsRoot, (String)PackageJsonProperties.OUTPUT.name, (String)((String)output.get()));
        }
        boolean bl2 = _not_1 = !(_isEmpty_1 = IterableExtensions.isEmpty(providedRL));
        if (_not_1) {
            JSONModelUtils.addProperty((JSONObject)n4jsRoot, (String)PackageJsonProperties.PROVIDED_RUNTIME_LIBRARIES.name, (JSONValue)JSONModelUtils.createStringArray(providedRL));
        }
        boolean bl3 = _not_2 = !(_isEmpty_2 = IterableExtensions.isEmpty(requiredRL));
        if (_not_2) {
            JSONModelUtils.addProperty((JSONObject)n4jsRoot, (String)PackageJsonProperties.REQUIRED_RUNTIME_LIBRARIES.name, (JSONValue)JSONModelUtils.createStringArray(requiredRL));
        }
        if (_isPresent_4 = extendedRE.isPresent()) {
            JSONModelUtils.addProperty((JSONObject)n4jsRoot, (String)PackageJsonProperties.EXTENDED_RUNTIME_ENVIRONMENT.name, (String)((String)extendedRE.get()));
        }
        if (_isPresent_5 = implementationId.isPresent()) {
            JSONModelUtils.addProperty((JSONObject)n4jsRoot, (String)PackageJsonProperties.IMPLEMENTATION_ID.name, (String)((String)implementationId.get()));
        }
        boolean bl4 = _not_3 = !(_isEmpty_3 = IterableExtensions.isEmpty(implementedProjects));
        if (_not_3) {
            JSONModelUtils.addProperty((JSONObject)n4jsRoot, (String)PackageJsonProperties.IMPLEMENTED_PROJECTS.name, (JSONValue)JSONModelUtils.createStringArray(implementedProjects));
        }
        boolean bl5 = _not_4 = !(_isEmpty_4 = IterableExtensions.isEmpty(testedProjects));
        if (_not_4) {
            JSONModelUtils.addProperty((JSONObject)n4jsRoot, (String)PackageJsonProperties.TESTED_PROJECTS.name, (JSONValue)JSONModelUtils.createStringArray(testedProjects));
        }
        JSONDocument document = JSONFactory.eINSTANCE.createJSONDocument();
        document.setContent((JSONValue)root);
        return document;
    }

    private static String getEnumAsString(ProjectType projectType) {
        boolean _equals = Objects.equal((Object)projectType, (Object)ProjectType.RUNTIME_ENVIRONMENT);
        if (_equals) {
            return "runtimeEnvironment";
        }
        boolean _equals_1 = Objects.equal((Object)projectType, (Object)ProjectType.RUNTIME_LIBRARY);
        if (_equals_1) {
            return "runtimeLibrary";
        }
        return projectType.getName().toLowerCase();
    }
}

