/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.preferences.external;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.utils.StatusHelper;
import org.eclipse.n4js.utils.StatusUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class UninstallNpmDependencyButtonListener
extends SelectionAdapter {
    private final Supplier<IInputValidator> validator;
    private final StatusHelper statusHelper;
    private final BiFunction<Collection<String>, IProgressMonitor, IStatus> uninstallAction;
    private final Supplier<String> initalValue;

    UninstallNpmDependencyButtonListener(BiFunction<Collection<String>, IProgressMonitor, IStatus> uninstallAction, Supplier<IInputValidator> validator, StatusHelper statusHelper, Supplier<String> initalValue) {
        this.statusHelper = statusHelper;
        this.validator = validator;
        this.uninstallAction = uninstallAction;
        this.initalValue = initalValue;
    }

    public void widgetSelected(SelectionEvent e) {
        block11: {
            InputDialog dialog = new InputDialog(UIUtils.getShell(), "npm Uninstall", "Specify an npm package name to uninstall:", this.initalValue.get(), this.validator.get());
            dialog.open();
            String packageName = dialog.getValue();
            MultiStatus multistatus = this.statusHelper.createMultiStatus("Uninstalling npm '" + packageName + "'.");
            if (!StringExtensions.isNullOrEmpty((String)packageName) && dialog.getReturnCode() == 0) {
                try {
                    new ProgressMonitorDialog(UIUtils.getShell()).run(true, true, monitor -> multistatus.merge(this.uninstallAction.apply(Arrays.asList(packageName), monitor)));
                }
                catch (InterruptedException | OperationCanceledException throwable) {
                    if (!multistatus.isOK()) {
                        N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
                        UIUtils.getDisplay().asyncExec(() -> {
                            String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                            ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Uninstall Failed", (String)descr, (IStatus)multistatus);
                        });
                    }
                    break block11;
                }
                catch (Exception exc) {
                    try {
                        String msg = "Error while uninstalling npm dependency: '" + packageName + "'.";
                        Throwable causingExc = exc.getCause() == null ? exc : exc.getCause();
                        multistatus.merge(this.statusHelper.createError(msg, causingExc));
                    }
                    catch (Throwable throwable) {
                        if (!multistatus.isOK()) {
                            N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
                            UIUtils.getDisplay().asyncExec(() -> {
                                String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                                ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Uninstall Failed", (String)descr, (IStatus)multistatus);
                            });
                        }
                        throw throwable;
                    }
                    if (!multistatus.isOK()) {
                        N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
                        UIUtils.getDisplay().asyncExec(() -> {
                            String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                            ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Uninstall Failed", (String)descr, (IStatus)multistatus);
                        });
                    }
                    break block11;
                }
                if (!multistatus.isOK()) {
                    N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
                    UIUtils.getDisplay().asyncExec(() -> {
                        String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                        ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Uninstall Failed", (String)descr, (IStatus)multistatus);
                    });
                }
            }
        }
    }
}

