/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.factories;

import java.util.LinkedList;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.factories.DelegatingNodeFactory;
import org.eclipse.n4js.flowgraphs.factories.ListUtils;
import org.eclipse.n4js.flowgraphs.factories.ReentrantASTIterator;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.DelegatingNode;
import org.eclipse.n4js.flowgraphs.model.HelperNode;
import org.eclipse.n4js.flowgraphs.model.JumpToken;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.flowgraphs.model.RepresentingNode;
import org.eclipse.n4js.n4JS.BreakStatement;
import org.eclipse.n4js.n4JS.ContinueStatement;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.ThrowStatement;

class JumpFactory {
    JumpFactory() {
    }

    static ComplexNode buildComplexNode(ReentrantASTIterator astpp, BreakStatement stmt) {
        JumpToken jumptoken = new JumpToken(ControlFlowType.Break, stmt.getLabel());
        return JumpFactory.buildComplexNode(astpp, (Statement)stmt, null, jumptoken);
    }

    static ComplexNode buildComplexNode(ReentrantASTIterator astpp, ContinueStatement stmt) {
        JumpToken jumptoken = new JumpToken(ControlFlowType.Continue, stmt.getLabel());
        return JumpFactory.buildComplexNode(astpp, (Statement)stmt, null, jumptoken);
    }

    static ComplexNode buildComplexNode(ReentrantASTIterator astpp, ReturnStatement stmt) {
        JumpToken jumptoken = new JumpToken(ControlFlowType.Return);
        return JumpFactory.buildComplexNode(astpp, (Statement)stmt, stmt.getExpression(), jumptoken);
    }

    static ComplexNode buildComplexNode(ReentrantASTIterator astpp, ThrowStatement stmt) {
        JumpToken jumptoken = new JumpToken(ControlFlowType.Throw);
        return JumpFactory.buildComplexNode(astpp, (Statement)stmt, stmt.getExpression(), jumptoken);
    }

    static ComplexNode buildComplexNode(ReentrantASTIterator astpp, Statement stmt, Expression expr, JumpToken jumptoken) {
        ComplexNode cNode = new ComplexNode(astpp.container(), (ControlFlowElement)stmt);
        HelperNode entryNode = new HelperNode("entry", astpp.pos(), (ControlFlowElement)stmt);
        cNode.addNode(entryNode);
        DelegatingNode expression = null;
        if (expr != null) {
            expression = DelegatingNodeFactory.create(astpp, "expression", (ControlFlowElement)stmt, (ControlFlowElement)expr);
            cNode.addNode(expression);
        }
        RepresentingNode jumpNode = new RepresentingNode("jump", astpp.pos(), (ControlFlowElement)stmt);
        cNode.addNode(jumpNode);
        HelperNode exitNode = new HelperNode("exit", astpp.pos(), (ControlFlowElement)stmt);
        cNode.addNode(exitNode);
        LinkedList<Node> cfs = new LinkedList<Node>();
        cfs.add(entryNode);
        cfs.add(expression);
        cNode.connectInternalSucc(entryNode, expression);
        Node beforeDeadNode = ListUtils.filterNulls(entryNode, expression).getLast();
        cNode.connectInternalSucc(beforeDeadNode, jumpNode);
        cNode.connectInternalSucc(ControlFlowType.DeadCode, jumpNode, exitNode);
        jumpNode.addJumpToken(jumptoken);
        cNode.setEntryNode(entryNode);
        cNode.setExitNode(exitNode);
        cNode.setJumpNode(jumpNode);
        return cNode;
    }
}

