/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.jsdoc.N4JSDocletParser;
import org.eclipse.n4js.jsdoc.dom.Doclet;
import org.eclipse.n4js.jsdoc.dom.DomFactory;
import org.eclipse.xtext.documentation.IEObjectDocumentationProviderExtension;
import org.eclipse.xtext.nodemodel.INode;

public class N4JSDocHelper {
    @Inject
    private IEObjectDocumentationProviderExtension documentationProviderExt;

    public String getDoc(EObject element) {
        if (element == null) {
            throw new IllegalArgumentException("element must not be null");
        }
        if (element.eIsProxy()) {
            return null;
        }
        List docNodes = this.documentationProviderExt.getDocumentationNodes(element);
        if (!docNodes.isEmpty()) {
            StringBuilder sb = new StringBuilder(((INode)docNodes.get(0)).getText());
            int idx = 1;
            while (idx < docNodes.size()) {
                sb.append("\n").append(((INode)docNodes.get(idx)).getText());
                ++idx;
            }
            return sb.toString();
        }
        return null;
    }

    public String getDocSafely(ResourceSet resourceSetForDocRetrieval, EObject element) {
        ResourceSet resSet;
        if (resourceSetForDocRetrieval == null) {
            throw new IllegalArgumentException("resourceSetForDocRetrieval may not be null");
        }
        if (element == null || element.eIsProxy()) {
            throw new IllegalArgumentException("element may not be null or a proxy");
        }
        Resource res = element.eResource();
        ResourceSet resourceSet = resSet = res != null ? res.getResourceSet() : null;
        if (resSet == null || res == null) {
            throw new IllegalArgumentException("element must be contained in a resource set");
        }
        if (resourceSetForDocRetrieval != resSet) {
            Resource resSafe = resourceSetForDocRetrieval.getResource(res.getURI(), true);
            EObject elementSafe = resSafe.getEObject(res.getURIFragment(element));
            return elementSafe != null ? this.getDoc(elementSafe) : null;
        }
        return this.getDoc(element);
    }

    public Doclet getDoclet(EObject element) {
        return this.getDoclet(this.getDoc(element));
    }

    public Doclet getDocletSafely(ResourceSet resourceSetForDocRetrieval, EObject element) {
        return this.getDoclet(this.getDocSafely(resourceSetForDocRetrieval, element));
    }

    public Doclet getDoclet(String docStr) {
        if (docStr == null || docStr.trim().length() == 0) {
            return DomFactory.eINSTANCE.createDoclet();
        }
        N4JSDocletParser docletParser = new N4JSDocletParser();
        return docletParser.parse(docStr);
    }
}

